/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.app.Activity;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseIntArray;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.core.CameraInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.utils.KLPCameraInfo;

public final class CameraUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();

    static {
        ORIENTATIONS.append(0, 0);
        ORIENTATIONS.append(1, 90);
        ORIENTATIONS.append(2, 180);
        ORIENTATIONS.append(3, 270);
    }

    @SourceDebugExtension(value={"SMAP\nCameraUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraUtils.kt\nvn/kalapa/ekyc/utils/CameraUtils$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,143:1\n11335#2:144\n11670#2,3:145\n*S KotlinDebug\n*F\n+ 1 CameraUtils.kt\nvn/kalapa/ekyc/utils/CameraUtils$Companion\n*L\n109#1:144\n109#1:145,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> getCameraResolutionStrings(CameraCharacteristics object) {
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)object.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap != null && (streamConfigurationMap = streamConfigurationMap.getOutputSizes(256)) != null) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList(((Size[])streamConfigurationMap).length);
                for (Size size : streamConfigurationMap) {
                    object.add(size.getWidth() + "x" + size.getHeight());
                }
            } else {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private final String getHardwareLevelString(int n) {
            String string2;
            switch (n) {
                default: {
                    string2 = "UNKNOWN";
                    break;
                }
                case 4: {
                    string2 = "EXTERNAL";
                    break;
                }
                case 3: {
                    string2 = "LEVEL_3";
                    break;
                }
                case 2: {
                    string2 = "LEGACY";
                    break;
                }
                case 1: {
                    string2 = "FULL";
                    break;
                }
                case 0: {
                    string2 = "LIMITED";
                }
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final float getCameraFov(@NotNull CameraInfo object) {
            Float f2;
            CameraInfo cameraInfo = object;
            Intrinsics.checkNotNullParameter((Object)cameraInfo, (String)"cameraInfo");
            Companion companion = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
            Intrinsics.checkNotNullExpressionValue((Object)companion, (String)"extractCameraCharacteristics(cameraInfo)");
            float[] fArray = (float[])companion.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
            object = fArray;
            float f3 = fArray != null && (f2 = ArraysKt.maxOrNull((float[])object)) != null ? f2.floatValue() : 0.0f;
            float f4 = object != null && (object = ArraysKt.minOrNull((float[])object)) != null ? ((Float)object).floatValue() : 0.0f;
            companion = (SizeF)companion.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
            float f5 = companion != null ? companion.getWidth() : 0.0f;
            float f6 = companion != null ? companion.getHeight() : 0.0f;
            Helpers.Companion companion2 = Helpers.Companion;
            companion2.printLog("cameraInfo maxFocalLength " + f3 + " minFocalLength " + f4 + " sensorWidth " + f5 + " sensorHeight " + f6 + " ");
            float f7 = 2;
            f6 = f7 * (float)Math.atan(f5 / (f7 * f3));
            f4 = f6 * (float)180 / 3.14f;
            companion2.printLog("cameraInfo FOV: " + f6 + " " + f4);
            return f4;
        }

        public final int getRotationCompensation(@NotNull String string2, @NotNull Activity activity, boolean bl) {
            Activity activity2 = activity;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"cameraId");
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            int n = ORIENTATIONS.get(activity2.getWindowManager().getDefaultDisplay().getRotation());
            Object object = activity2.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            Object object2 = ((CameraManager)object).getCameraCharacteristics(string2).get(CameraCharacteristics.SENSOR_ORIENTATION);
            Intrinsics.checkNotNull((Object)object2);
            int n2 = ((Number)object2).intValue();
            return bl ? (n2 + n) % 360 : (n2 - n + 360) % 360;
        }

        @NotNull
        public final String listToString(@Nullable List<KLPCameraInfo> object) {
            ArrayList arrayList;
            boolean bl = object == null || object.isEmpty();
            if (bl) {
                return "";
            }
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                arrayList2.add(((KLPCameraInfo)object.next()).toString());
            }
            return CollectionsKt.joinToString$default((Iterable)arrayList2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final List<KLPCameraInfo> listCameraCharacteristics(@NotNull Context object) {
            ArrayList arrayList;
            Context context = object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            object = arrayList;
            arrayList = new ArrayList();
            Object object2 = context.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            CameraManager cameraManager = (CameraManager)object2;
            String[] stringArray = cameraManager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraManager.cameraIdList");
            int n = stringArray.length;
            for (int k = 0; k < n; ++k) {
                KLPCameraInfo kLPCameraInfo;
                int n2;
                Integer n3;
                int n4;
                float[] fArray;
                List<String> list;
                Object object3;
                block34: {
                    CameraCharacteristics cameraCharacteristics;
                    block33: {
                        Integer n5;
                        block32: {
                            block31: {
                                CameraManager cameraManager2 = cameraManager;
                                object3 = stringArray[k];
                                cameraCharacteristics = cameraManager2.getCameraCharacteristics((String)object3);
                                CameraCharacteristics cameraCharacteristics2 = cameraCharacteristics;
                                Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics2, (String)"cameraManager.getCameraCharacteristics(cameraId)");
                                list = this.getCameraResolutionStrings(cameraCharacteristics2);
                                fArray = (float[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
                                if (fArray != null) break block31;
                                fArray = new float[]{};
                            }
                            n5 = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                            if (n5 != null) break block32;
                            n5 = 0;
                        }
                        CameraCharacteristics cameraCharacteristics3 = cameraCharacteristics;
                        n4 = n5;
                        n3 = (Integer)cameraCharacteristics3.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                        if (n3 != null) break block33;
                        n3 = -1;
                    }
                    CameraCharacteristics cameraCharacteristics4 = cameraCharacteristics;
                    n2 = n3;
                    n3 = (Integer)cameraCharacteristics4.get(CameraCharacteristics.LENS_FACING);
                    if (n3 != null) break block34;
                    n3 = -1;
                }
                Object object4 = object;
                int n6 = n3;
                Helpers.Companion companion = Helpers.Companion;
                Helpers.Companion companion2 = companion;
                Helpers.Companion companion3 = companion;
                Helpers.Companion companion4 = companion;
                Helpers.Companion companion5 = companion;
                Helpers.Companion companion6 = companion;
                Object[] objectArray = new Object[2];
                objectArray[0] = "CameraInfo";
                int n7 = 1;
                objectArray[n7] = "Camera ID: " + (String)object3;
                companion3.printLog(objectArray);
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "CameraInfo";
                n7 = 1;
                objectArray2[n7] = "Resolution: " + list;
                companion4.printLog(objectArray2);
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = "CameraInfo";
                n7 = 1;
                objectArray3[n7] = "Focal Lengths: " + ArraysKt.joinToString$default((float[])fArray, null, null, null, (int)0, null, null, (int)63, null);
                companion5.printLog(objectArray3);
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = "CameraInfo";
                n7 = 1;
                objectArray4[n7] = "Orientation: " + n4;
                companion6.printLog(objectArray4);
                Object[] objectArray5 = new Object[2];
                Object[] objectArray6 = objectArray5;
                objectArray6[0] = "CameraInfo";
                int n8 = 1;
                objectArray5[n8] = "Hardware Level: " + this.getHardwareLevelString(n2);
                companion2.printLog(objectArray5);
                KLPCameraInfo kLPCameraInfo2 = kLPCameraInfo;
                KLPCameraInfo kLPCameraInfo3 = kLPCameraInfo;
                List<String> list2 = list;
                float[] fArray2 = fArray;
                object3 = n6;
                try {
                    kLPCameraInfo2(list2, fArray2, n4, n2, (Integer)object3);
                    ((ArrayList)object4).add(kLPCameraInfo3);
                }
                catch (Exception exception) {
                    Helpers.Companion.printLog("CameraInfo", "Error accessing camera: " + exception.getMessage());
                    break;
                }
                continue;
            }
            return object;
        }
    }
}

