package vn.kalapa.ekyc.codescanner

import android.annotation.SuppressLint
import android.graphics.Color
import android.os.Build
import android.os.Handler
import android.os.Looper
import android.util.Size
import android.view.ScaleGestureDetector
import android.view.WindowManager
import android.widget.ImageView
import android.widget.TextView
import androidx.camera.core.FocusMeteringAction
import androidx.camera.core.ImageAnalysis
import androidx.camera.core.resolutionselector.ResolutionSelector
import androidx.camera.core.resolutionselector.ResolutionStrategy
import androidx.cardview.widget.CardView
import vn.kalapa.R
import vn.kalapa.ekyc.KalapaQRCodeHandler
import vn.kalapa.ekyc.KalapaSDK
import vn.kalapa.ekyc.activity.CameraXActivity
import vn.kalapa.ekyc.managers.KLPLanguageManager
import vn.kalapa.ekyc.utils.Common.Companion.vibratePhone
import vn.kalapa.ekyc.utils.Helpers
import vn.kalapa.ekyc.utils.KALAPA_LOG_ACTION
import vn.kalapa.ekyc.utils.KALAPA_LOG_LEVEL
import vn.kalapa.ekyc.utils.LogUtil.logEvent


class ScanQrCodeActivity : CameraXActivity(activityLayoutId = R.layout.activity_scan_qr_code) {
    //    private lateinit var cardMaskView: CardMaskView
    private lateinit var ivPreviewImage: ImageView
    private lateinit var tvTitle: TextView
//    private lateinit var tvGuide0: TextView
    private lateinit var tvGuide1: TextView
    private lateinit var ivGuide: ImageView
    private lateinit var containerView: CardView
    private lateinit var qrDetectionView: QrDetectionView
    private var qrCodeAnalyzer = QRCodeAnalyzer(
        onSuccess = { barCode, image ->
            Helpers.printLog("QRCodeAnalyzer ${barCode.rawValue.toString()}")
            if (barCode.boundingBox == null || isAnimating) {
                return@QRCodeAnalyzer
            }
            Helpers.printLog("QRCode  ${image.width} ${image.height}")
            isAnimating = true
            stopCamera()
            qrDetectionView.showDetection(
                barCode.boundingBox!!,
                image.width,
                image.height,
            ) {
                qrDetectionView.hideDetection()
            }

            vibratePhone(this)
            if (KalapaSDK.isHandlerInitialized()) {
                isAnimating = false
                KalapaSDK.rawQRCodeScanned = barCode.rawValue ?: ""
                Helpers.printLog("Process: ${barCode.rawValue.toString()}")
                (KalapaSDK.handler as KalapaQRCodeHandler).process(
                    barCode.rawValue.toString(),
                    this@ScanQrCodeActivity
                )
                logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.SCAN_QR_SUCCESS, SCREEN_ID, mapOf("qr_code" to barCode.rawValue.toString()))
            }
        },
        onFailure = {
            Helpers.printLog("QRCodeAnalyzer onFailure")
        },
        onPassCompleted = {
//                            Helpers.printLog("QRCodeAnalyzer onPassCompleted")
        },
        suggestZoomRatio = { ratio ->
//                            camera?.cameraControl?.setZoomRatio(ratio)
        }
    )
    private var isAnimating = false
    private var stopAutoFocus = false
    private val scaleGestureDetector =
        object : ScaleGestureDetector.SimpleOnScaleGestureListener() {
            override fun onScale(detector: ScaleGestureDetector): Boolean {
                if (camera != null) {
                    val scale =
                        camera?.cameraInfo?.zoomState?.value?.zoomRatio?.times(detector.scaleFactor)
                    if (scale != null) {
                        camera?.cameraControl?.setZoomRatio(scale)
                    }
                    return true
                }
                return false
            }
        }

    override fun setupCustomUI() {
        Helpers.printLog("ScanQrCodeActivity setupCustomUI")
        qrDetectionView = findViewById(R.id.qrDetectionView)
        ivGuide = findViewById(R.id.iv_action)
        ivPreviewImage = findViewById(R.id.iv_preview_image)
        ivPreviewImage.isDrawingCacheEnabled = false
        tvTitle = findViewById(R.id.tv_title)
        tvGuide1 = findViewById(R.id.tv_guide)
//        tvGuide0 = findViewById(R.id.tv_guide_0)
        ivGuide.setColorFilter(Color.parseColor(KalapaSDK.config.mainColor))
        containerView = findViewById(R.id.container_preview)
        tvTitle.text =
            KLPLanguageManager.get(resources.getString(R.string.klp_scan_qr_code))
        tvTitle.setTextColor((Color.parseColor("#FFFFFF")))
        tvGuide1.text = KLPLanguageManager.get(resources.getString(R.string.klp_scan_qr_code_guide))
        Helpers.setColorTintList(findViewById(R.id.iv_close_ekyc), "#FFFFFF")
        tvGuide1.setTextColor(Color.parseColor("#FFFFFF"))
        val window = window
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS)
        window.statusBarColor = Color.BLACK
    }

    override fun setupAnalyzer(): ImageAnalysis {
        return ImageAnalysis.Builder()
            .setBackpressureStrategy(ImageAnalysis.STRATEGY_KEEP_ONLY_LATEST)
            .setResolutionSelector(
                ResolutionSelector.Builder().setResolutionStrategy(
                    ResolutionStrategy(
                        Size(1800, 3200),
                        ResolutionStrategy.FALLBACK_RULE_CLOSEST_HIGHER_THEN_LOWER,
                    ),
                ).build()
            )
            .build()
            .also {
                it.setAnalyzer(
                    cameraExecutor,
                    qrCodeAnalyzer
                )
            }
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun handleZoom() {
        val scaleGestureDetector = ScaleGestureDetector(this, scaleGestureDetector)
        viewFinder.post {
            val centerX = viewFinder.width / 2f
            val centerY = viewFinder.height / 2f
            val point = viewFinder.meteringPointFactory.createPoint(centerX, centerY)
            val action = FocusMeteringAction.Builder(point).build()
            camera?.cameraControl?.startFocusAndMetering(action)
        }
        viewFinder.setOnTouchListener { _, event ->
            scaleGestureDetector.onTouchEvent(event)
            val centerX = viewFinder.width / 2f
            val centerY = viewFinder.height / 2f
            val point = viewFinder.meteringPointFactory.createPoint(centerX, centerY)
            val action = FocusMeteringAction.Builder(point).build()
            camera?.cameraControl?.startFocusAndMetering(action)
            return@setOnTouchListener true
        }
    }

    private fun focusOnCenter() {
        if (stopAutoFocus) return
        val centerX = viewFinder.width / 2f
        val centerY = viewFinder.height / 2f
        val point = viewFinder.meteringPointFactory.createPoint(centerX, centerY)
        val action = FocusMeteringAction.Builder(point).build()
        camera?.cameraControl?.startFocusAndMetering(action)
        Handler(Looper.getMainLooper()).postDelayed({
            focusOnCenter()
        }, 1000)
    }


    override fun onDestroy() {
        super.onDestroy()
        qrDetectionView.hideDetection()
    }

    override fun onCaptureSuccess(rotationDegree: Int) {
    }

    override fun onResume() {
        super.onResume()
        stopAutoFocus = false
        focusOnCenter()
    }

    override fun onPause() {
        super.onPause()
        stopAutoFocus = true
        focusOnCenter()
    }

    override fun verifyImage() {

    }

    override fun onBackBtnClicked() {
        showEndEKYC()
    }

    override fun onInfoBtnClicked() {
    }

    override fun sendError(message: String?) {
        Helpers.printLog("sendError: $message")

        Helpers.showDialog(
            this@ScanQrCodeActivity,
            KLPLanguageManager.get(resources.getString(R.string.klp_invalid_qr_code_title)),
            if (message != null && message != "Invalid QR code format") message else KLPLanguageManager.get(resources.getString(R.string.klp_invalid_qr_code)),
            R.drawable.klp_invalid_qr_code, true
        ) {
            qrDetectionView.hideDetection()
            startCamera()
            qrCodeAnalyzer.reset()
        }
    }

    override fun sendDone(nextAction: () -> Unit) {
        Helpers.printLog("sendDone: ")
        nextAction()
        finish()
    }

    override fun sendExpired() {
        super.sendExpired()
    }
}