package vn.kalapa.ekyc.handlers

import android.app.Activity
import android.content.Context
import android.os.AsyncTask
import vn.kalapa.ekyc.models.KalapaCDNObj
import vn.kalapa.ekyc.models.KalapaLanguageVersion
import vn.kalapa.ekyc.utils.Common
import vn.kalapa.ekyc.utils.Helpers
import java.io.BufferedReader
import java.io.InputStreamReader
import java.lang.ref.WeakReference
import java.net.HttpURLConnection
import java.net.URL

class GetLanguageVersionHandler(context: Context) : AsyncTask<String, Void, KalapaLanguageVersion?>() {
    val context: WeakReference<Context> = WeakReference(context)


    @Deprecated("Deprecated in Java")
    override fun doInBackground(vararg params: String?): KalapaLanguageVersion? {
        context.get()?.let {
            if (Common.isOnline(it)) {
                return try {
                    getConfigVersion(params[0]!!, params[1]!!, params[2]!!)?.let { it1 -> KalapaLanguageVersion.fromJson(it1) }
                } catch (exception: Exception) {
                    null
                }
            }
        }
        return null
    }

    private fun getConfigVersion(baseUrl: String, language: String, customer: String): String? {
        val url = URL("$baseUrl/lang/versions?language=$language&type=ekyc_mobile${if (customer.isNotEmpty()) "&customer=$customer" else ""}")

        var body = ""
        Helpers.printLog("\nSent 'GET' request to URL : $url")
        with(url.openConnection() as HttpURLConnection) {
            requestMethod = "GET"
            connect()
            Helpers.printLog("\nSent 'GET' request to URL : $url; Response Code : $responseCode")
            if (responseCode == 200) {
                val reader = BufferedReader(InputStreamReader(inputStream))
                body = reader.readText()
                reader.close()
            } else {
                Helpers.printLog("GET request not worked")
            }
        }
        return body.ifEmpty { null }
    }


}