package vn.kalapa.ekyc.nfcsdk.activities

import android.annotation.SuppressLint
import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ScrollView
import android.widget.TextView
import android.widget.Toast
import com.fis.ekyc.nfc.build_in.model.ResultCode
import com.fis.nfc.sdk.nfc.stepNfc.NFCUtils
import vn.kalapa.R
import vn.kalapa.ekyc.DialogListener
import vn.kalapa.ekyc.*
import vn.kalapa.ekyc.capturesdk.CameraXMRZActivity
import vn.kalapa.ekyc.managers.KLPLanguageManager
import vn.kalapa.ekyc.managers.KLPNFCUtils
import vn.kalapa.ekyc.utils.Common
import vn.kalapa.ekyc.utils.Helpers
import vn.kalapa.ekyc.utils.KALAPA_LOG_ACTION
import vn.kalapa.ekyc.utils.KALAPA_LOG_LEVEL
import vn.kalapa.ekyc.utils.LogUtil.logEvent
import vn.kalapa.ekyc.views.ProgressView
import vn.kalapa.kalapasdk.nfcsdk.activities.BaseNFCActivity
import java.util.Date

class NFCActivity : BaseNFCActivity(), DialogListener {
    private val TAG = NFCActivity::class.java.simpleName
    private val nfcUtils: KLPNFCUtils by lazy {
        KLPNFCUtils(this@NFCActivity)
    }
    private var mrz: String? = null
    private var idCardNumber: String? = null
    private var transactionId: String? = null
    private lateinit var llPleaseMakeSure: LinearLayout
    private lateinit var tvTitle: TextView
    private lateinit var ivNFCIcon: ImageView
    private lateinit var scrollview: ScrollView
    private lateinit var btnSkip: Button

    private fun validateMRZOrOpenMRZScanner() {
        if (intent.getStringExtra("mrz") != null) {
            mrz = intent.getStringExtra("mrz")
            idCardNumber = Common.getIdCardNumberFromMRZOrQRCode(mrz ?: "")
            Helpers.printLog("idCardNumber: $idCardNumber from mrz $mrz")
        }
        if (idCardNumber == null || idCardNumber == "-1") {
            if (idCardNumber == "-1") {
                Helpers.showDialog(
                    this@NFCActivity,
                    KLPLanguageManager.get(resources.getString(R.string.klp_error_occurred_title)),
                    KLPLanguageManager.get(resources.getString(R.string.klp_error_invalid_format)), null
                ) {
                    openMRZScanner()
                }
            } else
                openMRZScanner()
        } else
            nfcUtils.setIdCardNumber(idCardNumber)
    }

    override fun onDestroy() {
        nfcUtils.setListener(null)
        mrz = ""
        Helpers.printLog("remove startTimeoutEvent")
        timeoutHandler?.removeCallbacksAndMessages(null)
        nfcUtils.deinit()
        timeoutHandler = null
        super.onDestroy()
    }

    override fun getIntentData() {
        KLPNFCUtils.checkNFCCapacity(this@NFCActivity, {
            validateMRZOrOpenMRZScanner()
        }, {
            // Do nothing
        })
    }

    private fun openMRZScanner() {
        val intent = Intent(this@NFCActivity, CameraXMRZActivity::class.java)
        startActivity(intent)
        finish()
    }

    private fun startTimeoutEvent() {
        Helpers.printLog("startTimeoutEvent")
        timeoutHandler = Handler(Looper.getMainLooper())
        timeoutHandler?.postDelayed({
            if (KalapaSDK.ekycFlow == KalapaFlowType.NFC_EKYC) { // Show SKIP button after x min
                btnSkip.visibility = View.VISIBLE
                btnSkip.setOnClickListener {
                    logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.TAP_SKIP, SCREEN_ID)
                    KalapaSDK.handler.onNFCSkipButtonClicked(this@NFCActivity)
                }
            } else
                if (!nfcUnderScanning) {
                    Helpers.printLog("showBottomError from handler timeout")
                    logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.NFC_TIMEOUT, SCREEN_ID)
                    showBottomError()
                }
        }, TIMEOUT.toLong())
    }

    override fun onPostCreated() {
        super.onPostCreated()
        llPleaseMakeSure = findViewById(R.id.ll_please_make_sure)
        btnSkip = findViewById(R.id.btn_skip_nfc)
        btnSkip.visibility = View.GONE
        ivNFCIcon = findViewById(R.id.iv_nfc_icon)
        Helpers.setColorTintList(ivNFCIcon, KalapaSDK.config.mainColor)
        Helpers.setBackgroundColorTintList(btnSkip, KalapaSDK.config.mainColor)
        btnSkip.setTextColor(Color.parseColor(KalapaSDK.config.mainColor))
        btnSkip.text = KLPLanguageManager.get(resources.getString(R.string.klp_nfc_skip))
        initNFC()
    }


    override fun onButtonScanClicked() {
        if (nfcUnderScanning) Toast.makeText(
            this@NFCActivity,
            KLPLanguageManager.get(resources.getString(R.string.klp_please_wait)),
            Toast.LENGTH_LONG
        ).show()
        isNFCFinished = false
        isNFCSucceed = false
        nfcUtils.forceCall = true
        nfcUtils.callOnPause()
        nfcUtils.callOnResume()
        showBottomSheet()
        logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.NFC_START_LISTEN, SCREEN_ID, mapOf("idCardNumber" to idCardNumber))
    }

    override fun onUserSkip() {
        KalapaSDK.handler.onError(KalapaSDKResultCode.USER_LEAVE)
        finish()
    }

    override fun onSucceeded() {
//        TODO("Not yet implemented")
//        if (KalapaSDK.flowType == FaceOTPFlowType.ONBOARD) {
//            startLivenessForFaceData()
//        } else {
//            KalapaNFC.nfcListener?.onSuccess("")
//        }
    }

    override fun onNotAvailable() {
//        TODO("Not yet implemented")
//        KalapaNFC.nfcListener?.onCheckNFCAvailable(NFCAvailablityStatus.NOT_ENABLED)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        tvTitle = findViewById(R.id.tv_title)
        tvTitle.text = KLPLanguageManager.get(resources.getString(R.string.klp_nfc_title))
        tvTitle.setTextColor(Color.parseColor(KalapaSDK.config.mainTextColor))
        scrollview = findViewById(R.id.scrollView)
        scrollview.post {
            scrollview.fullScroll(View.FOCUS_DOWN)
        }
    }

    override fun onNFCRetryClicked() {
        btnScanNFC.callOnClick()
        timeoutHandler?.removeCallbacksAndMessages(null)
        timeoutHandler = null
        startTimeoutEvent()
    }

    fun getMesageFromErrorCode(errorCode: ResultCode?): String {
        return when (errorCode) {
            ResultCode.CANNOT_OPEN_DEVICE -> KLPLanguageManager.get(
                resources.getString(R.string.klp_nfc_not_support)
            )

            ResultCode.CARD_LOST_CONNECTION -> KLPLanguageManager.get(
                resources.getString(R.string.klp_nfc_error_card_lost_connection)
            )

            ResultCode.CARD_NOT_FOUND -> KLPLanguageManager.get(
                resources.getString(
                    R.string.klp_nfc_error_wrong_id_card
                )
            )

            ResultCode.SUCCESS_WITH_WARNING -> KLPLanguageManager.get(
                resources.getString(R.string.klp_nfc_read_successfully)
            )

            ResultCode.UNKNOWN -> KLPLanguageManager.get(
                resources.getString(
                    R.string.klp_error_unknown
                )
            )

            ResultCode.WRONG_CCCDID -> KLPLanguageManager.get(
                resources.getString(R.string.klp_error_nfc_mrz_and_chip_not_match)
            )

            else -> ""
        }
    }

    private fun initNFC() {
        var startScanNFC = Date()
        nfcUtils.init(this@NFCActivity)
            .setListener(object : NFCUtils.NFCListener {
                override fun OnSuccess(p0: String?) {
                    val endScanNFC = Date()
                    logEvent(
                        this@NFCActivity,
                        KALAPA_LOG_LEVEL.INFO,
                        KALAPA_LOG_ACTION.NFC_TAP_SUCCESS,
                        SCREEN_ID,
                        mapOf("exceed_time" to "${endScanNFC.time - startScanNFC.time}")
                    )
                    runOnUiThread {
                        if (bottomSheetDialog.isShowing && !isBottomSheetGuide)
                            (bottomSheetDialog.findViewById(R.id.iv_gif) as ImageView).setImageDrawable(
                                gifSucess
                            )
                    }
                    isNFCFinished = true
                    ProgressView.hideProgress()
                    //data result here
                    Helpers.printLog("NFCActivity initNFC OnSuccess $p0")
                    btnScanNFC.visibility = View.VISIBLE
                    runOnUiThread {
                        Toast.makeText(
                            this@NFCActivity,
                            KLPLanguageManager.get(resources.getString(R.string.klp_nfc_read_successfully)),
                            Toast.LENGTH_LONG
                        ).show()
                    }
                    runOnUiThread {
                        ProgressView.showProgress(this@NFCActivity)
                    }
                    (KalapaSDK.handler as KalapaNFCHandler).process(
                        Common.getIdCardNumberFromMRZOrQRCode(mrz)!!,
                        p0!!,
                        this@NFCActivity
                    )
                }

                override fun OnFail(p0: String?) {
                    //message on fail
                    Helpers.printLog("NFCActivity initNFC  OnFail $p0")
                    logEvent(
                        this@NFCActivity,
                        KALAPA_LOG_LEVEL.ERROR,
                        KALAPA_LOG_ACTION.NFC_TAP_FAIL,
                        SCREEN_ID,
                        mapOf("error" to (p0 ?: ""))
                    )
                    onNFCErrorHandleUI(p0)
                    (bottomSheetDialog.findViewById<ImageView>(R.id.iv_gif)!!).setImageDrawable(
                        gifError
                    )
                    (bottomSheetDialog.findViewById<TextView>(R.id.tv_title)!!).text =
                        KLPLanguageManager.get(resources.getString(R.string.klp_error_occurred_title))
                }

                override fun OnError(p0: ResultCode?) {
                    //error with code here
                    logEvent(
                        this@NFCActivity,
                        KALAPA_LOG_LEVEL.ERROR,
                        KALAPA_LOG_ACTION.NFC_ERROR,
                        SCREEN_ID,
                        mapOf("error" to (p0?.name ?: ""))
                    )
                    runOnUiThread {
                        Helpers.printLog("NFCActivity initNFC  OnError $p0")
                        ProgressView.hideProgress()
                        p0?.let {
                            if (it == ResultCode.WRONG_CCCDID) {
                                hideBottomSheet()
                                removeTimeoutHandlerCallbackAndMessage()
                                Helpers.showDialog(
                                    this@NFCActivity, KLPLanguageManager.get(resources.getString(R.string.klp_error_occurred_title)),
                                    KLPLanguageManager.get(resources.getString(R.string.klp_error_nfc_mrz_and_chip_not_match)), null
                                ) {
                                    openMRZScanner()
                                }
//                                KalapaSDK.handler.onNFCErrorHandle(this@NFCActivity, KalapaScanNFCError.ERROR_NFC_INVALID, this@NFCActivity)
                            } else {
                                if (bottomSheetDialog.isShowing && !isBottomSheetGuide)
                                    (bottomSheetDialog.findViewById<ImageView>(R.id.iv_gif)!!).setImageDrawable(gifError)
                                onNFCErrorHandleUI(getMesageFromErrorCode(it))
                            }
                        }
                    }
                }

                @SuppressLint("CutPasteId")
                override fun OnStartProcess() {
                    logEvent(
                        this@NFCActivity,
                        KALAPA_LOG_LEVEL.INFO,
                        KALAPA_LOG_ACTION.NFC_TAP_CARD,
                        SCREEN_ID,
                    )
                    logEvent(
                        this@NFCActivity,
                        KALAPA_LOG_LEVEL.INFO,
                        KALAPA_LOG_ACTION.NFC_START,
                        SCREEN_ID,
                    )
                    if (!bottomSheetDialog.isShowing)
                        showBottomSheet()
                    else {
                        bottomSheetDialog.dismiss()
                        showBottomSheet()
                    }
                    (bottomSheetDialog.findViewById(R.id.iv_gif) as ImageView).setImageDrawable(
                        readingGif
                    )
                    //show progress or something with your UI here
                    Helpers.printLog("NFCActivity initNFC  onStartProcess")
                    nfcUnderScanning = true
                    (bottomSheetDialog.findViewById(R.id.text_status) as TextView).visibility =
                        View.VISIBLE
                    (bottomSheetDialog.findViewById(R.id.text_status) as TextView).text =
                        KLPLanguageManager.get(resources.getString(R.string.klp_nfc_reading_title_reading))
                    (bottomSheetDialog.findViewById(R.id.text_des) as TextView).text =
                        KLPLanguageManager.get(resources.getString(R.string.klp_nfc_reading_message_2))
                    (bottomSheetDialog.findViewById(R.id.text_des) as TextView).setTextColor(
                        Color.parseColor(KalapaSDK.config.mainTextColor)
                    )
                    (bottomSheetDialog.findViewById(R.id.text_status) as TextView).setTextColor(
                        Color.parseColor(KalapaSDK.config.mainTextColor)
                    )

                }

                override fun OnProcessFinished() {
                    //hide progress or something with your UI here
                    nfcUnderScanning = false
                    Helpers.printLog("NFCActivity initNFC onProcessFinished")
                }

                override fun CheckNFCAvailable(p0: Int) {
                    //result of NFC status
                    Helpers.printLog("NFCActivity initNFC OnNFCAvailable $p0")
                    runOnUiThread {
                        isNFCSupport = p0 >= 0
                        isNFCNotEnabled = p0 == 0
                        Helpers.printLog("NFCActivity initNFC isNFCSupport $isNFCSupport isNFCNotEnabled $isNFCNotEnabled")
                        if (!isNFCNotEnabled && isNFCSupport) {
                            tvError.setTextColor(resources.getColor(R.color.ekyc_green))
                            tvError.visibility = View.INVISIBLE
                            btnScanNFC.visibility = View.VISIBLE
                            llPleaseMakeSure.visibility = View.VISIBLE
                            llShowPosition.visibility = View.VISIBLE
                            btnScanNFC.text =
                                KLPLanguageManager.get(resources.getString(R.string.klp_nfc_button_start))
                            btnScanNFC.setOnClickListener {
                                onButtonScanClicked()
                            }
                        } else {
                            llPleaseMakeSure.visibility = View.GONE
                            llShowPosition.visibility = View.GONE
                            nfcUtils.forceCall = false
                            btnScanNFC.visibility = View.GONE
                            tvError.text =
                                if (isNFCNotEnabled) {
                                    logEvent(
                                        this@NFCActivity,
                                        KALAPA_LOG_LEVEL.WARN,
                                        KALAPA_LOG_ACTION.NFC_ERROR,
                                        SCREEN_ID,
                                        mapOf("error" to "NFC_NOT_ENABLED")
                                    )
                                    btnScanNFC.visibility = View.VISIBLE
                                    btnScanNFC.text =
                                        KLPLanguageManager.get(resources.getString(R.string.klp_button_confirm))
                                    btnScanNFC.setOnClickListener {
                                        KLPNFCUtils.openNFCSetting(this@NFCActivity)
                                    }
                                    KLPLanguageManager.get(
                                        resources.getString(
                                            R.string.klp_nfc_error_not_enabled
                                        )
                                    )
                                } else {
                                    logEvent(
                                        this@NFCActivity,
                                        KALAPA_LOG_LEVEL.WARN,
                                        KALAPA_LOG_ACTION.NFC_ERROR,
                                        SCREEN_ID,
                                        mapOf("error" to "DEVICE_NOT_SUPPORTED")
                                    )
                                    btnScanNFC.visibility = View.VISIBLE
                                    btnScanNFC.text =
                                        KLPLanguageManager.get(resources.getString(R.string.klp_button_confirm))
                                    btnScanNFC.setOnClickListener {
                                        KalapaSDK.handler.onError(KalapaSDKResultCode.DEVICE_NOT_SUPPORTED)
                                        finish()
                                    }
                                    KLPLanguageManager.get(resources.getString(R.string.klp_nfc_not_support))
                                }

                            tvError.setTextColor(resources!!.getColor(R.color.ekyc_red))
                            tvError.visibility = View.VISIBLE
                            bottomSheetDialog.dismiss()
                        }
                    }

                }

            })

    }


    override fun sendError(errorMess: String?) {
        Helpers.printLog("callback onError $errorMess")
        errorMess?.let {
            logEvent(
                this@NFCActivity,
                KALAPA_LOG_LEVEL.ERROR,
                KALAPA_LOG_ACTION.NFC_FAIL,
                SCREEN_ID,
                mapOf("error" to it)
            )
        }

        ProgressView.hideProgress()
        if (errorMess != null && errorMess.contains(";")) {
            val errorArr = errorMess.split(";")
            removeTimeoutHandlerCallbackAndMessage()
            Helpers.printLog("NFCActivity onNFCErrorHandle ${errorArr[0]} - ${errorArr[1]}")
            hideBottomSheet()
            KalapaSDK.handler.onNFCErrorHandle(this@NFCActivity, KalapaScanNFCError.fromErrorCode(errorArr[0]), this@NFCActivity)
        } else {
            if (System.currentTimeMillis() - startTime > TIMEOUT) {
                Helpers.printLog("showBottomError from onError $errorMess")
                showBottomError(errorMess)
            } else
                this.runOnUiThread {

                    val message = errorMess
                        ?: KLPLanguageManager.get(resources.getString(R.string.klp_liveness_result_fail))
                    Helpers.showDialog(
                        this@NFCActivity,
                        KLPLanguageManager.get(resources.getString(R.string.klp_error_occurred_title)),
                        message,
                        R.drawable.ic_warning
                    ) {
                        if (bottomSheetDialog.isShowing)
                            bottomSheetDialog.dismiss()
                    }
                    tvError.text = message
                }
        }
    }

//    override fun onDestroy() {
//        Helpers.dismissDialogIfNeeded()
//        super.onDestroy()
//    }

    override fun sendDone(nextAction: () -> Unit) {
        Helpers.printLog("callback sendDone")
        logEvent(this@NFCActivity, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.NFC_SUCCESS, SCREEN_ID)
        nextAction()
        runOnUiThread {
            ProgressView.hideProgress()
            if (bottomSheetDialog.isShowing) bottomSheetDialog.dismiss()
        }
        finish()
    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        nfcUtils.callOnNewIntent(intent)
    }

    override fun onResume() {
        Helpers.printLog("$TAG - onResume")
        super.onResume()
        startTimeoutEvent()
        nfcUtils.callOnResume()
    }

    override fun onPause() {
        super.onPause()
        nfcUtils.callOnPause()
        Helpers.printLog("remove startTimeoutEvent")
        timeoutHandler?.removeCallbacksAndMessages(null)
    }

    override fun hideBottomSheet() {
        super.hideBottomSheet()
        nfcUtils.callOnPause()
    }

    override fun onYes() {
        KalapaSDK.handler.onError(KalapaSDKResultCode.USER_LEAVE)
        finish()
    }

    override fun onNo() {
    }
}
