/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.CertId;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;

public class RevRepContent
extends ASN1Object {
    private ASN1Sequence status;
    private ASN1Sequence revCerts;
    private ASN1Sequence crls;

    private RevRepContent(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.status = ASN1Sequence.getInstance(object.nextElement());
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object.nextElement());
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.revCerts = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.crls = ASN1Sequence.getInstance(aSN1TaggedObject, true);
        }
    }

    public static RevRepContent getInstance(Object object) {
        if (object instanceof RevRepContent) {
            return (RevRepContent)object;
        }
        if (object != null) {
            return new RevRepContent(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public PKIStatusInfo[] getStatus() {
        int n = this.status.size();
        PKIStatusInfo[] pKIStatusInfoArray = new PKIStatusInfo[n];
        for (int k = 0; k != n; ++k) {
            pKIStatusInfoArray[k] = PKIStatusInfo.getInstance(this.status.getObjectAt(k));
        }
        return pKIStatusInfoArray;
    }

    public CertId[] getRevCerts() {
        ASN1Sequence aSN1Sequence = this.revCerts;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        CertId[] certIdArray = new CertId[n];
        for (int k = 0; k != n; ++k) {
            certIdArray[k] = CertId.getInstance(this.revCerts.getObjectAt(k));
        }
        return certIdArray;
    }

    public CertificateList[] getCrls() {
        ASN1Sequence aSN1Sequence = this.crls;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        CertificateList[] certificateListArray = new CertificateList[n];
        for (int k = 0; k != n; ++k) {
            certificateListArray[k] = CertificateList.getInstance(this.crls.getObjectAt(k));
        }
        return certificateListArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        RevRepContent revRepContent = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(aSN1Object.status);
        ASN1Object aSN1Object = revRepContent.revCerts;
        revRepContent.addOptional(aSN1EncodableVector2, 0, aSN1Object);
        aSN1Object = revRepContent.crls;
        revRepContent.addOptional(aSN1EncodableVector2, 1, aSN1Object);
        return new DERSequence(aSN1EncodableVector2);
    }
}

