/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import java.math.BigInteger;

public class IssuerAndSerialNumber
extends ASN1Object {
    public X500Name name;
    public ASN1Integer certSerialNumber;

    public static IssuerAndSerialNumber getInstance(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)object;
        }
        if (object != null) {
            return new IssuerAndSerialNumber(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private IssuerAndSerialNumber(ASN1Sequence aSN1Sequence) {
        this.name = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.certSerialNumber = (ASN1Integer)aSN1Sequence.getObjectAt(1);
    }

    public IssuerAndSerialNumber(X509Name x509Name, BigInteger bigInteger) {
        IssuerAndSerialNumber issuerAndSerialNumber = this;
        issuerAndSerialNumber.name = X500Name.getInstance(x509Name.toASN1Primitive());
        issuerAndSerialNumber.certSerialNumber = new ASN1Integer(bigInteger);
    }

    public IssuerAndSerialNumber(X509Name x509Name, ASN1Integer aSN1Integer) {
        this.name = X500Name.getInstance(x509Name.toASN1Primitive());
        this.certSerialNumber = aSN1Integer;
    }

    public IssuerAndSerialNumber(X500Name x500Name, BigInteger bigInteger) {
        ASN1Integer aSN1Integer;
        aSN1Object.name = x500Name;
        ASN1Object aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(bigInteger);
        v1.certSerialNumber = aSN1Object;
    }

    public X500Name getName() {
        return this.name;
    }

    public ASN1Integer getCertificateSerialNumber() {
        return this.certSerialNumber;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector2.add(this.name);
        aSN1EncodableVector.add(this.certSerialNumber);
        return new DERSequence(aSN1EncodableVector2);
    }
}

