/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.CryptoInfos;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.EncryptionInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EvidenceRecord
extends ASN1Object {
    private static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.11.0.2.1");
    private ASN1Integer version;
    private ASN1Sequence digestAlgorithms;
    private CryptoInfos cryptoInfos;
    private EncryptionInfo encryptionInfo;
    private ArchiveTimeStampSequence archiveTimeStampSequence;

    public static EvidenceRecord getInstance(Object object) {
        if (object instanceof EvidenceRecord) {
            return (EvidenceRecord)object;
        }
        if (object != null) {
            return new EvidenceRecord(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static EvidenceRecord getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EvidenceRecord.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private EvidenceRecord(EvidenceRecord var1_1, ArchiveTimeStampSequence var2_2, ArchiveTimeStamp var3_3) {
        super();
        this.version = new ASN1Integer(1L);
        this.version = var1_1.version;
        if (var3_3 == null) ** GOTO lbl-1000
        var3_3 = var3_3.getDigestAlgorithmIdentifier();
        var4_4 = v0;
        v0 = new ASN1EncodableVector();
        var5_5 = var1_1.digestAlgorithms.getObjects();
        var6_6 = false;
        while (var5_5.hasMoreElements()) {
            var7_7 = AlgorithmIdentifier.getInstance(var5_5.nextElement());
            var4_4.add(var7_7);
            if (!var7_7.equals(var3_3)) continue;
            var6_6 = true;
            break;
        }
        if (!var6_6) {
            var4_4.add(var3_3);
            var3_3 = v1;
            v1 = new DERSequence(var4_4);
            this.digestAlgorithms = var3_3;
        } else lbl-1000:
        // 2 sources

        {
            this.digestAlgorithms = var1_1.digestAlgorithms;
        }
        this.cryptoInfos = var1_1.cryptoInfos;
        this.encryptionInfo = var1_1.encryptionInfo;
        this.archiveTimeStampSequence = var2_2;
    }

    public EvidenceRecord(AlgorithmIdentifier[] algorithmIdentifierArray, CryptoInfos cryptoInfos, EncryptionInfo encryptionInfo, ArchiveTimeStampSequence archiveTimeStampSequence) {
        DERSequence dERSequence;
        ASN1Integer aSN1Integer;
        ASN1Object aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(1L);
        v1.version = aSN1Object;
        aSN1Object = dERSequence;
        dERSequence = new DERSequence(algorithmIdentifierArray);
        v1.digestAlgorithms = aSN1Object;
        v1.cryptoInfos = cryptoInfos;
        v1.encryptionInfo = encryptionInfo;
        v1.archiveTimeStampSequence = archiveTimeStampSequence;
    }

    private EvidenceRecord(ASN1Sequence aSN1Sequence) {
        this.version = new ASN1Integer(1L);
        if (aSN1Sequence.size() < 3 && aSN1Sequence.size() > 5) {
            throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("wrong sequence size in constructor: ")));
        }
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Integer.intValueExact() == 1) {
            this.version = aSN1Integer;
            this.digestAlgorithms = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            for (int k = 2; k != aSN1Sequence.size() - 1; ++k) {
                ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(k);
                if (aSN1Encodable instanceof ASN1TaggedObject) {
                    int n = ((ASN1TaggedObject)(aSN1Encodable = (ASN1TaggedObject)aSN1Encodable)).getTagNo();
                    if (n != 0) {
                        if (n == 1) {
                            this.encryptionInfo = EncryptionInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                            continue;
                        }
                        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a((ASN1TaggedObject)aSN1Encodable, b.b.a("unknown tag in getInstance: ")));
                    }
                    this.cryptoInfos = CryptoInfos.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                    continue;
                }
                throw new IllegalArgumentException(b.b.a("unknown object in getInstance: ").append(aSN1Encodable.getClass().getName()).toString());
            }
            ASN1Sequence aSN1Sequence2 = aSN1Sequence;
            this.archiveTimeStampSequence = ArchiveTimeStampSequence.getInstance(aSN1Sequence2.getObjectAt(aSN1Sequence2.size() - 1));
            return;
        }
        throw new IllegalArgumentException("incompatible version");
    }

    public AlgorithmIdentifier[] getDigestAlgorithms() {
        int n = this.digestAlgorithms.size();
        AlgorithmIdentifier[] algorithmIdentifierArray = new AlgorithmIdentifier[n];
        for (int k = 0; k != n; ++k) {
            algorithmIdentifierArray[k] = AlgorithmIdentifier.getInstance(this.digestAlgorithms.getObjectAt(k));
        }
        return algorithmIdentifierArray;
    }

    public ArchiveTimeStampSequence getArchiveTimeStampSequence() {
        return this.archiveTimeStampSequence;
    }

    public EvidenceRecord addArchiveTimeStamp(ArchiveTimeStamp archiveTimeStamp, boolean bl) {
        ArchiveTimeStampSequence archiveTimeStampSequence;
        if (bl) {
            ArchiveTimeStampChain archiveTimeStampChain;
            ArchiveTimeStampChain archiveTimeStampChain2 = archiveTimeStampChain;
            archiveTimeStampChain = new ArchiveTimeStampChain(archiveTimeStamp);
            EvidenceRecord evidenceRecord = aSN1Object;
            return new EvidenceRecord(evidenceRecord, evidenceRecord.archiveTimeStampSequence.append(archiveTimeStampChain2), archiveTimeStamp);
        }
        ArchiveTimeStampChain[] archiveTimeStampChainArray = aSN1Object.archiveTimeStampSequence.getArchiveTimeStampChains();
        ArchiveTimeStampChain[] archiveTimeStampChainArray2 = archiveTimeStampChainArray;
        int n = archiveTimeStampChainArray.length - 1;
        archiveTimeStampChainArray[n] = archiveTimeStampChainArray[archiveTimeStampChainArray.length - 1].append(archiveTimeStamp);
        EvidenceRecord evidenceRecord = aSN1Object;
        ASN1Object aSN1Object = archiveTimeStampSequence;
        archiveTimeStampSequence = new ArchiveTimeStampSequence(archiveTimeStampChainArray2);
        return new EvidenceRecord(evidenceRecord, (ArchiveTimeStampSequence)aSN1Object, null);
    }

    public String toString() {
        return b.b.a("EvidenceRecord: Oid(").append(OID).append(")").toString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithms);
        ASN1Object aSN1Object = this.cryptoInfos;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.encryptionInfo) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        aSN1EncodableVector2.add(this.archiveTimeStampSequence);
        return new DERSequence(aSN1EncodableVector2);
    }
}

