/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SRP6GroupParameters;
import java.math.BigInteger;

public class SRP6VerifierGenerator {
    public BigInteger N;
    public BigInteger g;
    public Digest digest;

    public void init(BigInteger bigInteger, BigInteger bigInteger2, Digest digest) {
        SRP6VerifierGenerator sRP6VerifierGenerator = this;
        sRP6VerifierGenerator.N = bigInteger;
        sRP6VerifierGenerator.g = bigInteger2;
        sRP6VerifierGenerator.digest = digest;
    }

    public void init(SRP6GroupParameters sRP6GroupParameters, Digest digest) {
        this.N = sRP6GroupParameters.getN();
        this.g = sRP6GroupParameters.getG();
        this.digest = digest;
    }

    public BigInteger generateVerifier(byte[] object, byte[] byArray, byte[] byArray2) {
        SRP6VerifierGenerator sRP6VerifierGenerator = this;
        object = SRP6Util.calculateX(sRP6VerifierGenerator.digest, this.N, object, byArray, byArray2);
        return sRP6VerifierGenerator.g.modPow((BigInteger)object, this.N);
    }
}

