/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.LongDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA384Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 48;

    public SHA384Digest() {
    }

    public SHA384Digest(SHA384Digest sHA384Digest) {
        super(sHA384Digest);
    }

    public SHA384Digest(byte[] byArray) {
        SHA384Digest sHA384Digest = this;
        sHA384Digest.restoreState(byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-384";
    }

    @Override
    public int getDigestSize() {
        return 48;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA384Digest sHA384Digest = this;
        sHA384Digest.finish();
        Pack.longToBigEndian(sHA384Digest.H1, byArray, n);
        Pack.longToBigEndian(sHA384Digest.H2, byArray, n + 8);
        Pack.longToBigEndian(sHA384Digest.H3, byArray, n + 16);
        Pack.longToBigEndian(sHA384Digest.H4, byArray, n + 24);
        Pack.longToBigEndian(sHA384Digest.H5, byArray, n + 32);
        Pack.longToBigEndian(sHA384Digest.H6, byArray, n + 40);
        sHA384Digest.reset();
        return 48;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
    }

    @Override
    public Memoable copy() {
        return new SHA384Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        super.copyIn((SHA384Digest)memoable);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[this.getEncodedStateSize()];
        super.populateState(byArray);
        return byArray;
    }
}

