/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.Primes;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    private static int getNumberOfIterations(int n, int n2) {
        if (n >= 1536) {
            return n2 <= 100 ? 3 : (n2 <= 128 ? 4 : (n2 - 128 + 1) / 2 + 4);
        }
        if (n >= 1024) {
            return n2 <= 100 ? 4 : (n2 <= 112 ? 5 : (n2 - 112 + 1) / 2 + 5);
        }
        if (n >= 512) {
            return n2 <= 80 ? 5 : (n2 <= 100 ? 7 : (n2 - 100 + 1) / 2 + 7);
        }
        return n2 <= 80 ? 40 : (n2 - 80 + 1) / 2 + 40;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Object object = null;
        boolean bl = false;
        int n = this.param.getStrength();
        int n2 = (n + 1) / 2;
        int n3 = n - n2;
        int n4 = n / 2;
        int n5 = n4 - 100;
        int n6 = n / 3;
        if (n5 < n6) {
            n5 = n6;
        }
        n6 = n >> 2;
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n4);
        BigInteger bigInteger2 = ONE;
        BigInteger bigInteger3 = bigInteger2.shiftLeft(n - 1);
        BigInteger bigInteger4 = bigInteger2.shiftLeft(n5);
        while (!bl) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters;
            RSAKeyParameters rSAKeyParameters;
            AsymmetricCipherKeyPair asymmetricCipherKeyPair;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7 = this.param.getPublicExponent();
            BigInteger bigInteger8 = this.chooseRandomPrime(n2, bigInteger7, bigInteger3);
            while (true) {
                if ((bigInteger6 = (bigInteger5 = this.chooseRandomPrime(n3, bigInteger7, bigInteger3)).subtract(bigInteger8).abs()).bitLength() < n5 || bigInteger6.compareTo(bigInteger4) <= 0) {
                    continue;
                }
                bigInteger6 = bigInteger8.multiply(bigInteger5);
                if (bigInteger6.bitLength() != n) {
                    bigInteger8 = bigInteger8.max(bigInteger5);
                    continue;
                }
                if (WNafUtil.getNafWeight(bigInteger6) >= n6) break;
                bigInteger8 = this.chooseRandomPrime(n2, bigInteger7, bigInteger3);
            }
            if (bigInteger8.compareTo(bigInteger5) < 0) {
                BigInteger bigInteger9 = bigInteger5;
                bigInteger5 = bigInteger8;
                bigInteger8 = bigInteger9;
            }
            BigInteger bigInteger10 = ONE;
            BigInteger bigInteger11 = bigInteger8.subtract(bigInteger10);
            BigInteger bigInteger12 = bigInteger7.modInverse(bigInteger11.divide(bigInteger11.gcd(bigInteger10 = bigInteger5.subtract(bigInteger10))).multiply(bigInteger10));
            if (bigInteger12.compareTo(bigInteger) <= 0) continue;
            BigInteger bigInteger13 = bigInteger12;
            bl = true;
            object = bigInteger13.remainder(bigInteger11);
            bigInteger10 = bigInteger13.remainder(bigInteger10);
            bigInteger11 = BigIntegers.modOddInverse(bigInteger8, bigInteger5);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = asymmetricCipherKeyPair;
            RSAKeyParameters rSAKeyParameters2 = rSAKeyParameters;
            rSAKeyParameters = new RSAKeyParameters(false, bigInteger6, bigInteger7);
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters2 = rSAPrivateCrtKeyParameters;
            rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(bigInteger6, bigInteger7, bigInteger12, bigInteger8, bigInteger5, (BigInteger)object, bigInteger10, bigInteger11);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(rSAKeyParameters2, rSAPrivateCrtKeyParameters2);
            object = asymmetricCipherKeyPair2;
        }
        return object;
    }

    public BigInteger chooseRandomPrime(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        for (int k = 0; k != n * 5; ++k) {
            BigInteger bigInteger3 = BigIntegers.createRandomPrime(n, 1, this.param.getRandom());
            BigInteger bigInteger4 = ONE;
            if (bigInteger3.mod(bigInteger).equals(bigInteger4)) continue;
            BigInteger bigInteger5 = bigInteger3;
            if (bigInteger5.multiply(bigInteger5).compareTo(bigInteger2) < 0 || !this.isProbablePrime(bigInteger3) || !bigInteger.gcd(bigInteger3.subtract(bigInteger4)).equals(bigInteger4)) {
                continue;
            }
            return bigInteger3;
        }
        throw new IllegalStateException("unable to generate prime number for RSA key");
    }

    public boolean isProbablePrime(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        int n = RSAKeyPairGenerator.getNumberOfIterations(bigInteger2.bitLength(), this.param.getCertainty());
        return !Primes.hasAnySmallFactors(bigInteger2) && Primes.isMRProbablePrime(bigInteger, this.param.getRandom(), n);
    }
}

