/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    public static final int C1 = 0x1010104;
    public static final int C2 = 0x1010101;
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private final int blockSize;
    private final BlockCipher cipher;
    public boolean firstStep = true;
    public int N3;
    public int N4;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        if (this.blockSize == 8) {
            this.IV = new byte[blockCipher.getBlockSize()];
            this.ofbV = new byte[blockCipher.getBlockSize()];
            this.ofbOutV = new byte[blockCipher.getBlockSize()];
            return;
        }
        throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
    }

    private int bytesToint(byte[] byArray, int n) {
        return (byArray[n + 3] << 24 & 0xFF000000) + (byArray[n + 2] << 16 & 0xFF0000) + (byArray[n + 1] << 8 & 0xFF00) + (byArray[n] & 0xFF);
    }

    private void intTobytes(int n, byte[] byArray, int n2) {
        int n3 = n2 + 3;
        byArray[n3] = (byte)(n >>> 24);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >>> 16);
        n3 = n2 + 1;
        byArray[n3] = (byte)(n >>> 8);
        byArray[n2] = (byte)n;
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        GOFBBlockCipher gOFBBlockCipher = this;
        gOFBBlockCipher.firstStep = true;
        gOFBBlockCipher.N3 = 0;
        gOFBBlockCipher.N4 = 0;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n = byArray2.length - ((Object)object).length;
                int n2 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n, n2);
                int n3 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n3 < this.IV.length - ((Object)object).length) {
                        byArray3[n3] = 0;
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                int n = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        GOFBBlockCipher gOFBBlockCipher = this;
        gOFBBlockCipher.processBytes(byArray, n, this.blockSize, byArray2, n2);
        return gOFBBlockCipher.blockSize;
    }

    @Override
    public void reset() {
        GOFBBlockCipher gOFBBlockCipher = object;
        gOFBBlockCipher.firstStep = true;
        gOFBBlockCipher.N3 = 0;
        gOFBBlockCipher.N4 = 0;
        Object object = ((GOFBBlockCipher)object).ofbV;
        int n = gOFBBlockCipher.IV.length;
        System.arraycopy(gOFBBlockCipher.IV, 0, object, 0, n);
        gOFBBlockCipher.byteCount = 0;
        gOFBBlockCipher.cipher.reset();
    }

    @Override
    public byte calculateByte(byte by) {
        int n;
        byte[] byArray;
        if (this.byteCount == 0) {
            int n2;
            int n3;
            if (this.firstStep) {
                GOFBBlockCipher gOFBBlockCipher = this;
                gOFBBlockCipher.firstStep = false;
                GOFBBlockCipher gOFBBlockCipher2 = this;
                byte[] byArray2 = gOFBBlockCipher2.ofbV;
                byte[] byArray3 = gOFBBlockCipher2.ofbOutV;
                gOFBBlockCipher.cipher.processBlock(byArray2, 0, byArray3, 0);
                gOFBBlockCipher.N3 = gOFBBlockCipher.bytesToint(gOFBBlockCipher.ofbOutV, 0);
                gOFBBlockCipher.N4 = gOFBBlockCipher.bytesToint(gOFBBlockCipher.ofbOutV, 4);
            }
            GOFBBlockCipher gOFBBlockCipher = this;
            gOFBBlockCipher.N3 = n3 = gOFBBlockCipher.N3 + 0x1010101;
            this.N4 = n2 = gOFBBlockCipher.N4 + 0x1010104;
            if (n2 < 0x1010104 && n2 > 0) {
                this.N4 = n2 + 1;
            }
            GOFBBlockCipher gOFBBlockCipher3 = this;
            gOFBBlockCipher3.intTobytes(n3, this.ofbV, 0);
            n3 = gOFBBlockCipher3.N4;
            gOFBBlockCipher3.intTobytes(n3, gOFBBlockCipher3.ofbV, 4);
            GOFBBlockCipher gOFBBlockCipher4 = this;
            byArray = gOFBBlockCipher4.ofbV;
            byte[] byArray4 = gOFBBlockCipher4.ofbOutV;
            gOFBBlockCipher3.cipher.processBlock(byArray, 0, byArray4, 0);
        }
        GOFBBlockCipher gOFBBlockCipher = this;
        byArray = gOFBBlockCipher.ofbOutV;
        int n4 = gOFBBlockCipher.byteCount;
        this.byteCount = n = n4 + 1;
        by = (byte)(byArray[n4] ^ by);
        int n5 = this.blockSize;
        if (n == n5) {
            GOFBBlockCipher gOFBBlockCipher5 = this;
            gOFBBlockCipher5.byteCount = 0;
            byte[] byArray5 = gOFBBlockCipher5.ofbV;
            int n6 = n5;
            n5 = byArray5.length - n5;
            System.arraycopy(gOFBBlockCipher5.ofbV, n6, byArray5, 0, n5);
            byte[] byArray6 = this.ofbV;
            int n7 = this.blockSize;
            int n8 = this.ofbV.length - n7;
            System.arraycopy(gOFBBlockCipher5.ofbOutV, 0, byArray6, n8, n7);
        }
        return by;
    }
}

