/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECDomainParameters
implements ECConstants {
    private final ECCurve curve;
    private final byte[] seed;
    private final ECPoint G;
    private final BigInteger n;
    private final BigInteger h;
    private BigInteger hInv;

    public ECDomainParameters(X9ECParameters object) {
        ECDomainParameters eCDomainParameters = eCCurve;
        X9ECParameters x9ECParameters = object;
        ECCurve eCCurve = x9ECParameters.getCurve();
        object = x9ECParameters.getG();
        BigInteger bigInteger = x9ECParameters.getN();
        BigInteger bigInteger2 = x9ECParameters.getH();
        byte[] byArray = x9ECParameters.getSeed();
        eCDomainParameters(eCCurve, (ECPoint)object, bigInteger, bigInteger2, byArray);
    }

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        ECDomainParameters eCDomainParameters = bigInteger2;
        BigInteger bigInteger2 = ECConstants.ONE;
        eCDomainParameters(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.hInv = null;
        if (eCCurve != null) {
            if (bigInteger != null) {
                this.curve = eCCurve;
                this.G = ECDomainParameters.validatePublicPoint(eCCurve, eCPoint);
                this.n = bigInteger;
                this.h = bigInteger2;
                this.seed = Arrays.clone(byArray);
                return;
            }
            throw new NullPointerException("n");
        }
        throw new NullPointerException("curve");
    }

    public static ECPoint validatePublicPoint(ECCurve object, ECPoint eCPoint) {
        if (eCPoint != null) {
            if (!((ECPoint)(object = ECAlgorithms.importPoint((ECCurve)object, eCPoint).normalize())).isInfinity()) {
                if (((ECPoint)object).isValid()) {
                    return object;
                }
                throw new IllegalArgumentException("Point not on curve");
            }
            throw new IllegalArgumentException("Point at infinity");
        }
        throw new NullPointerException("Point cannot be null");
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public synchronized BigInteger getHInv() {
        if (this.hInv == null) {
            this.hInv = BigIntegers.modOddInverseVar(this.n, this.h);
        }
        return this.hInv;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ECDomainParameters)) {
            return false;
        }
        object = (ECDomainParameters)object;
        return this.curve.equals(((ECDomainParameters)object).curve) && this.G.equals(((ECDomainParameters)object).G) && this.n.equals(((ECDomainParameters)object).n);
    }

    public int hashCode() {
        return ((0x404 ^ this.curve.hashCode()) * 257 ^ this.G.hashCode()) * 257 ^ this.n.hashCode();
    }

    public BigInteger validatePrivateScalar(BigInteger bigInteger) {
        if (bigInteger != null) {
            if (bigInteger.compareTo(ECConstants.ONE) >= 0 && bigInteger.compareTo(this.getN()) < 0) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Scalar is not in the interval [1, n - 1]");
        }
        throw new NullPointerException("Scalar cannot be null");
    }

    public ECPoint validatePublicPoint(ECPoint eCPoint) {
        return ECDomainParameters.validatePublicPoint(this.getCurve(), eCPoint);
    }
}

