/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.CompositePrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.CompositePublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class COMPOSITE {
    private static final String PREFIX = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.COMPOSITE";
    private static final Map<String, String> compositeAttributes = new HashMap<String, String>();
    private static AsymmetricKeyInfoConverter baseConverter;

    static {
        compositeAttributes.put("SupportedKeyClasses", "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.CompositePublicKey|com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.CompositePrivateKey");
        compositeAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ConfigurableProvider configurableProvider2 = configurableProvider;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = MiscObjectIdentifiers.id_alg_composite;
            configurableProvider2.addAlgorithm(b.a(a.a(configurableProvider2, "KeyFactory.COMPOSITE", "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory", "KeyFactory."), aSN1ObjectIdentifier, configurableProvider, "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory", "KeyFactory.OID.").append(aSN1ObjectIdentifier).toString(), "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.COMPOSITE$KeyFactory");
            baseConverter = new CompositeKeyInfoConverter(configurableProvider);
            configurableProvider2.addKeyInfoConverter(aSN1ObjectIdentifier, baseConverter);
        }
    }

    public static class CompositeKeyInfoConverter
    implements AsymmetricKeyInfoConverter {
        private final ConfigurableProvider provider;

        public CompositeKeyInfoConverter(ConfigurableProvider configurableProvider) {
            this.provider = configurableProvider;
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo aSN1Object) {
            aSN1Object = ASN1Sequence.getInstance(((PrivateKeyInfo)aSN1Object).getPrivateKey().getOctets());
            PrivateKey[] privateKeyArray = new PrivateKey[((ASN1Sequence)aSN1Object).size()];
            for (int k = 0; k != ((ASN1Sequence)aSN1Object).size(); ++k) {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(k));
                privateKeyArray[k] = this.provider.getKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()).generatePrivate(privateKeyInfo);
            }
            return new CompositePrivateKey(privateKeyArray);
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo aSN1Object) {
            aSN1Object = ASN1Sequence.getInstance(((SubjectPublicKeyInfo)aSN1Object).getPublicKeyData().getBytes());
            PublicKey[] publicKeyArray = new PublicKey[((ASN1Sequence)aSN1Object).size()];
            for (int k = 0; k != ((ASN1Sequence)aSN1Object).size(); ++k) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(k));
                publicKeyArray[k] = this.provider.getKeyInfoConverter(subjectPublicKeyInfo.getAlgorithm().getAlgorithm()).generatePublic(subjectPublicKeyInfo);
            }
            return new CompositePublicKey(publicKeyArray);
        }
    }

    public static class KeyFactory
    extends BaseKeyFactorySpi {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Key engineTranslateKey(Key key) {
            try {
                if (key instanceof PrivateKey) {
                    return this.generatePrivate(PrivateKeyInfo.getInstance(key.getEncoded()));
                }
                if (key instanceof PublicKey) {
                    return this.generatePublic(SubjectPublicKeyInfo.getInstance(key.getEncoded()));
                }
                throw new InvalidKeyException("key not recognized");
            }
            catch (IOException iOException) {
                throw new InvalidKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b.a(iOException, b.b.a("key could not be parsed: ")));
            }
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
            return baseConverter.generatePrivate(privateKeyInfo);
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
            return baseConverter.generatePublic(subjectPublicKeyInfo);
        }
    }
}

