/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    private void minimizeFG(IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3, IntegerPolynomial integerPolynomial4, int n) {
        int n2;
        int n3 = 0;
        for (int k = 0; k < n; ++k) {
            int n4 = n * 2;
            int n5 = integerPolynomial.coeffs[k];
            n2 = n5 * n5;
            int n6 = integerPolynomial2.coeffs[k];
            n3 = (n6 * n6 + n2) * n4 + n3;
        }
        n3 -= 4;
        IntegerPolynomial integerPolynomial5 = (IntegerPolynomial)integerPolynomial.clone();
        IntegerPolynomial integerPolynomial6 = (IntegerPolynomial)integerPolynomial2.clone();
        int n7 = 0;
        for (n2 = 0; n7 < n && n2 < n; ++n2) {
            int n8 = 0;
            for (int k = 0; k < n; ++k) {
                int n9 = integerPolynomial4.coeffs[k] * integerPolynomial2.coeffs[k];
                int n10 = n * 4;
                n8 = (integerPolynomial3.coeffs[k] * integerPolynomial.coeffs[k] + n9) * n10 + n8;
            }
            int n11 = n8;
            n8 = integerPolynomial3.sumCoeffs();
            n8 = n11 - (integerPolynomial4.sumCoeffs() + n8) * 4;
            if (n8 > n3) {
                integerPolynomial3.sub(integerPolynomial5);
                integerPolynomial4.sub(integerPolynomial6);
                n2 = n7 + 1;
                int n12 = n7 = 0;
                n7 = n2;
                n2 = n12;
            } else if (n8 < -n3) {
                integerPolynomial3.add(integerPolynomial5);
                integerPolynomial4.add(integerPolynomial6);
                n2 = n7 + 1;
                int n13 = n7 = 0;
                n7 = n2;
                n2 = n13;
            }
            integerPolynomial5.rotate1();
            integerPolynomial6.rotate1();
        }
    }

    private FGBasis generateBasis() {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        Object object;
        BigIntEuclidean bigIntEuclidean;
        Resultant resultant;
        Object object2;
        Object object3;
        Polynomial polynomial;
        IntegerPolynomial integerPolynomial4;
        Object object4;
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this.params;
        int n = nTRUSigningKeyGenerationParameters.N;
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters2 = nTRUSigningKeyGenerationParameters;
        int n2 = nTRUSigningKeyGenerationParameters2.q;
        int n3 = nTRUSigningKeyGenerationParameters2.d;
        int n4 = nTRUSigningKeyGenerationParameters2.d1;
        int n5 = nTRUSigningKeyGenerationParameters2.d2;
        int n6 = nTRUSigningKeyGenerationParameters2.d3;
        int n7 = nTRUSigningKeyGenerationParameters2.basisType;
        int n8 = n * 2 + 1;
        int n9 = nTRUSigningKeyGenerationParameters.primeCheck;
        do {
            if (this.params.polyType == 0) {
                int n10 = n3 + 1;
                object4 = CryptoServicesRegistrar.getSecureRandom();
                polynomial = DenseTernaryPolynomial.generateRandom(n, n10, n3, (SecureRandom)object4);
            } else {
                int n11 = n6 + 1;
                object4 = CryptoServicesRegistrar.getSecureRandom();
                polynomial = ProductFormPolynomial.generateRandom(n, n4, n5, n11, n6, (SecureRandom)object4);
            }
            object4 = polynomial.toIntegerPolynomial();
        } while (n9 != 0 && ((IntegerPolynomial)object4).resultant((int)n8).res.equals(BigInteger.ZERO) || (integerPolynomial4 = ((IntegerPolynomial)object4).invertFq(n2)) == null);
        Resultant resultant2 = ((IntegerPolynomial)object4).resultant();
        while (true) {
            if (this.params.polyType == 0) {
                int n12 = n3 + 1;
                object3 = CryptoServicesRegistrar.getSecureRandom();
                object2 = DenseTernaryPolynomial.generateRandom(n, n12, n3, (SecureRandom)object3);
            } else {
                int n13 = n6 + 1;
                object3 = CryptoServicesRegistrar.getSecureRandom();
                object2 = ProductFormPolynomial.generateRandom(n, n4, n5, n13, n6, (SecureRandom)object3);
            }
            object3 = object2.toIntegerPolynomial();
            if (n9 != 0 && ((IntegerPolynomial)object3).resultant((int)n8).res.equals(BigInteger.ZERO) || ((IntegerPolynomial)object3).invertFq(n2) == null) continue;
            resultant = ((IntegerPolynomial)object3).resultant();
            bigIntEuclidean = BigIntEuclidean.calculate(resultant2.res, resultant.res);
            if (bigIntEuclidean.gcd.equals(BigInteger.ONE)) break;
        }
        Object object5 = (BigIntPolynomial)resultant2.rho.clone();
        ((BigIntPolynomial)object5).mult(bigIntEuclidean.x.multiply(BigInteger.valueOf(n2)));
        BigIntPolynomial bigIntPolynomial = (BigIntPolynomial)resultant.rho.clone();
        bigIntPolynomial.mult(bigIntEuclidean.y.multiply(BigInteger.valueOf(-n2)));
        if (this.params.keyGenAlg == 0) {
            IntegerPolynomial integerPolynomial5;
            IntegerPolynomial integerPolynomial6;
            IntegerPolynomial integerPolynomial7;
            int n14 = n;
            object = new int[n14];
            int[] nArray = new int[n14];
            Object object6 = nArray;
            object[0] = ((IntegerPolynomial)object4).coeffs[0];
            nArray[0] = ((IntegerPolynomial)object3).coeffs[0];
            for (n8 = 1; n8 < n; ++n8) {
                n9 = n - n8;
                object[n8] = ((IntegerPolynomial)object4).coeffs[n9];
                object6[n8] = ((IntegerPolynomial)object3).coeffs[n9];
            }
            IntegerPolynomial integerPolynomial8 = integerPolynomial7 = integerPolynomial6;
            integerPolynomial8((int[])object);
            object = integerPolynomial5;
            integerPolynomial5 = new IntegerPolynomial((int[])object6);
            IntegerPolynomial integerPolynomial9 = polynomial.mult(integerPolynomial8);
            integerPolynomial9.add(object2.mult((IntegerPolynomial)object));
            object6 = integerPolynomial9.resultant();
            BigIntPolynomial bigIntPolynomial2 = integerPolynomial6.mult(bigIntPolynomial);
            bigIntPolynomial2.add(((IntegerPolynomial)object).mult((BigIntPolynomial)object5));
            object = bigIntPolynomial2.mult(object6.rho);
            ((BigIntPolynomial)object).div(object6.res);
        } else {
            n5 = 0;
            for (n6 = 1; n6 < n; n6 *= 10) {
                ++n5;
            }
            object = resultant.rho.div(new BigDecimal(resultant.res), ((BigIntPolynomial)object5).getMaxCoeffLength() + 1 + n5);
            BigDecimalPolynomial bigDecimalPolynomial = resultant2.rho.div(new BigDecimal(resultant2.res), bigIntPolynomial.getMaxCoeffLength() + 1 + n5).mult(bigIntPolynomial);
            bigDecimalPolynomial.add(((BigDecimalPolynomial)object).mult((BigIntPolynomial)object5));
            bigDecimalPolynomial.halve();
            object = bigDecimalPolynomial.round();
        }
        BigIntPolynomial bigIntPolynomial3 = object5;
        object5 = (BigIntPolynomial)bigIntPolynomial.clone();
        ((BigIntPolynomial)object5).sub(polynomial.mult((BigIntPolynomial)object));
        bigIntPolynomial = (BigIntPolynomial)bigIntPolynomial3.clone();
        bigIntPolynomial.sub(object2.mult((BigIntPolynomial)object));
        object = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial((BigIntPolynomial)object5);
        object5 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(bigIntPolynomial);
        this.minimizeFG((IntegerPolynomial)object4, (IntegerPolynomial)object3, (IntegerPolynomial)object, (IntegerPolynomial)object5, n);
        if (n7 == 0) {
            integerPolynomial = object2.mult(integerPolynomial4, n2);
            object2 = object;
        } else {
            integerPolynomial = ((IntegerPolynomial)object).mult(integerPolynomial4, n2);
        }
        integerPolynomial.modPositive(n2);
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters3 = this.params;
        return new FGBasis(polynomial, (Polynomial)object2, integerPolynomial, (IntegerPolynomial)object, (IntegerPolynomial)object5, nTRUSigningKeyGenerationParameters3);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUSigningKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters;
        ArrayList arrayList;
        int n;
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> arrayList2;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        Object object = Executors.newCachedThreadPool();
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>>();
        for (n = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; n >= 0; --n) {
            arrayList3.add(object.submit((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2).new BasisGenerationTask(null)));
        }
        object.shutdown();
        object = arrayList;
        arrayList = new ArrayList();
        for (n = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; n >= 0; --n) {
            NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters2;
            Future future = (Future)arrayList3.get(n);
            try {
                ((ArrayList)object).add((NTRUSigningPrivateKeyParameters.Basis)future.get());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            if (n != ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B) continue;
            nTRUSigningPublicKeyParameters = nTRUSigningPublicKeyParameters2;
            nTRUSigningPublicKeyParameters2 = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)future.get()).h, ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters2 = nTRUSigningPrivateKeyParameters;
        nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters((List<NTRUSigningPrivateKeyParameters.Basis>)object, nTRUSigningPublicKeyParameters);
        return new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, nTRUSigningPrivateKeyParameters2);
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters;
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> arrayList;
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        for (int k = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; k >= 0; --k) {
            NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters2;
            NTRUSigningPrivateKeyParameters.Basis basis = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).generateBoundedBasis();
            arrayList2.add(basis);
            if (k != 0) continue;
            nTRUSigningPublicKeyParameters = nTRUSigningPublicKeyParameters2;
            nTRUSigningPublicKeyParameters2 = new NTRUSigningPublicKeyParameters(basis.h, ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters2 = nTRUSigningPrivateKeyParameters;
        nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters(arrayList2, nTRUSigningPublicKeyParameters);
        return new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, nTRUSigningPrivateKeyParameters2);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis fGBasis;
        while (!(fGBasis = this.generateBasis()).isNormOk()) {
        }
        return fGBasis;
    }

    public class FGBasis
    extends NTRUSigningPrivateKeyParameters.Basis {
        public IntegerPolynomial F;
        public IntegerPolynomial G;

        public FGBasis(Polynomial polynomial, Polynomial polynomial2, IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
            super(polynomial, polynomial2, integerPolynomial, nTRUSigningKeyGenerationParameters);
            this.F = integerPolynomial2;
            this.G = integerPolynomial3;
        }

        public boolean isNormOk() {
            FGBasis fGBasis = this;
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = fGBasis.params;
            double d2 = nTRUSigningKeyGenerationParameters.keyNormBoundSq;
            int n = nTRUSigningKeyGenerationParameters.q;
            return (double)fGBasis.F.centeredNormSq(n) < d2 && (double)this.G.centeredNormSq(n) < d2;
        }
    }

    public class BasisGenerationTask
    implements Callable<NTRUSigningPrivateKeyParameters.Basis> {
        private BasisGenerationTask() {
        }

        public /* synthetic */ BasisGenerationTask(1 var2_2) {
            this();
        }

        @Override
        public NTRUSigningPrivateKeyParameters.Basis call() {
            return NTRUSigningKeyPairGenerator.this.generateBoundedBasis();
        }
    }
}

