/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTesla1p;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTesla3p;
import java.security.SecureRandom;

public class QTESLASigner
implements MessageSigner {
    private QTESLAPublicKeyParameters publicKey;
    private QTESLAPrivateKeyParameters privateKey;
    private SecureRandom secureRandom;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                QTESLASigner qTESLASigner = qTESLAPublicKeyParameters;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                qTESLASigner.secureRandom = parametersWithRandom.getRandom();
                qTESLASigner.privateKey = (QTESLAPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                ((QTESLASigner)((Object)qTESLAPublicKeyParameters)).secureRandom = CryptoServicesRegistrar.getSecureRandom();
                ((QTESLASigner)((Object)qTESLAPublicKeyParameters)).privateKey = (QTESLAPrivateKeyParameters)cipherParameters;
            }
            ((QTESLASigner)((Object)qTESLAPublicKeyParameters)).publicKey = null;
            QTESLASecurityCategory.validate(((QTESLASigner)((Object)qTESLAPublicKeyParameters)).privateKey.getSecurityCategory());
        } else {
            QTESLASigner qTESLASigner = qTESLAPublicKeyParameters;
            ((QTESLASigner)((Object)qTESLAPublicKeyParameters)).privateKey = null;
            QTESLAPublicKeyParameters qTESLAPublicKeyParameters = (QTESLAPublicKeyParameters)cipherParameters;
            qTESLASigner.publicKey = qTESLAPublicKeyParameters;
            QTESLASecurityCategory.validate(qTESLAPublicKeyParameters.getSecurityCategory());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] generateSignature(byte[] byArray) {
        QTESLASigner qTESLASigner = this;
        byte[] byArray2 = new byte[QTESLASecurityCategory.getSignatureSize(qTESLASigner.privateKey.getSecurityCategory())];
        int n = qTESLASigner.privateKey.getSecurityCategory();
        if (n != 5) {
            if (n != 6) throw new IllegalArgumentException(b.a("unknown security category: ").append(this.privateKey.getSecurityCategory()).toString());
            byte[] byArray3 = byArray;
            QTESLASigner qTESLASigner2 = this;
            int n2 = byArray.length;
            byArray = qTESLASigner2.privateKey.getSecret();
            SecureRandom secureRandom = qTESLASigner2.secureRandom;
            QTesla3p.generateSignature(byArray2, byArray3, 0, n2, byArray, secureRandom);
            return byArray2;
        } else {
            byte[] byArray4 = byArray;
            QTESLASigner qTESLASigner3 = this;
            int n3 = byArray.length;
            byArray = qTESLASigner3.privateKey.getSecret();
            SecureRandom secureRandom = qTESLASigner3.secureRandom;
            QTesla1p.generateSignature(byArray2, byArray4, 0, n3, byArray, secureRandom);
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = this.publicKey.getSecurityCategory();
        if (n2 != 5) {
            if (n2 != 6) throw new IllegalArgumentException(b.a("unknown security category: ").append(this.publicKey.getSecurityCategory()).toString());
            byte[] byArray3 = byArray;
            int n3 = byArray2.length;
            byArray = this.publicKey.getPublicData();
            n = QTesla3p.verifying(byArray3, byArray2, 0, n3, byArray);
        } else {
            byte[] byArray4 = byArray;
            int n4 = byArray2.length;
            byArray = this.publicKey.getPublicData();
            n = QTesla1p.verifying(byArray4, byArray2, 0, n4, byArray);
        }
        if (n != 0) return false;
        return true;
    }
}

