/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABEREngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.Utils;

class Poly {
    private static final int KARATSUBA_N = 64;
    private static int SCHB_N = 16;
    private final int N_RES;
    private final int N_SB;
    private final int N_SB_RES;
    private final int SABER_N;
    private final int SABER_L;
    private final SABEREngine engine;
    private final Utils utils;

    public Poly(SABEREngine sABEREngine) {
        int n;
        this.engine = sABEREngine;
        this.SABER_L = sABEREngine.getSABER_L();
        this.SABER_N = n = sABEREngine.getSABER_N();
        this.N_RES = n << 1;
        this.N_SB = n >> 2;
        this.N_SB_RES = this.N_SB * 2 - 1;
        this.utils = sABEREngine.getUtils();
    }

    private long load_littleendian(byte[] byArray, int n, int n2) {
        long l = byArray[n + 0] & 0xFF;
        for (int k = 1; k < n2; ++k) {
            l |= (long)(byArray[n + k] & 0xFF) << k * 8;
        }
        return l;
    }

    private void cbd(short[] sArray, byte[] byArray, int n) {
        block7: {
            int[] nArray;
            block8: {
                block6: {
                    nArray = new int[4];
                    if (this.engine.getSABER_MU() != 6) break block6;
                    for (int k = 0; k < this.SABER_N / 4; ++k) {
                        int n2;
                        int n3 = (int)this.load_littleendian(byArray, k * 3 + n, 3);
                        int n4 = 0;
                        for (n2 = 0; n2 < 3; ++n2) {
                            n4 += n3 >> n2 & 0x249249;
                        }
                        int n5 = n4;
                        int n6 = n4;
                        int n7 = n4;
                        int n8 = n4;
                        nArray[0] = n4 & 7;
                        n3 = n8 >>> 3 & 7;
                        nArray[1] = n8 >>> 6 & 7;
                        n4 = n7 >>> 9 & 7;
                        nArray[2] = n7 >>> 12 & 7;
                        n2 = n6 >>> 15 & 7;
                        nArray[3] = n6 >>> 18 & 7;
                        int n9 = n5 >>> 21;
                        int n10 = k * 4;
                        int n11 = n10 + 0;
                        sArray[n11] = (short)(nArray[0] - n3);
                        n3 = n10 + 1;
                        sArray[n3] = (short)(nArray[1] - n4);
                        n3 = n10 + 2;
                        sArray[n3] = (short)(nArray[2] - n2);
                        n3 = n10 + 3;
                        sArray[n3] = (short)(nArray[3] - n9);
                    }
                    break block7;
                }
                if (this.engine.getSABER_MU() != 8) break block8;
                for (int k = 0; k < this.SABER_N / 4; ++k) {
                    int n12;
                    int n13 = k * 4;
                    int n14 = (int)this.load_littleendian(byArray, n + n13, 4);
                    int n15 = 0;
                    for (n12 = 0; n12 < 4; ++n12) {
                        n15 += n14 >>> n12 & 0x11111111;
                    }
                    int n16 = n15;
                    int n17 = n15;
                    int n18 = n15;
                    int n19 = n15;
                    nArray[0] = n15 & 0xF;
                    n14 = n19 >>> 4 & 0xF;
                    nArray[1] = n19 >>> 8 & 0xF;
                    n15 = n18 >>> 12 & 0xF;
                    nArray[2] = n18 >>> 16 & 0xF;
                    n12 = n17 >>> 20 & 0xF;
                    nArray[3] = n17 >>> 24 & 0xF;
                    int n20 = n16 >>> 28;
                    int n21 = n13 + 0;
                    sArray[n21] = (short)(nArray[0] - n14);
                    n14 = n13 + 1;
                    sArray[n14] = (short)(nArray[1] - n15);
                    n14 = n13 + 2;
                    sArray[n14] = (short)(nArray[2] - n12);
                    sArray[n13 += 3] = (short)(nArray[3] - n20);
                }
                break block7;
            }
            if (this.engine.getSABER_MU() != 10) break block7;
            for (int k = 0; k < this.SABER_N / 4; ++k) {
                int n22;
                long l = this.load_littleendian(byArray, k * 5 + n, 5);
                long l2 = 0L;
                for (n22 = 0; n22 < 5; ++n22) {
                    l2 += l >>> n22 & 0x842108421L;
                }
                long l3 = l2;
                long l4 = l2;
                long l5 = l2;
                nArray[0] = (int)(l2 & 0x1FL);
                int n23 = (int)(l5 >>> 5 & 0x1FL);
                nArray[1] = (int)(l5 >>> 10 & 0x1FL);
                int n24 = (int)(l4 >>> 15 & 0x1FL);
                nArray[2] = (int)(l4 >>> 20 & 0x1FL);
                int n25 = (int)(l3 >>> 25 & 0x1FL);
                nArray[3] = (int)(l3 >>> 30 & 0x1FL);
                int n26 = (int)(l2 >>> 35);
                n22 = k * 4;
                int n27 = n22 + 0;
                sArray[n27] = (short)(nArray[0] - n23);
                n23 = n22 + 1;
                sArray[n23] = (short)(nArray[1] - n24);
                n23 = n22 + 2;
                sArray[n23] = (short)(nArray[2] - n25);
                n23 = n22 + 3;
                sArray[n23] = (short)(nArray[3] - n26);
            }
        }
    }

    private short OVERFLOWING_MUL(int n, int n2) {
        return (short)(n * n2);
    }

    private void karatsuba_simple(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4 = new int[31];
        int[] nArray5 = new int[31];
        int[] nArray6 = new int[31];
        int[] nArray7 = new int[63];
        for (int k = 0; k < 16; ++k) {
            int n2 = nArray[k];
            int n3 = nArray[k + 16];
            int n4 = nArray[k + 32];
            int n5 = nArray[k + 48];
            for (int i2 = 0; i2 < 16; ++i2) {
                int n6;
                int n7 = nArray2[i2];
                int n8 = n6 = n7;
                int[] nArray8 = nArray3;
                int n9 = nArray2[i2 + 16];
                int n10 = k + i2;
                int n11 = n10 + 0;
                nArray8[n11] = nArray3[n11] + this.OVERFLOWING_MUL(n2, n6);
                n6 = n10 + 32;
                nArray8[n6] = nArray3[n6] + this.OVERFLOWING_MUL(n3, n9);
                int n12 = n8 + n9;
                int n13 = n2 + n3;
                long l = nArray4[n10];
                nArray4[n10] = (int)((long)n12 * (long)n13 + l);
                n12 = nArray2[i2 + 32];
                int[] nArray9 = nArray3;
                n13 = nArray2[i2 + 48];
                int n14 = n10 + 64;
                nArray9[n14] = nArray3[n14] + this.OVERFLOWING_MUL(n12, n4);
                n14 = n10 + 96;
                nArray9[n14] = nArray3[n14] + this.OVERFLOWING_MUL(n13, n5);
                n14 = n4 + n5;
                int n15 = n12 + n13;
                nArray6[n10] = nArray6[n10] + this.OVERFLOWING_MUL(n14, n15);
                n12 = n7 + n12;
                n14 = n2 + n4;
                int n16 = n6;
                int n17 = n6;
                nArray7[n11] = nArray7[n11] + this.OVERFLOWING_MUL(n12, n14);
                n6 = n9 + n13;
                n9 = n3 + n5;
                nArray7[n16] = nArray7[n17] + this.OVERFLOWING_MUL(n6, n9);
                n6 = n12 + n6;
                n9 = n14 + n9;
                nArray5[n10] = nArray5[n10] + this.OVERFLOWING_MUL(n6, n9);
            }
        }
        for (n = 0; n < 31; ++n) {
            int n18 = n + 0;
            int n19 = n + 32;
            nArray5[n] = nArray5[n] - nArray7[n18] - nArray7[n19];
            nArray4[n] = nArray4[n] - nArray3[n18] - nArray3[n19];
            nArray6[n] = nArray6[n] - nArray3[n + 64] - nArray3[n + 96];
        }
        for (n = 0; n < 31; ++n) {
            int[] nArray10 = nArray3;
            int n20 = n + 16;
            nArray7[n20] = nArray7[n20] + nArray5[n];
            nArray10[n20] = nArray3[n20] + nArray4[n];
            n20 = n + 80;
            nArray10[n20] = nArray3[n20] + nArray6[n];
        }
        for (n = 0; n < 63; ++n) {
            nArray7[n] = nArray7[n] - nArray3[n] - nArray3[n + 64];
        }
        for (n = 0; n < 63; ++n) {
            int n21 = n + 32;
            nArray3[n21] = nArray3[n21] + nArray7[n];
        }
    }

    private void toom_cook_4way(short[] sArray, short[] sArray2, short[] sArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        short s;
        int n5;
        int n6;
        Poly poly = this;
        int n7 = 43691;
        int n8 = 36409;
        int n9 = 61167;
        int n10 = poly.N_SB;
        int[] nArray = new int[n10];
        int[] nArray2 = new int[n10];
        int[] nArray3 = new int[n10];
        int[] nArray4 = new int[n10];
        int[] nArray5 = new int[n10];
        int[] nArray6 = new int[n10];
        int[] nArray7 = new int[n10];
        int[] nArray8 = new int[n10];
        int[] nArray9 = new int[n10];
        int[] nArray10 = new int[n10];
        int[] nArray11 = new int[n10];
        int[] nArray12 = new int[n10];
        int[] nArray13 = new int[n10];
        int[] nArray14 = new int[n10];
        int n11 = poly.N_SB_RES;
        int[] nArray15 = new int[n11];
        int[] nArray16 = new int[n11];
        int[] nArray17 = new int[n11];
        int[] nArray18 = new int[n11];
        int[] nArray19 = new int[n11];
        int[] nArray20 = new int[n11];
        int[] nArray21 = new int[n11];
        for (n6 = 0; n6 < (n5 = this.N_SB); ++n6) {
            int n12 = n5;
            int n13 = n5;
            int n14 = n5;
            n5 = sArray[n6];
            s = sArray[n6 + n14];
            n4 = sArray[n13 * 2 + n6];
            n3 = sArray[n12 * 3 + n6];
            short s2 = (short)(n5 + n4);
            n2 = s + n3;
            short s3 = (short)(s2 + n2);
            n2 = (short)(s2 - n2);
            nArray3[n6] = s3;
            nArray4[n6] = n2;
            short s4 = (short)((n5 << 2) + n4 << 1);
            short s5 = (short)((s << 2) + n3);
            n2 = s5;
            s3 = (short)(s4 + s5);
            n2 = (short)(s4 - n2);
            nArray5[n6] = s3;
            nArray6[n6] = n2;
            nArray2[n6] = (short)((n3 << 3) + (n4 << 2) + (s << 1) + n5);
            nArray7[n6] = n5;
            nArray[n6] = n3;
        }
        for (n = 0; n < (n6 = this.N_SB); ++n) {
            int n15 = n6;
            int n16 = n6;
            int n17 = n6;
            n6 = sArray2[n];
            n5 = sArray2[n + n17];
            s = sArray2[n16 * 2 + n];
            n4 = sArray2[n15 * 3 + n];
            int n18 = n6 + s;
            n3 = n5 + n4;
            n2 = n18 + n3;
            n3 = n18 - n3;
            nArray10[n] = n2;
            nArray11[n] = n3;
            int n19 = (n6 << 2) + s << 1;
            n3 = (n5 << 2) + n4;
            n2 = n19 + n3;
            n3 = n19 - n3;
            nArray12[n] = n2;
            nArray13[n] = n3;
            nArray9[n] = (n4 << 3) + (s << 2) + (n5 << 1) + n6;
            nArray14[n] = n6;
            nArray8[n] = n4;
        }
        Poly poly2 = this;
        poly2.karatsuba_simple(nArray, nArray8, nArray15);
        poly2.karatsuba_simple(nArray2, nArray9, nArray16);
        poly2.karatsuba_simple(nArray3, nArray10, nArray17);
        poly2.karatsuba_simple(nArray4, nArray11, nArray18);
        poly2.karatsuba_simple(nArray5, nArray12, nArray19);
        poly2.karatsuba_simple(nArray6, nArray13, nArray20);
        poly2.karatsuba_simple(nArray7, nArray14, nArray21);
        for (n = 0; n < this.N_SB_RES; ++n) {
            short[] sArray4 = sArray3;
            int n20 = nArray15[n];
            int n21 = nArray16[n];
            int n22 = nArray17[n];
            int n23 = n22;
            int n24 = nArray18[n];
            int n25 = nArray19[n];
            int n26 = n25;
            int n27 = n24;
            int n28 = n21;
            n21 = nArray21[n];
            n24 = n28 + n26;
            n26 = nArray20[n] - n26;
            n23 = (n27 & 0xFFFF) - (n23 & 0xFFFF) >>> 1;
            int n29 = (n25 - n20 - (n21 << 6) << 1) + n26;
            int n30 = n22 + n23;
            n24 = n24 - (n30 << 6) - n30;
            n30 = n30 - n21 - n20;
            int n31 = n30 * 45 + n24;
            n24 = ((n29 & 0xFFFF) - (n30 << 3)) * n7 >> 3;
            n26 += n31;
            int n32 = ((n31 & 0xFFFF) + ((n23 & 0xFFFF) << 4)) * n8 >> 1;
            n29 = n32;
            n23 = -(n23 + n29);
            n26 = ((n29 & 0xFFFF) * 30 - (n26 & 0xFFFF)) * n9 >> 2;
            n29 = n30 - n24;
            n30 = n32 - n26;
            sArray4[n] = (short)(sArray3[n] + (n21 & 0xFFFF));
            n21 = n + 64;
            sArray3[n21] = (short)(sArray4[n21] + (n26 & 0xFFFF));
            n21 = n + 128;
            sArray3[n21] = (short)(sArray3[n21] + (n24 & 0xFFFF));
            n21 = n + 192;
            sArray3[n21] = (short)(sArray3[n21] + (n23 & 0xFFFF));
            n21 = n + 256;
            sArray3[n21] = (short)(sArray3[n21] + (n29 & 0xFFFF));
            n21 = n + 320;
            sArray3[n21] = (short)(sArray3[n21] + (n30 & 0xFFFF));
            n21 = n + 384;
            sArray3[n21] = (short)(sArray3[n21] + (n20 & 0xFFFF));
        }
    }

    private void poly_mul_acc(short[] sArray, short[] sArray2, short[] sArray3) {
        int n;
        short[] sArray4 = sArray;
        sArray = new short[this.SABER_N * 2];
        this.toom_cook_4way(sArray4, sArray2, sArray);
        for (int k = (v862129).SABER_N; k < (n = this.SABER_N) * 2; ++k) {
            int n2 = n;
            n = k - n;
            short s = sArray3[n];
            sArray3[n] = (short)(sArray[k - n2] - sArray[k] + s);
        }
    }

    public void GenMatrix(short[][][] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        int n = this.SABER_L * this.engine.getSABER_POLYVECBYTES();
        byte[] byArray2 = new byte[n];
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        sHAKEDigest2.update(byArray, 0, this.engine.getSABER_SEEDBYTES());
        sHAKEDigest.doFinal(byArray2, 0, n);
        int n2 = 0;
        while (n2 < this.SABER_L) {
            int n3 = n2++;
            n = n3 * this.engine.getSABER_POLYVECBYTES();
            this.utils.BS2POLVECq(byArray2, n, sArray[n3]);
        }
    }

    public void GenSecret(short[][] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        int n = this.SABER_L * this.engine.getSABER_POLYCOINBYTES();
        byte[] byArray2 = new byte[n];
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        sHAKEDigest2.update(byArray, 0, this.engine.getSABER_NOISE_SEEDBYTES());
        sHAKEDigest.doFinal(byArray2, 0, n);
        for (int k = 0; k < this.SABER_L; ++k) {
            short[] sArray2 = sArray[k];
            int n2 = k * this.engine.getSABER_POLYCOINBYTES();
            this.cbd(sArray2, byArray2, n2);
        }
    }

    public void MatrixVectorMul(short[][][] sArray, short[][] sArray2, short[][] sArray3, int n) {
        for (int k = 0; k < this.SABER_L; ++k) {
            for (int i2 = 0; i2 < this.SABER_L; ++i2) {
                short[] sArray4;
                short[] sArray5;
                short[] sArray6;
                if (n == 1) {
                    sArray6 = sArray[i2][k];
                    sArray5 = sArray2[i2];
                    sArray4 = sArray3[k];
                    this.poly_mul_acc(sArray6, sArray5, sArray4);
                    continue;
                }
                sArray6 = sArray[k][i2];
                sArray5 = sArray2[i2];
                sArray4 = sArray3[k];
                this.poly_mul_acc(sArray6, sArray5, sArray4);
            }
        }
    }

    public void InnerProd(short[][] sArray, short[][] sArray2, short[] sArray3) {
        for (int k = 0; k < this.SABER_L; ++k) {
            short[] sArray4 = sArray[k];
            this.poly_mul_acc(sArray4, sArray2[k], sArray3);
        }
    }
}

