/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.KeccakDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.Poly;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

class SABEREngine {
    public static final int SABER_EQ = 13;
    public static final int SABER_EP = 10;
    public static final int SABER_N = 256;
    private static final int SABER_SEEDBYTES = 32;
    private static final int SABER_NOISE_SEEDBYTES = 32;
    private static final int SABER_KEYBYTES = 32;
    private static final int SABER_HASHBYTES = 32;
    private final int SABER_L;
    private final int SABER_MU;
    private final int SABER_ET;
    private final int SABER_POLYCOINBYTES;
    private final int SABER_POLYBYTES;
    private final int SABER_POLYVECBYTES;
    private final int SABER_POLYCOMPRESSEDBYTES;
    private final int SABER_POLYVECCOMPRESSEDBYTES;
    private final int SABER_SCALEBYTES_KEM;
    private final int SABER_INDCPA_PUBLICKEYBYTES;
    private final int SABER_INDCPA_SECRETKEYBYTES;
    private final int SABER_PUBLICKEYBYTES;
    private final int SABER_SECRETKEYBYTES;
    private final int SABER_BYTES_CCA_DEC;
    private final int defaultKeySize;
    private final int h1;
    private final int h2;
    private final Utils utils;
    private final Poly poly;

    public SABEREngine(int n, int n2) {
        int n3;
        this.defaultKeySize = n2;
        this.SABER_L = n;
        if (n == 2) {
            SABEREngine sABEREngine = this;
            sABEREngine.SABER_MU = 10;
            sABEREngine.SABER_ET = 3;
        } else if (n == 3) {
            SABEREngine sABEREngine = this;
            sABEREngine.SABER_MU = 8;
            sABEREngine.SABER_ET = 4;
        } else {
            SABEREngine sABEREngine = this;
            sABEREngine.SABER_MU = 6;
            sABEREngine.SABER_ET = 6;
        }
        SABEREngine sABEREngine = this;
        int n4 = n;
        SABEREngine sABEREngine2 = this;
        this.SABER_POLYCOINBYTES = this.SABER_MU * 256 / 8;
        this.SABER_POLYBYTES = 416;
        sABEREngine2.SABER_POLYVECBYTES = n *= 416;
        sABEREngine2.SABER_POLYCOMPRESSEDBYTES = 320;
        int n5 = n4 * 320;
        n2 = n5;
        int n6 = n;
        SABEREngine sABEREngine3 = this;
        int n7 = n;
        this.SABER_POLYVECCOMPRESSEDBYTES = n2;
        n = this.SABER_ET;
        this.SABER_SCALEBYTES_KEM = n3 = n * 256 / 8;
        this.SABER_INDCPA_PUBLICKEYBYTES = n2 += 32;
        sABEREngine3.SABER_INDCPA_SECRETKEYBYTES = n7;
        sABEREngine3.SABER_PUBLICKEYBYTES = n2;
        this.SABER_SECRETKEYBYTES = a.a(n6, n2, 32, 32);
        sABEREngine.SABER_BYTES_CCA_DEC = n5 + n3;
        sABEREngine.h1 = 4;
        sABEREngine.h2 = 256 - (1 << 10 - n - 1) + 4;
        sABEREngine.utils = new Utils(this);
        sABEREngine.poly = new Poly(this);
    }

    private void indcpa_kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom object) {
        SHAKEDigest sHAKEDigest;
        SABEREngine sABEREngine = this;
        SecureRandom secureRandom = object;
        int n = this.SABER_L;
        object = new short[n][n][256];
        short[][] sArray = new short[n][256];
        short[][] sArray2 = new short[n][256];
        int n2 = 32;
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        secureRandom.nextBytes(byArray3);
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        sHAKEDigest2.update(byArray3, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, 32);
        secureRandom.nextBytes(byArray4);
        sABEREngine.poly.GenMatrix((short[][][])object, byArray3);
        sABEREngine.poly.GenSecret(sArray, byArray4);
        sABEREngine.poly.MatrixVectorMul((short[][][])object, sArray, sArray2, 1);
        for (int k = 0; k < this.SABER_L; ++k) {
            for (int i2 = 0; i2 < 256; ++i2) {
                short[] sArray3 = sArray2[k];
                sArray3[i2] = (short)((sArray3[i2] + this.h1 & 0xFFFF) >>> 3);
            }
        }
        SABEREngine sABEREngine2 = this;
        sABEREngine2.utils.POLVECq2BS(byArray2, sArray);
        sABEREngine2.utils.POLVECp2BS(byArray, sArray2);
        int n3 = sABEREngine2.SABER_POLYVECCOMPRESSEDBYTES;
        System.arraycopy(byArray3, 0, byArray, n3, n2);
    }

    private void indcpa_kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        SABEREngine sABEREngine = this;
        SABEREngine sABEREngine2 = this;
        int n = sABEREngine2.SABER_L;
        short[][][] sArray = new short[n][n][256];
        short[][] sArray2 = new short[n][256];
        short[][] sArray3 = new short[n][256];
        short[][] sArray4 = new short[n][256];
        short[] sArray5 = new short[256];
        short[] sArray6 = new short[256];
        int n2 = sABEREngine2.SABER_POLYVECCOMPRESSEDBYTES;
        byte[] byArray5 = Arrays.copyOfRange(byArray3, n2, byArray3.length);
        sABEREngine.poly.GenMatrix(sArray, byArray5);
        sABEREngine.poly.GenSecret(sArray2, byArray2);
        sABEREngine.poly.MatrixVectorMul(sArray, sArray2, sArray3, 0);
        for (int k = 0; k < this.SABER_L; ++k) {
            for (int i2 = 0; i2 < 256; ++i2) {
                short[] sArray7 = sArray3[k];
                sArray7[i2] = (short)((sArray7[i2] + this.h1 & 0xFFFF) >>> 3);
            }
        }
        SABEREngine sABEREngine3 = this;
        sABEREngine3.utils.POLVECp2BS(byArray4, sArray3);
        sABEREngine3.utils.BS2POLVECp(byArray3, sArray4);
        sABEREngine3.poly.InnerProd(sArray4, sArray2, sArray6);
        sABEREngine3.utils.BS2POLmsg(byArray, sArray5);
        for (int k = 0; k < 256; ++k) {
            sArray6[k] = (short)((sArray6[k] - (sArray5[k] << 9) + this.h1 & 0xFFFF) >>> 10 - this.SABER_ET);
        }
        this.utils.POLT2BS(byArray4, this.SABER_POLYVECCOMPRESSEDBYTES, sArray6);
    }

    private void indcpa_kem_dec(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        SABEREngine sABEREngine = this;
        int n = sABEREngine.SABER_L;
        short[][] sArray = new short[n][256];
        short[][] sArray2 = new short[n][256];
        short[] sArray3 = new short[256];
        short[] sArray4 = new short[256];
        sABEREngine.utils.BS2POLVECq(byArray, 0, sArray);
        sABEREngine.utils.BS2POLVECp(byArray2, sArray2);
        sABEREngine.poly.InnerProd(sArray2, sArray, sArray3);
        sABEREngine.utils.BS2POLT(byArray2, this.SABER_POLYVECCOMPRESSEDBYTES, sArray4);
        for (int k = 0; k < 256; ++k) {
            sArray3[k] = (short)((sArray3[k] + this.h2 - (sArray4[k] << 10 - this.SABER_ET) & 0xFFFF) >> 9);
        }
        this.utils.POLmsg2BS(byArray3, sArray3);
    }

    public static int verify(byte[] byArray, byte[] byArray2, int n) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l |= (long)(byArray[k] ^ byArray2[k]);
        }
        return (int)(-l >>> 63);
    }

    public static void cmov(byte[] byArray, byte[] byArray2, int n, int n2, byte by) {
        by = -by;
        for (int k = 0; k < n2; ++k) {
            byte by2 = byArray[k];
            byArray[k] = (byte)(by2 ^ by & (byArray2[k + n] ^ by2));
        }
    }

    public int getSABER_N() {
        return 256;
    }

    public int getSABER_EP() {
        return 10;
    }

    public int getSABER_KEYBYTES() {
        return 32;
    }

    public int getSABER_L() {
        return this.SABER_L;
    }

    public int getSABER_ET() {
        return this.SABER_ET;
    }

    public int getSABER_POLYBYTES() {
        return this.SABER_POLYBYTES;
    }

    public int getSABER_POLYVECBYTES() {
        return this.SABER_POLYVECBYTES;
    }

    public int getSABER_SEEDBYTES() {
        return 32;
    }

    public int getSABER_POLYCOINBYTES() {
        return this.SABER_POLYCOINBYTES;
    }

    public int getSABER_NOISE_SEEDBYTES() {
        return 32;
    }

    public int getSABER_MU() {
        return this.SABER_MU;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public int getSessionKeySize() {
        return this.defaultKeySize / 8;
    }

    public int getCipherTextSize() {
        return this.SABER_BYTES_CCA_DEC;
    }

    public int getPublicKeySize() {
        return this.SABER_PUBLICKEYBYTES;
    }

    public int getPrivateKeySize() {
        return this.SABER_SECRETKEYBYTES;
    }

    public int crypto_kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        SHA3Digest sHA3Digest;
        this.indcpa_kem_keypair(byArray, byArray2, secureRandom);
        int n = 0;
        while (n < this.SABER_INDCPA_PUBLICKEYBYTES) {
            int n2 = n++;
            int n3 = n2 + this.SABER_INDCPA_SECRETKEYBYTES;
            byArray2[n3] = byArray[n2];
        }
        SHA3Digest sHA3Digest2 = sHA3Digest;
        sHA3Digest2(256);
        sHA3Digest2.update(byArray, 0, this.SABER_INDCPA_PUBLICKEYBYTES);
        sHA3Digest.doFinal(byArray2, this.SABER_SECRETKEYBYTES - 64);
        byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        int n4 = this.SABER_SECRETKEYBYTES - 32;
        System.arraycopy(byArray, 0, byArray2, n4, 32);
        return 0;
    }

    public int crypto_kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom object) {
        SHA3Digest sHA3Digest;
        SHA3Digest sHA3Digest2;
        SecureRandom secureRandom = object;
        object = new byte[64];
        byte[] byArray4 = new byte[64];
        byte[] byArray5 = new byte[32];
        secureRandom.nextBytes(byArray5);
        SHA3Digest sHA3Digest3 = sHA3Digest2;
        SABEREngine sABEREngine = this;
        sHA3Digest3(256);
        SHA3Digest sHA3Digest4 = sHA3Digest;
        sHA3Digest4(512);
        sHA3Digest3.update(byArray5, 0, 32);
        sHA3Digest3.doFinal(byArray5, 0);
        System.arraycopy(byArray5, 0, byArray4, 0, 32);
        sHA3Digest3.update(byArray3, 0, this.SABER_INDCPA_PUBLICKEYBYTES);
        sHA3Digest3.doFinal(byArray4, 32);
        sHA3Digest4.update(byArray4, 0, 64);
        sHA3Digest.doFinal((byte[])object, 0);
        sABEREngine.indcpa_kem_enc(byArray4, Arrays.copyOfRange((byte[])object, 32, 64), byArray3, byArray);
        sHA3Digest3.update(byArray, 0, sABEREngine.SABER_BYTES_CCA_DEC);
        sHA3Digest2.doFinal((byte[])object, 32);
        byArray = new byte[32];
        sHA3Digest3.update((byte[])object, 0, 64);
        sHA3Digest3.doFinal(byArray, 0);
        int n = this.defaultKeySize / 8;
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return 0;
    }

    public int crypto_kem_dec(byte[] byArray, byte[] byArray2, byte[] object) {
        SHA3Digest sHA3Digest;
        SHA3Digest sHA3Digest2;
        SABEREngine sABEREngine = this;
        byte[] byArray3 = new byte[sABEREngine.SABER_BYTES_CCA_DEC];
        byte[] byArray4 = new byte[64];
        int n = 64;
        byte[] byArray5 = new byte[64];
        int n2 = sABEREngine.SABER_INDCPA_SECRETKEYBYTES;
        byte[] byArray6 = Arrays.copyOfRange((byte[])object, n2, ((byte[])object).length);
        this.indcpa_kem_dec((byte[])object, byArray2, byArray4);
        for (int k = 0; k < 32; ++k) {
            int n3 = k + 32;
            byArray4[n3] = object[this.SABER_SECRETKEYBYTES - 64 + k];
        }
        byte[] byArray7 = object;
        SABEREngine sABEREngine2 = this;
        object = sHA3Digest2;
        sHA3Digest2 = new SHA3Digest(256);
        SHA3Digest sHA3Digest3 = sHA3Digest;
        sHA3Digest3(512);
        sHA3Digest3.update(byArray4, 0, 64);
        sHA3Digest.doFinal(byArray5, 0);
        sABEREngine2.indcpa_kem_enc(byArray4, Arrays.copyOfRange(byArray5, 32, n), byArray6, byArray3);
        int n4 = SABEREngine.verify(byArray2, byArray3, sABEREngine2.SABER_BYTES_CCA_DEC);
        ((KeccakDigest)object).update(byArray2, 0, this.SABER_BYTES_CCA_DEC);
        ((SHA3Digest)object).doFinal(byArray5, 32);
        int n5 = this.SABER_SECRETKEYBYTES - 32;
        byte by = (byte)n4;
        SABEREngine.cmov(byArray5, byArray7, n5, 32, by);
        byte[] byArray8 = new byte[32];
        ((KeccakDigest)object).update(byArray5, 0, 64);
        ((SHA3Digest)object).doFinal(byArray8, 0);
        int n6 = this.defaultKeySize / 8;
        System.arraycopy(byArray8, 0, byArray, 0, n6);
        return 0;
    }
}

