/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

final class LTreeAddress
extends XMSSAddress {
    private static final int TYPE = 1;
    private final int lTreeAddress;
    private final int treeHeight;
    private final int treeIndex;

    private LTreeAddress(Builder builder) {
        super(builder);
        this.lTreeAddress = builder.lTreeAddress;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    public /* synthetic */ LTreeAddress(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        LTreeAddress lTreeAddress = this;
        Pack.intToBigEndian(lTreeAddress.lTreeAddress, byArray, 16);
        Pack.intToBigEndian(lTreeAddress.treeHeight, byArray, 20);
        Pack.intToBigEndian(lTreeAddress.treeIndex, byArray, 24);
        return byArray;
    }

    public int getLTreeAddress() {
        return this.lTreeAddress;
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public int getTreeIndex() {
        return this.treeIndex;
    }

    public static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int lTreeAddress = 0;
        private int treeHeight = 0;
        private int treeIndex = 0;

        public Builder() {
            super(1);
        }

        public Builder withLTreeAddress(int n) {
            this.lTreeAddress = n;
            return this;
        }

        public Builder withTreeHeight(int n) {
            this.treeHeight = n;
            return this;
        }

        public Builder withTreeIndex(int n) {
            this.treeIndex = n;
            return this;
        }

        @Override
        public XMSSAddress build() {
            return new LTreeAddress(this, null);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

