/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSVerifierUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPublicKeyParameters publicKey;
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private WOTSPlus wotsPlus;
    private boolean hasGenerated;
    private boolean initSign;

    private WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length == this.params.getTreeDigestSize()) {
            if (oTSHashAddress != null) {
                XMSSMTSigner xMSSMTSigner = this;
                WOTSPlus wOTSPlus = xMSSMTSigner.wotsPlus;
                wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), oTSHashAddress), this.privateKey.getPublicSeed());
                return xMSSMTSigner.wotsPlus.sign(byArray, oTSHashAddress);
            }
            throw new NullPointerException("otsHashAddress == null");
        }
        throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            XMSSMTParameters xMSSMTParameters;
            XMSSMTSigner xMSSMTSigner = this;
            XMSSMTSigner xMSSMTSigner2 = this;
            xMSSMTSigner2.initSign = true;
            xMSSMTSigner2.hasGenerated = false;
            this.privateKey = (XMSSMTPrivateKeyParameters)cipherParameters;
            xMSSMTSigner.params = xMSSMTParameters = this.privateKey.getParameters();
            xMSSMTSigner.xmssParams = xMSSMTParameters.getXMSSParameters();
        } else {
            XMSSMTParameters xMSSMTParameters;
            XMSSMTSigner xMSSMTSigner = this;
            this.initSign = false;
            this.publicKey = (XMSSMTPublicKeyParameters)cipherParameters;
            xMSSMTSigner.params = xMSSMTParameters = this.publicKey.getParameters();
            xMSSMTSigner.xmssParams = xMSSMTParameters.getXMSSParameters();
        }
        this.wotsPlus = this.params.getWOTSPlus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public byte[] generateSignature(byte[] object) {
        long l;
        Object object2;
        int n;
        long l2;
        BDSStateMap bDSStateMap;
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters;
        block24: {
            block23: {
                OTSHashAddress.Builder builder;
                XMSSMTSignature.Builder builder2;
                if (object /* !! */  == null) throw new NullPointerException("message == null");
                if (!this.initSign) throw new IllegalStateException("signer not initialized for signature generation");
                xMSSMTPrivateKeyParameters = this.privateKey;
                if (xMSSMTPrivateKeyParameters == null) throw new IllegalStateException("signing key no longer usable");
                // MONITORENTER : xMSSMTPrivateKeyParameters
                if (this.privateKey.getUsagesRemaining() <= 0L) throw new IllegalStateException("no usages of private key remaining");
                if (this.privateKey.getBDSState().isEmpty()) throw new IllegalStateException("not initialized");
                XMSSMTSigner xMSSMTSigner = this;
                XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
                XMSSMTSigner xMSSMTSigner3 = xMSSMTSigner;
                bDSStateMap = xMSSMTSigner.privateKey.getBDSState();
                l2 = xMSSMTSigner.privateKey.getIndex();
                xMSSMTSigner.params.getHeight();
                n = xMSSMTSigner3.xmssParams.getHeight();
                if (xMSSMTSigner2.privateKey.getUsagesRemaining() <= 0L) break block23;
                BDSStateMap bDSStateMap2 = bDSStateMap;
                XMSSMTSigner xMSSMTSigner4 = this;
                long l3 = l2;
                int n2 = n;
                long l4 = l2;
                int n3 = n;
                XMSSMTSigner xMSSMTSigner5 = this;
                XMSSMTSigner xMSSMTSigner6 = xMSSMTSigner5;
                XMSSMTSigner xMSSMTSigner7 = xMSSMTSigner5;
                object2 = this.privateKey.getSecretKeyPRF();
                object2 = xMSSMTSigner5.wotsPlus.getKhf().PRF((byte[])object2, XMSSUtil.toBytesBigEndian(l2, 32));
                XMSSMTSigner xMSSMTSigner8 = this;
                Object object3 = xMSSMTSigner8.privateKey.getRoot();
                object3 = Arrays.concatenate((byte[])object2, object3, XMSSUtil.toBytesBigEndian(l2, xMSSMTSigner8.params.getTreeDigestSize()));
                object /* !! */  = xMSSMTSigner7.wotsPlus.getKhf().HMsg((byte[])object3, object /* !! */ );
                xMSSMTSigner6.hasGenerated = true;
                object3 = builder2;
                object3(this.params);
                object2 = builder2.withIndex(l2).withRandom((byte[])object2).build();
                l = XMSSUtil.getTreeIndex(l4, n3);
                int n4 = XMSSUtil.getLeafIndex(l3, n2);
                xMSSMTSigner4.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
                Object object4 = builder;
                ((OTSHashAddress.Builder)object4)();
                object4 = (OTSHashAddress)((OTSHashAddress.Builder)builder.withTreeAddress(l)).withOTSAddress(n4).build();
                if (bDSStateMap2.get(0) == null || n4 == 0) {
                    XMSSMTSigner xMSSMTSigner9 = this;
                    byte[] byArray = xMSSMTSigner9.privateKey.getPublicSeed();
                    bDSStateMap.put(0, new BDS(this.xmssParams, byArray, xMSSMTSigner9.privateKey.getSecretKeySeed(), (OTSHashAddress)object4));
                }
                Object object5 = object2;
                object /* !! */  = this.wotsSign(object /* !! */ , (OTSHashAddress)object4);
                object /* !! */  = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature((WOTSPlusSignature)object /* !! */ ).withAuthPath(bDSStateMap.get(0).getAuthenticationPath()).build();
                ((XMSSMTSignature)object5).getReducedSignatures().add((XMSSReducedSignature)object /* !! */ );
                break block24;
            }
            throw new IllegalStateException("index out of bounds");
        }
        int n5 = 1;
        while (true) {
            if (n5 >= this.params.getLayers()) break;
            Object object6 = bDSStateMap.get(n5 - 1).getRoot();
            int n6 = XMSSUtil.getLeafIndex(l, n);
            long l5 = XMSSUtil.getTreeIndex(l, n);
            XMSSNode xMSSNode = object6;
            object6 = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n5)).withTreeAddress(l5)).withOTSAddress(n6).build();
            WOTSPlusSignature wOTSPlusSignature = this.wotsSign(xMSSNode.getValue(), (OTSHashAddress)object6);
            if (bDSStateMap.get(n5) == null || XMSSUtil.isNewBDSInitNeeded(l2, n, n5)) {
                XMSSMTSigner xMSSMTSigner = this;
                byte[] byArray = xMSSMTSigner.privateKey.getPublicSeed();
                bDSStateMap.put(n5, new BDS(this.xmssParams, byArray, xMSSMTSigner.privateKey.getSecretKeySeed(), (OTSHashAddress)object6));
            }
            Object object7 = object2;
            object6 = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(bDSStateMap.get(n5).getAuthenticationPath()).build();
            ((XMSSMTSignature)object7).getReducedSignatures().add((XMSSReducedSignature)object6);
            ++n5;
            l = l5;
        }
        byte[] byArray = ((XMSSMTSignature)object2).toByteArray();
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters2 = xMSSMTPrivateKeyParameters;
        this.privateKey.rollKey();
        {
            catch (Throwable throwable) {
                // MONITOREXIT : xMSSMTPrivateKeyParameters
                throw throwable;
            }
        }
        // MONITOREXIT : xMSSMTPrivateKeyParameters2
        return byArray;
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            this.privateKey.rollKey();
            throw throwable2;
        }
    }

    @Override
    public boolean verifySignature(byte[] object, byte[] object2) {
        if (object != null) {
            if (object2 != null) {
                if (this.publicKey != null) {
                    OTSHashAddress.Builder builder;
                    XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.params).withSignature((byte[])object2).build();
                    object2 = xMSSMTSignature;
                    byte[] byArray = Arrays.concatenate(((XMSSMTSignature)object2).getRandom(), this.publicKey.getRoot(), XMSSUtil.toBytesBigEndian(((XMSSMTSignature)object2).getIndex(), this.params.getTreeDigestSize()));
                    object = this.wotsPlus.getKhf().HMsg(byArray, (byte[])object);
                    long l = ((XMSSMTSignature)object2).getIndex();
                    int n = this.xmssParams.getHeight();
                    long l2 = XMSSUtil.getTreeIndex(l, n);
                    int n2 = XMSSUtil.getLeafIndex(l, n);
                    this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.publicKey.getPublicSeed());
                    Object object3 = builder;
                    ((OTSHashAddress.Builder)object3)();
                    object3 = (OTSHashAddress)((OTSHashAddress.Builder)builder.withTreeAddress(l2)).withOTSAddress(n2).build();
                    XMSSReducedSignature xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(0);
                    object = XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, n, (byte[])object, xMSSReducedSignature, (OTSHashAddress)object3, n2);
                    for (n2 = 1; n2 < this.params.getLayers(); ++n2) {
                        XMSSReducedSignature xMSSReducedSignature2 = ((XMSSMTSignature)object2).getReducedSignatures().get(n2);
                        int n3 = XMSSUtil.getLeafIndex(l2, n);
                        long l3 = XMSSUtil.getTreeIndex(l2, n);
                        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n2)).withTreeAddress(l3)).withOTSAddress(n3).build();
                        object = XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, n, ((XMSSNode)object).getValue(), xMSSReducedSignature2, oTSHashAddress, n3);
                        l2 = l3;
                    }
                    return Arrays.constantTimeAreEqual(((XMSSNode)object).getValue(), this.publicKey.getRoot());
                }
                throw new NullPointerException("publicKey == null");
            }
            throw new NullPointerException("signature == null");
        }
        throw new NullPointerException("message == null");
    }

    public long getUsagesRemaining() {
        return this.privateKey.getUsagesRemaining();
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.hasGenerated) {
            this.privateKey = null;
            return this.privateKey;
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.privateKey;
        if (xMSSMTPrivateKeyParameters != null) {
            this.privateKey = xMSSMTPrivateKeyParameters.getNextKey();
        }
        return xMSSMTPrivateKeyParameters;
    }
}

