/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXMSSMTPrivateKey
implements PrivateKey,
XMSSMTPrivateKey {
    private static final long serialVersionUID = 7682140473044521395L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCXMSSMTPrivateKey bCXMSSMTPrivateKey = this;
        bCXMSSMTPrivateKey.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) {
        this.attributes = privateKeyInfo.getAttributes();
        this.treeDigest = XMSSMTKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSMTPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public long getIndex() {
        if (this.getUsagesRemaining() != 0L) {
            return this.keyParams.getIndex();
        }
        throw new IllegalStateException("key exhausted");
    }

    @Override
    public long getUsagesRemaining() {
        return this.keyParams.getUsagesRemaining();
    }

    @Override
    public XMSSMTPrivateKey extractKeyShard(int n) {
        return new BCXMSSMTPrivateKey(this.treeDigest, this.keyParams.extractKeyShard(n));
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            object = (BCXMSSMTPrivateKey)object;
            return this.treeDigest.equals(((BCXMSSMTPrivateKey)object).treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), ((BCXMSSMTPrivateKey)object).keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        BCXMSSMTPrivateKey bCXMSSMTPrivateKey = this;
        int n = bCXMSSMTPrivateKey.treeDigest.hashCode();
        return Arrays.hashCode(bCXMSSMTPrivateKey.keyParams.toByteArray()) * 37 + n;
    }

    public ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }
}

