/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public class GF2nPolynomial {
    private GF2nElement[] coeff;
    private int size;

    public GF2nPolynomial(int n, GF2nElement gF2nElement) {
        this.size = n;
        this.coeff = new GF2nElement[n];
        for (n = 0; n < this.size; ++n) {
            this.coeff[n] = (GF2nElement)gF2nElement.clone();
        }
    }

    private GF2nPolynomial(int n) {
        this.size = n;
        this.coeff = new GF2nElement[n];
    }

    public GF2nPolynomial(GF2nPolynomial gF2nPolynomial) {
        GF2nPolynomial gF2nPolynomial2 = this;
        int n = gF2nPolynomial.size;
        gF2nPolynomial2.coeff = new GF2nElement[n];
        gF2nPolynomial2.size = n;
        for (n = 0; n < this.size; ++n) {
            this.coeff[n] = (GF2nElement)gF2nPolynomial.coeff[n].clone();
        }
    }

    public GF2nPolynomial(GF2Polynomial gF2Polynomial, GF2nField gF2nField) {
        block5: {
            block4: {
                int n;
                block3: {
                    GF2nPolynomial gF2nPolynomial = this;
                    gF2nPolynomial.size = n = gF2nField.getDegree() + 1;
                    gF2nPolynomial.coeff = new GF2nElement[n];
                    if (!(gF2nField instanceof GF2nONBField)) break block3;
                    for (n = 0; n < this.size; ++n) {
                        this.coeff[n] = gF2Polynomial.testBit(n) ? GF2nONBElement.ONE((GF2nONBField)gF2nField) : GF2nONBElement.ZERO((GF2nONBField)gF2nField);
                    }
                    break block4;
                }
                if (gF2nField instanceof GF2nPolynomialField) {
                    for (n = 0; n < this.size; ++n) {
                        this.coeff[n] = gF2Polynomial.testBit(n) ? GF2nPolynomialElement.ONE((GF2nPolynomialField)gF2nField) : GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
                    }
                }
                break block5;
            }
            return;
        }
        throw new IllegalArgumentException("PolynomialGF2n(Bitstring, GF2nField): B1 must be an instance of GF2nONBField or GF2nPolynomialField!");
    }

    public final void assignZeroToElements() {
        for (int k = 0; k < this.size; ++k) {
            this.coeff[k].assignZero();
        }
    }

    public final int size() {
        return this.size;
    }

    public final int getDegree() {
        for (int k = this.size - 1; k >= 0; --k) {
            if (this.coeff[k].isZero()) continue;
            return k;
        }
        return -1;
    }

    public final void enlarge(int n) {
        int n2 = this.size;
        if (n <= n2) {
            return;
        }
        GF2nPolynomial gF2nPolynomial = this;
        GF2nElement[] gF2nElementArray = new GF2nElement[n];
        System.arraycopy(gF2nPolynomial.coeff, 0, gF2nElementArray, 0, n2);
        GF2nField gF2nField = gF2nPolynomial.coeff[0].getField();
        GF2nElement gF2nElement = gF2nPolynomial.coeff[0];
        if (gF2nElement instanceof GF2nPolynomialElement) {
            for (int k = this.size; k < n; ++k) {
                gF2nElementArray[k] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
            }
        } else if (gF2nElement instanceof GF2nONBElement) {
            for (int k = this.size; k < n; ++k) {
                gF2nElementArray[k] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        }
        GF2nPolynomial gF2nPolynomial2 = this;
        gF2nPolynomial2.size = n;
        gF2nPolynomial2.coeff = gF2nElementArray;
    }

    public final void shrink() {
        int n;
        for (n = this.size - 1; this.coeff[n].isZero() && n > 0; --n) {
        }
        if (++n < this.size) {
            GF2nElement[] gF2nElementArray = new GF2nElement[n];
            System.arraycopy(this.coeff, 0, gF2nElementArray, 0, n);
            this.coeff = gF2nElementArray;
            this.size = n;
        }
    }

    public final void set(int n, GF2nElement gF2nElement) {
        if (!(gF2nElement instanceof GF2nPolynomialElement) && !(gF2nElement instanceof GF2nONBElement)) {
            throw new IllegalArgumentException("PolynomialGF2n.set f must be an instance of either GF2nPolynomialElement or GF2nONBElement!");
        }
        this.coeff[n] = (GF2nElement)gF2nElement.clone();
    }

    public final GF2nElement at(int n) {
        return this.coeff[n];
    }

    public final boolean isZero() {
        for (int k = 0; k < this.size; ++k) {
            GF2nElement gF2nElement = this.coeff[k];
            if (gF2nElement == null || gF2nElement.isZero()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof GF2nPolynomial) {
            object = (GF2nPolynomial)object;
            if (this.getDegree() != ((GF2nPolynomial)object).getDegree()) {
                return false;
            }
            for (int k = 0; k < this.size; ++k) {
                if (this.coeff[k].equals(((GF2nPolynomial)object).coeff[k])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getDegree() + this.coeff.hashCode();
    }

    public final GF2nPolynomial add(GF2nPolynomial gF2nPolynomial) {
        GF2nPolynomial gF2nPolynomial2;
        if (this.size() >= gF2nPolynomial.size()) {
            int n;
            GF2nPolynomial gF2nPolynomial3;
            gF2nPolynomial2 = gF2nPolynomial3;
            gF2nPolynomial3 = new GF2nPolynomial(this.size());
            for (n = 0; n < gF2nPolynomial.size(); ++n) {
                gF2nPolynomial2.coeff[n] = (GF2nElement)this.coeff[n].add(gF2nPolynomial.coeff[n]);
            }
            while (n < this.size()) {
                gF2nPolynomial2.coeff[n] = this.coeff[n];
                ++n;
            }
        } else {
            int n;
            GF2nPolynomial gF2nPolynomial4;
            gF2nPolynomial2 = gF2nPolynomial4;
            gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial.size());
            for (n = 0; n < this.size(); ++n) {
                gF2nPolynomial2.coeff[n] = (GF2nElement)this.coeff[n].add(gF2nPolynomial.coeff[n]);
            }
            while (n < gF2nPolynomial.size()) {
                gF2nPolynomial2.coeff[n] = gF2nPolynomial.coeff[n];
                ++n;
            }
        }
        return gF2nPolynomial2;
    }

    public final GF2nPolynomial scalarMultiply(GF2nElement gF2nElement) {
        GF2nPolynomial gF2nPolynomial;
        GF2nPolynomial gF2nPolynomial2 = gF2nPolynomial;
        gF2nPolynomial = new GF2nPolynomial(this.size());
        for (int k = 0; k < this.size(); ++k) {
            gF2nPolynomial2.coeff[k] = (GF2nElement)this.coeff[k].multiply(gF2nElement);
        }
        return gF2nPolynomial2;
    }

    public final GF2nPolynomial multiply(GF2nPolynomial gF2nPolynomial) {
        int n = this.size();
        if (n == gF2nPolynomial.size()) {
            GF2nPolynomial gF2nPolynomial2;
            GF2nPolynomial gF2nPolynomial3 = gF2nPolynomial2;
            gF2nPolynomial2 = new GF2nPolynomial((n << 1) - 1);
            for (n = 0; n < this.size(); ++n) {
                for (int k = 0; k < gF2nPolynomial.size(); ++k) {
                    GF2nElement[] gF2nElementArray = gF2nPolynomial3.coeff;
                    int n2 = n + k;
                    GF2nElement gF2nElement = gF2nPolynomial3.coeff[n2];
                    gF2nElementArray[n2] = gF2nElement == null ? (GF2nElement)this.coeff[n].multiply(gF2nPolynomial.coeff[k]) : (GF2nElement)gF2nElement.add(this.coeff[n].multiply(gF2nPolynomial.coeff[k]));
                }
            }
            return gF2nPolynomial3;
        }
        throw new IllegalArgumentException("PolynomialGF2n.multiply: this and b must have the same size!");
    }

    public final GF2nPolynomial multiplyAndReduce(GF2nPolynomial gF2nPolynomial, GF2nPolynomial gF2nPolynomial2) {
        return this.multiply(gF2nPolynomial).reduce(gF2nPolynomial2);
    }

    public final GF2nPolynomial reduce(GF2nPolynomial gF2nPolynomial) {
        return this.remainder(gF2nPolynomial);
    }

    public final void shiftThisLeft(int n) {
        block3: {
            GF2nElement gF2nElement;
            GF2nField gF2nField;
            block4: {
                if (n <= 0) break block3;
                GF2nPolynomial gF2nPolynomial = this;
                gF2nField = gF2nPolynomial.coeff[0].getField();
                gF2nPolynomial.enlarge(gF2nPolynomial.size + n);
                for (int k = this.size - 1; k >= 0; --k) {
                    int n2 = k + n;
                    this.coeff[n2] = this.coeff[k];
                }
                gF2nElement = this.coeff[0];
                if (!(gF2nElement instanceof GF2nPolynomialElement)) break block4;
                --n;
                while (n >= 0) {
                    this.coeff[n] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
                    --n;
                }
                break block3;
            }
            if (!(gF2nElement instanceof GF2nONBElement)) break block3;
            --n;
            while (n >= 0) {
                this.coeff[n] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
                --n;
            }
        }
    }

    public final GF2nPolynomial shiftLeft(int n) {
        GF2nPolynomial gF2nPolynomial;
        if (n <= 0) {
            return new GF2nPolynomial(this);
        }
        GF2nPolynomial gF2nPolynomial2 = gF2nPolynomial;
        new GF2nPolynomial(this.size + n, this.coeff[0]).assignZeroToElements();
        for (int k = 0; k < this.size; ++k) {
            gF2nPolynomial2.coeff[k + n] = this.coeff[k];
        }
        return gF2nPolynomial2;
    }

    public final GF2nPolynomial[] divide(GF2nPolynomial gF2nPolynomial) {
        GF2nPolynomial gF2nPolynomial2;
        GF2nPolynomial gF2nPolynomial3;
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        Object object = gF2nPolynomial3;
        new GF2nPolynomial(this).shrink();
        int n = gF2nPolynomial.getDegree();
        GF2nElement gF2nElement = (GF2nElement)gF2nPolynomial.coeff[n].invert();
        if (((GF2nPolynomial)object).getDegree() < n) {
            GF2nPolynomial gF2nPolynomial4;
            GF2nPolynomial gF2nPolynomial5;
            gF2nPolynomial = gF2nPolynomial5;
            gF2nPolynomial(this);
            gF2nPolynomialArray[0] = gF2nPolynomial;
            gF2nPolynomial5.assignZeroToElements();
            gF2nPolynomialArray[0].shrink();
            gF2nPolynomial = gF2nPolynomial4;
            gF2nPolynomial(this);
            gF2nPolynomialArray[1] = gF2nPolynomial;
            gF2nPolynomial4.shrink();
            return gF2nPolynomialArray;
        }
        GF2nPolynomial gF2nPolynomial6 = gF2nPolynomial2;
        gF2nPolynomial6(this);
        gF2nPolynomialArray[0] = gF2nPolynomial6;
        gF2nPolynomial2.assignZeroToElements();
        int n2 = ((GF2nPolynomial)object).getDegree() - n;
        while (n2 >= 0) {
            GF2nPolynomial gF2nPolynomial7 = object;
            object = (GF2nElement)((GF2nPolynomial)object).coeff[((GF2nPolynomial)object).getDegree()].multiply(gF2nElement);
            GF2nPolynomial gF2nPolynomial8 = gF2nPolynomial.scalarMultiply((GF2nElement)object);
            gF2nPolynomial8.shiftThisLeft(n2);
            gF2nPolynomial6 = gF2nPolynomial7.add(gF2nPolynomial8);
            gF2nPolynomial6.shrink();
            gF2nPolynomialArray[0].coeff[n2] = (GF2nElement)((GF2nElement)object).clone();
            n2 = gF2nPolynomial6.getDegree() - n;
            object = gF2nPolynomial6;
        }
        GF2nPolynomial[] gF2nPolynomialArray2 = gF2nPolynomialArray;
        gF2nPolynomialArray2[1] = object;
        gF2nPolynomialArray2[0].shrink();
        return gF2nPolynomialArray;
    }

    public final GF2nPolynomial remainder(GF2nPolynomial gF2nPolynomial) {
        return this.divide(gF2nPolynomial)[1];
    }

    public final GF2nPolynomial quotient(GF2nPolynomial gF2nPolynomial) {
        return this.divide(gF2nPolynomial)[0];
    }

    public final GF2nPolynomial gcd(GF2nPolynomial gF2nPolynomial) {
        GF2nPolynomial gF2nPolynomial2;
        GF2nPolynomial gF2nPolynomial3;
        GF2nPolynomial gF2nPolynomial4 = gF2nPolynomial3;
        gF2nPolynomial3 = new GF2nPolynomial(gF2nPolynomial5);
        GF2nPolynomial gF2nPolynomial5 = gF2nPolynomial2;
        gF2nPolynomial5(gF2nPolynomial);
        gF2nPolynomial4.shrink();
        gF2nPolynomial2.shrink();
        GF2nPolynomial gF2nPolynomial6 = gF2nPolynomial5;
        gF2nPolynomial5 = gF2nPolynomial4;
        gF2nPolynomial4 = gF2nPolynomial6;
        while (!gF2nPolynomial4.isZero()) {
            GF2nPolynomial gF2nPolynomial7 = gF2nPolynomial5 = gF2nPolynomial5.remainder(gF2nPolynomial4);
            gF2nPolynomial5 = gF2nPolynomial4;
            gF2nPolynomial4 = gF2nPolynomial7;
        }
        GF2nPolynomial gF2nPolynomial8 = gF2nPolynomial5;
        return gF2nPolynomial8.scalarMultiply((GF2nElement)gF2nPolynomial8.coeff[gF2nPolynomial5.getDegree()].invert());
    }
}

