/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.test;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.test.SimpleTestResult;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.test.Test;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.test.TestFailedException;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.test.TestResult;
import java.io.PrintStream;
import java.util.Vector;

public abstract class SimpleTest
implements Test {
    private TestResult success() {
        return SimpleTestResult.successful(this, "Okay");
    }

    public static void runTest(Test test) {
        SimpleTest.runTest(test, System.out);
    }

    public static void runTest(Test object, PrintStream printStream) {
        if ((object = object.perform()).getException() != null) {
            object.getException().printStackTrace(printStream);
        }
        printStream.println(object);
    }

    public static void runTests(Test[] testArray) {
        SimpleTest.runTests(testArray, System.out);
    }

    public static void runTests(Test[] object, PrintStream printStream) {
        Vector<TestResult> vector;
        Vector<TestResult> vector2 = vector;
        vector = new Vector<TestResult>();
        for (int k = 0; k != ((Test[])object).length; ++k) {
            TestResult testResult = object[k].perform();
            if (!testResult.isSuccessful()) {
                vector2.addElement(testResult);
            }
            if (testResult.getException() != null) {
                testResult.getException().printStackTrace(printStream);
            }
            printStream.println(testResult);
        }
        printStream.println("-----");
        if (vector2.isEmpty()) {
            printStream.println("All tests successful.");
        } else {
            printStream.println(b.a("Completed with ").append(vector2.size()).append(" FAILURES:").toString());
            object = vector2.elements();
            while (object.hasMoreElements()) {
                System.out.println(b.a("=>  ").append((TestResult)object.nextElement()).toString());
            }
        }
    }

    @Override
    public abstract String getName();

    public void fail(String string) {
        throw new TestFailedException(SimpleTestResult.failed(this, string));
    }

    public void isTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, "no message"));
    }

    public void isTrue(String string, boolean bl) {
        if (bl) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, string));
    }

    public void isEquals(Object object, Object object2) {
        if (object.equals(object2)) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, "no message"));
    }

    public void isEquals(int n, int n2) {
        if (n == n2) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, "no message"));
    }

    public void isEquals(long l, long l2) {
        if (l == l2) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, "no message"));
    }

    public void isEquals(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, string));
    }

    public void isEquals(String string, long l, long l2) {
        if (l == l2) {
            return;
        }
        throw new TestFailedException(SimpleTestResult.failed(this, string));
    }

    public void isEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null) {
            if (object2 != null) {
                if (object.equals(object2)) {
                    return;
                }
                throw new TestFailedException(SimpleTestResult.failed(this, string));
            }
            throw new TestFailedException(SimpleTestResult.failed(this, string));
        }
        throw new TestFailedException(SimpleTestResult.failed(this, string));
    }

    public boolean areEqual(byte[][] byArray, byte[][] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray != null && byArray2 != null) {
            if (byArray.length != byArray2.length) {
                return false;
            }
            for (int k = 0; k < byArray.length; ++k) {
                byte[] byArray3 = byArray[k];
                if (this.areEqual(byArray3, byArray2[k])) {
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void fail(String string, Throwable throwable) {
        throw new TestFailedException(SimpleTestResult.failed(this, string, throwable));
    }

    public void fail(String string, Object object, Object object2) {
        throw new TestFailedException(SimpleTestResult.failed(this, string, object, object2));
    }

    public boolean areEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.areEqual(byArray, byArray2);
    }

    public boolean areEqual(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return Arrays.areEqual(byArray, n, n2, byArray2, n3, n4);
    }

    @Override
    public TestResult perform() {
        try {
            SimpleTest simpleTest = this;
            simpleTest.performTest();
            return simpleTest.success();
        }
        catch (Exception exception) {
            return SimpleTestResult.failed(this, "Exception: " + exception, exception);
        }
        catch (TestFailedException testFailedException) {
            return testFailedException.getResult();
        }
    }

    public abstract void performTest();
}

