/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class X509Util {
    private static Hashtable algorithms;
    private static Hashtable params;
    private static Set noParams;

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier aSN1Object, int n) {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2 = aSN1Object;
        AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, aSN1Object);
        aSN1Object = aSN1Integer2;
        aSN1Integer2 = new ASN1Integer(n);
        ASN1Integer aSN1Integer3 = aSN1Integer;
        aSN1Integer = new ASN1Integer(1L);
        return new RSASSAPSSparams(algorithmIdentifier2, algorithmIdentifier3, (ASN1Integer)aSN1Object, aSN1Integer3);
    }

    public static ASN1ObjectIdentifier getAlgorithmOID(String string) {
        if (algorithms.containsKey(string = Strings.toUpperCase(string))) {
            return (ASN1ObjectIdentifier)algorithms.get(string);
        }
        return new ASN1ObjectIdentifier(string);
    }

    public static AlgorithmIdentifier getSigAlgID(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (noParams.contains(aSN1ObjectIdentifier)) {
            return new AlgorithmIdentifier(aSN1ObjectIdentifier);
        }
        if (params.containsKey(string = Strings.toUpperCase(string))) {
            return new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)params.get(string));
        }
        return new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
    }

    public static Iterator getAlgNames() {
        ArrayList arrayList;
        Enumeration enumeration = algorithms.keys();
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList2.add(enumeration.nextElement());
        }
        return arrayList2.iterator();
    }

    public static Signature getSignatureInstance(String string) {
        return Signature.getInstance(string);
    }

    public static Signature getSignatureInstance(String string, String string2) {
        if (string2 != null) {
            return Signature.getInstance(string, string2);
        }
        return Signature.getInstance(string);
    }

    public static byte[] calculateSignature(ASN1ObjectIdentifier object, String string, PrivateKey privateKey, SecureRandom secureRandom, ASN1Encodable aSN1Encodable) {
        if (object != null) {
            object = X509Util.getSignatureInstance(string);
            if (secureRandom != null) {
                ((Signature)object).initSign(privateKey, secureRandom);
            } else {
                ((Signature)object).initSign(privateKey);
            }
            Object object2 = object;
            ((Signature)object2).update(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            return ((Signature)object2).sign();
        }
        throw new IllegalStateException("no signature algorithm specified");
    }

    public static byte[] calculateSignature(ASN1ObjectIdentifier object, String string, String string2, PrivateKey privateKey, SecureRandom secureRandom, ASN1Encodable aSN1Encodable) {
        if (object != null) {
            object = X509Util.getSignatureInstance(string, string2);
            if (secureRandom != null) {
                ((Signature)object).initSign(privateKey, secureRandom);
            } else {
                ((Signature)object).initSign(privateKey);
            }
            Object object2 = object;
            ((Signature)object2).update(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            return ((Signature)object2).sign();
        }
        throw new IllegalStateException("no signature algorithm specified");
    }

    public static X509Principal convertPrincipal(X500Principal x500Principal) {
        try {
            return new X509Principal(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot convert principal");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Implementation getImplementation(String string, String string2, Provider provider) {
        Class<?> clazz;
        string2 = Strings.toUpperCase(string2);
        while ((clazz = provider.getProperty("Alg.Alias." + string + "." + string2)) != null) {
            string2 = clazz;
        }
        if ((string = provider.getProperty(string + "." + string2)) == null) throw new NoSuchAlgorithmException("cannot find implementation " + string2 + " for provider " + provider.getName());
        try {
            clazz = provider.getClass().getClassLoader();
            clazz = clazz != null ? ((ClassLoader)((Object)clazz)).loadClass(string) : Class.forName(string);
            return new Implementation(clazz.newInstance(), provider);
        }
        catch (Exception exception) {
            throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but class \"" + string + "\" inaccessible!");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but no class \"" + string + "\" found!");
        }
    }

    public static Implementation getImplementation(String string, String string2) {
        Provider[] providerArray = Security.getProviders();
        for (int k = 0; k != providerArray.length; ++k) {
            Object object = Strings.toUpperCase(string2);
            if ((object = X509Util.getImplementation(string, (String)object, providerArray[k])) != null) {
                return object;
            }
            try {
                X509Util.getImplementation(string, string2, providerArray[k]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        throw new NoSuchAlgorithmException(i.a("cannot find implementation ", string2));
    }

    public static Provider getProvider(String string) {
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            return provider;
        }
        throw new NoSuchProviderException(g.a("Provider ", string, " not found"));
    }

    static {
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2;
        AlgorithmIdentifier algorithmIdentifier3;
        AlgorithmIdentifier algorithmIdentifier4;
        AlgorithmIdentifier algorithmIdentifier5;
        algorithms = new Hashtable();
        params = new Hashtable();
        noParams = new HashSet();
        ASN1Object aSN1Object = PKCSObjectIdentifiers.md2WithRSAEncryption;
        algorithms.put("MD2WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("MD2WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.md5WithRSAEncryption;
        algorithms.put("MD5WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("MD5WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha1WithRSAEncryption;
        algorithms.put("SHA1WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA1WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha224WithRSAEncryption;
        algorithms.put("SHA224WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA224WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha256WithRSAEncryption;
        algorithms.put("SHA256WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA256WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha384WithRSAEncryption;
        algorithms.put("SHA384WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA384WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha512WithRSAEncryption;
        algorithms.put("SHA512WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA512WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.id_RSASSA_PSS;
        algorithms.put("SHA1WITHRSAANDMGF1", aSN1Object);
        algorithms.put("SHA224WITHRSAANDMGF1", aSN1Object);
        algorithms.put("SHA256WITHRSAANDMGF1", aSN1Object);
        algorithms.put("SHA384WITHRSAANDMGF1", aSN1Object);
        algorithms.put("SHA512WITHRSAANDMGF1", aSN1Object);
        aSN1Object = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160;
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("RIPEMD160WITHRSA", aSN1Object);
        aSN1Object = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128;
        algorithms.put("RIPEMD128WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("RIPEMD128WITHRSA", aSN1Object);
        aSN1Object = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256;
        algorithms.put("RIPEMD256WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("RIPEMD256WITHRSA", aSN1Object);
        aSN1Object = X9ObjectIdentifiers.id_dsa_with_sha1;
        algorithms.put("SHA1WITHDSA", aSN1Object);
        algorithms.put("DSAWITHSHA1", aSN1Object);
        ASN1Primitive aSN1Primitive = NISTObjectIdentifiers.dsa_with_sha224;
        algorithms.put("SHA224WITHDSA", aSN1Primitive);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.dsa_with_sha256;
        algorithms.put("SHA256WITHDSA", aSN1ObjectIdentifier);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = NISTObjectIdentifiers.dsa_with_sha384;
        algorithms.put("SHA384WITHDSA", aSN1ObjectIdentifier2);
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = NISTObjectIdentifiers.dsa_with_sha512;
        algorithms.put("SHA512WITHDSA", aSN1ObjectIdentifier3);
        ASN1ObjectIdentifier aSN1ObjectIdentifier4 = X9ObjectIdentifiers.ecdsa_with_SHA1;
        algorithms.put("SHA1WITHECDSA", aSN1ObjectIdentifier4);
        algorithms.put("ECDSAWITHSHA1", aSN1ObjectIdentifier4);
        ASN1ObjectIdentifier aSN1ObjectIdentifier5 = X9ObjectIdentifiers.ecdsa_with_SHA224;
        algorithms.put("SHA224WITHECDSA", aSN1ObjectIdentifier5);
        ASN1ObjectIdentifier aSN1ObjectIdentifier6 = X9ObjectIdentifiers.ecdsa_with_SHA256;
        algorithms.put("SHA256WITHECDSA", aSN1ObjectIdentifier6);
        ASN1ObjectIdentifier aSN1ObjectIdentifier7 = X9ObjectIdentifiers.ecdsa_with_SHA384;
        algorithms.put("SHA384WITHECDSA", aSN1ObjectIdentifier7);
        ASN1ObjectIdentifier aSN1ObjectIdentifier8 = X9ObjectIdentifiers.ecdsa_with_SHA512;
        algorithms.put("SHA512WITHECDSA", aSN1ObjectIdentifier8);
        ASN1ObjectIdentifier aSN1ObjectIdentifier9 = CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94;
        algorithms.put("GOST3411WITHGOST3410", aSN1ObjectIdentifier9);
        algorithms.put("GOST3411WITHGOST3410-94", aSN1ObjectIdentifier9);
        ASN1ObjectIdentifier aSN1ObjectIdentifier10 = CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001;
        algorithms.put("GOST3411WITHECGOST3410", aSN1ObjectIdentifier10);
        algorithms.put("GOST3411WITHECGOST3410-2001", aSN1ObjectIdentifier10);
        algorithms.put("GOST3411WITHGOST3410-2001", aSN1ObjectIdentifier10);
        noParams.add(aSN1ObjectIdentifier4);
        noParams.add(aSN1ObjectIdentifier5);
        noParams.add(aSN1ObjectIdentifier6);
        noParams.add(aSN1ObjectIdentifier7);
        noParams.add(aSN1ObjectIdentifier8);
        noParams.add(aSN1Object);
        noParams.add(OIWObjectIdentifiers.dsaWithSHA1);
        noParams.add(aSN1Primitive);
        noParams.add(aSN1ObjectIdentifier);
        noParams.add(aSN1ObjectIdentifier2);
        noParams.add(aSN1ObjectIdentifier3);
        noParams.add(aSN1ObjectIdentifier9);
        noParams.add(aSN1ObjectIdentifier10);
        aSN1Object = algorithmIdentifier5;
        aSN1Primitive = DERNull.INSTANCE;
        algorithmIdentifier5 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, aSN1Primitive);
        params.put("SHA1WITHRSAANDMGF1", X509Util.creatPSSParams((AlgorithmIdentifier)aSN1Object, 20));
        aSN1Object = algorithmIdentifier4;
        algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, aSN1Primitive);
        params.put("SHA224WITHRSAANDMGF1", X509Util.creatPSSParams((AlgorithmIdentifier)aSN1Object, 28));
        aSN1Object = algorithmIdentifier3;
        algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, aSN1Primitive);
        params.put("SHA256WITHRSAANDMGF1", X509Util.creatPSSParams((AlgorithmIdentifier)aSN1Object, 32));
        aSN1Object = algorithmIdentifier2;
        algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, aSN1Primitive);
        params.put("SHA384WITHRSAANDMGF1", X509Util.creatPSSParams((AlgorithmIdentifier)aSN1Object, 48));
        aSN1Object = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, aSN1Primitive);
        params.put("SHA512WITHRSAANDMGF1", X509Util.creatPSSParams((AlgorithmIdentifier)aSN1Object, 64));
    }

    public static class Implementation {
        public Object engine;
        public Provider provider;

        public Implementation(Object object, Provider provider) {
            this.engine = object;
            this.provider = provider;
        }

        public Object getEngine() {
            return this.engine;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }
}

