/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractTaggedLDSFile;
import com.fis.ekyc.nfc.build_in.eidparser.lds.LDSFileUtil;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import h.a;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class COMFile
extends AbstractTaggedLDSFile {
    private static final long serialVersionUID = 2002455279067170063L;
    private static final int TAG_LIST_TAG = 92;
    private static final int VERSION_UNICODE_TAG = 24374;
    private static final int VERSION_LDS_TAG = 24321;
    private String versionLDS;
    private String updateLevelLDS;
    private String majorVersionUnicode;
    private String minorVersionUnicode;
    private String releaseLevelUnicode;
    private List<Integer> tagList;

    public COMFile(String string2, String string3, String string4, String string5, String string6, int[] nArray) {
        COMFile cOMFile = this;
        super(96);
        cOMFile.initialize(string2, string3, string4, string5, string6, nArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public COMFile(String object, String object2, int[] nArray) {
        super(96);
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        if (object == null) throw new IllegalArgumentException("Null versionLDS");
        if (object2 == null) throw new IllegalArgumentException("Null versionUnicode");
        Object object3 = stringTokenizer2;
        if (new StringTokenizer((String)object, ".").countTokens() != 2) throw new IllegalArgumentException("Could not parse LDS version. Expecting 2 level version number x.y.");
        StringTokenizer stringTokenizer3 = object3;
        StringTokenizer stringTokenizer4 = stringTokenizer3;
        object = Integer.parseInt(stringTokenizer3.nextToken().trim());
        object3 = Integer.parseInt(stringTokenizer4.nextToken().trim());
        Object object4 = stringTokenizer;
        if (new StringTokenizer((String)object2, ".").countTokens() != 3) throw new IllegalArgumentException("Could not parse unicode version. Expecting 3 level version number x.y.z.");
        COMFile cOMFile = this;
        StringTokenizer stringTokenizer5 = object4;
        StringTokenizer stringTokenizer6 = stringTokenizer5;
        StringTokenizer stringTokenizer7 = stringTokenizer5;
        object2 = Integer.parseInt(stringTokenizer5.nextToken().trim());
        object4 = Integer.parseInt(stringTokenizer7.nextToken().trim());
        Integer n = Integer.parseInt(stringTokenizer6.nextToken().trim());
        try {
            cOMFile.initialize(String.format("%02d", object), String.format("%02d", object3), String.format("%02d", object2), String.format("%02d", object4), String.format("%02d", n), nArray);
            return;
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {
            throw new IllegalArgumentException("Could not parse version number", illegalFormatConversionException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not parse version number", numberFormatException);
        }
    }

    public COMFile(InputStream inputStream) {
        super(96, inputStream);
    }

    private void initialize(String string2, String string3, String string4, String string5, String string6, int[] nArray) {
        if (nArray != null) {
            if (string2 != null && string2.length() == 2 && string3 != null && string3.length() == 2 && string4 != null && string4.length() == 2 && string5 != null && string5.length() == 2 && string6 != null && string6.length() == 2) {
                COMFile cOMFile = this;
                this.versionLDS = string2;
                this.updateLevelLDS = string3;
                this.majorVersionUnicode = string4;
                this.minorVersionUnicode = string5;
                cOMFile.releaseLevelUnicode = string6;
                cOMFile.tagList = new ArrayList<Integer>(nArray.length);
                for (int n : nArray) {
                    this.tagList.add(n);
                }
                return;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException("Null tag list");
    }

    @Override
    public void readContent(InputStream object) {
        if (object instanceof TLVInputStream) {
            object = (TLVInputStream)object;
        } else {
            TLVInputStream tLVInputStream;
            TLVInputStream tLVInputStream2 = tLVInputStream;
            tLVInputStream = new TLVInputStream((InputStream)object);
            object = tLVInputStream2;
        }
        int n = ((TLVInputStream)object).readTag();
        if (n == 24321) {
            if (((TLVInputStream)object).readLength() == 4) {
                String string2;
                String string3;
                COMFile cOMFile = this;
                byte[] byArray = ((TLVInputStream)object).readValue();
                String string4 = string3;
                string3 = new String(byArray, 0, 2);
                cOMFile.versionLDS = string4;
                string4 = string2;
                string2 = new String(byArray, 2, 2);
                cOMFile.updateLevelLDS = string4;
                int n2 = ((TLVInputStream)object).readTag();
                if (n2 == 24374) {
                    if (((TLVInputStream)object).readLength() == 6) {
                        String string5;
                        String string6;
                        String string7;
                        COMFile cOMFile2 = this;
                        byte[] byArray2 = ((TLVInputStream)object).readValue();
                        string4 = string7;
                        string7 = new String(byArray2, 0, 2);
                        cOMFile2.majorVersionUnicode = string4;
                        string4 = string6;
                        string6 = new String(byArray2, 2, 2);
                        cOMFile2.minorVersionUnicode = string4;
                        string4 = string5;
                        string5 = new String(byArray2, 4, 2);
                        cOMFile2.releaseLevelUnicode = string4;
                        int n3 = ((TLVInputStream)object).readTag();
                        if (n3 == 92) {
                            ArrayList<Integer> arrayList;
                            InputStream inputStream = object;
                            ((TLVInputStream)inputStream).readLength();
                            byte[] byArray3 = ((TLVInputStream)inputStream).readValue();
                            object = byArray3;
                            ArrayList<Integer> arrayList2 = arrayList;
                            arrayList = new ArrayList<Integer>();
                            this.tagList = arrayList2;
                            int n4 = byArray3.length;
                            for (int k = 0; k < n4; ++k) {
                                int n5 = object[k] & 0xFF;
                                this.tagList.add(n5);
                            }
                            return;
                        }
                        throw new IllegalArgumentException(h.a(n3, a.a(92, b.a("Expected TAG_LIST_TAG ("), "), found ")));
                    }
                    throw new IllegalArgumentException("Wrong length of LDS version object");
                }
                throw new IllegalArgumentException(h.a(n2, a.a(24374, b.a("Expected VERSION_UNICODE_TAG ("), "), found ")));
            }
            throw new IllegalArgumentException("Wrong length of LDS version object");
        }
        throw new IllegalArgumentException(h.a(n, a.a(24321, b.a("Excepected VERSION_LDS_TAG ("), "), found ")));
    }

    public String getLDSVersion() {
        int n;
        COMFile cOMFile = object;
        Object object = ((COMFile)object).versionLDS + "." + ((COMFile)object).updateLevelLDS;
        try {
            n = Integer.parseInt(cOMFile.versionLDS);
        }
        catch (NumberFormatException numberFormatException) {}
        int n2 = Integer.parseInt(cOMFile.updateLevelLDS);
        object = n + "." + n2;
        return object;
    }

    public String getUnicodeVersion() {
        int n;
        COMFile cOMFile = object;
        Object object = ((COMFile)object).majorVersionUnicode + "." + ((COMFile)object).minorVersionUnicode + "." + ((COMFile)object).releaseLevelUnicode;
        try {
            n = Integer.parseInt(cOMFile.majorVersionUnicode);
        }
        catch (NumberFormatException numberFormatException) {}
        int n2 = Integer.parseInt(cOMFile.minorVersionUnicode);
        int n3 = Integer.parseInt(cOMFile.releaseLevelUnicode);
        object = n + "." + n2 + "." + n3;
        return object;
    }

    public int[] getTagList() {
        COMFile cOMFile = object;
        Object object = new int[cOMFile.tagList.size()];
        int n = 0;
        Iterator<Integer> iterator = cOMFile.tagList.iterator();
        while (iterator.hasNext()) {
            object[n++] = iterator.next();
        }
        return object;
    }

    public void insertTag(Integer n) {
        if (this.tagList.contains(n)) {
            return;
        }
        COMFile cOMFile = this;
        cOMFile.tagList.add(n);
        Collections.sort(cOMFile.tagList);
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = tLVOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((TLVOutputStream)outputStream2).writeTag(24321);
        ((TLVOutputStream)outputStream2).writeValue((((COMFile)((Object)iterator)).versionLDS + ((COMFile)((Object)iterator)).updateLevelLDS).getBytes());
        ((TLVOutputStream)outputStream2).writeTag(24374);
        ((TLVOutputStream)outputStream2).writeValue((((COMFile)((Object)iterator)).majorVersionUnicode + ((COMFile)((Object)iterator)).minorVersionUnicode + ((COMFile)((Object)iterator)).releaseLevelUnicode).getBytes());
        ((TLVOutputStream)outputStream2).writeTag(92);
        ((TLVOutputStream)outputStream).writeLength(((COMFile)((Object)iterator)).tagList.size());
        Iterator<Integer> iterator = ((COMFile)((Object)iterator)).tagList.iterator();
        while (iterator.hasNext()) {
            ((TLVOutputStream)outputStream).write((byte)((Integer)iterator.next()).intValue());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        COMFile cOMFile = this;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("COMFile ");
        stringBuilder2.append(b.a("LDS ").append(this.versionLDS).append(".").append(this.updateLevelLDS).toString());
        stringBuilder2.append(", ");
        stringBuilder2.append("Unicode " + this.majorVersionUnicode + "." + this.minorVersionUnicode + "." + this.releaseLevelUnicode);
        stringBuilder2.append(", ");
        int n = 0;
        stringBuilder2.append("[");
        int n2 = cOMFile.tagList.size();
        Iterator<Integer> iterator = cOMFile.tagList.iterator();
        while (iterator.hasNext()) {
            stringBuilder2.append(b.a("DG").append(LDSFileUtil.lookupDataGroupNumberByTag(iterator.next())).toString());
            if (n < n2 - 1) {
                stringBuilder2.append(", ");
            }
            ++n;
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        object = (COMFile)object;
        return this.versionLDS.equals(((COMFile)object).versionLDS) && this.updateLevelLDS.equals(((COMFile)object).updateLevelLDS) && this.majorVersionUnicode.equals(((COMFile)object).majorVersionUnicode) && this.minorVersionUnicode.equals(((COMFile)object).minorVersionUnicode) && this.releaseLevelUnicode.equals(((COMFile)object).releaseLevelUnicode) && this.tagList.equals(((COMFile)object).tagList);
    }

    public int hashCode() {
        COMFile cOMFile = this;
        int n = cOMFile.versionLDS.hashCode() * 3;
        n = cOMFile.updateLevelLDS.hashCode() * 5 + n;
        n = cOMFile.majorVersionUnicode.hashCode() * 7 + n;
        n = cOMFile.minorVersionUnicode.hashCode() * 11 + n;
        n = cOMFile.releaseLevelUnicode.hashCode() * 13 + n;
        return cOMFile.tagList.hashCode() * 17 + n;
    }
}

