/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive {
    public final boolean isConstructed;
    public final int tag;
    public final byte[] octets;

    public ASN1ApplicationSpecific(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.octets = Arrays.clone(byArray);
    }

    public static ASN1ApplicationSpecific getInstance(Object object) {
        if (object != null && !(object instanceof ASN1ApplicationSpecific)) {
            if (object instanceof byte[]) {
                try {
                    return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("Failed to construct object from byte[]: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("unknown object in getInstance: ")));
        }
        return (ASN1ApplicationSpecific)object;
    }

    public static int getLengthOfHeader(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        if (n == 128) {
            return 2;
        }
        if (n > 127) {
            if ((n &= 0x7F) <= 4) {
                return n + 2;
            }
            throw new IllegalStateException(a.a("DER length more than 4 bytes: ", n));
        }
        return 2;
    }

    private byte[] replaceTagNumber(int n, byte[] byArray) {
        int n2;
        int n3 = 1;
        if ((byArray[0] & 0x1F) == 31) {
            int n4 = n3;
            n3 = 2;
            n2 = byArray[n4] & 0xFF;
            if ((n2 & 0x7F) != 0) {
                while ((n2 & 0x80) != 0) {
                    n2 = byArray[n3++] & 0xFF;
                }
            } else {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
        }
        n2 = byArray.length - n3 + 1;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = byArray2;
        int n5 = n3;
        n3 = n2 - 1;
        System.arraycopy(byArray, n5, byArray3, 1, n3);
        byArray2[0] = (byte)n;
        return byArray2;
    }

    @Override
    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return Arrays.clone(this.octets);
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() {
        return ASN1Primitive.fromByteArray(this.getContents());
    }

    public ASN1Primitive getObject(int n) {
        if (n < 31) {
            byte[] byArray = ((ASN1Object)object).getEncoded();
            Object object = ((ASN1ApplicationSpecific)object).replaceTagNumber(n, byArray);
            if ((byArray[0] & 0x20) != 0) {
                Object object2 = object;
                object2[0] = (byte)(object2[0] | 0x20);
            }
            return ASN1Primitive.fromByteArray((byte[])object);
        }
        throw new IOException("unsupported tag number");
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    @Override
    public void encode(ASN1OutputStream object, boolean bl) {
        int n = 64;
        if (this.isConstructed) {
            n = 96;
        }
        ASN1OutputStream aSN1OutputStream = object;
        ASN1ApplicationSpecific aSN1ApplicationSpecific = this;
        int n2 = aSN1ApplicationSpecific.tag;
        object = aSN1ApplicationSpecific.octets;
        aSN1OutputStream.writeEncoded(bl, n, n2, (byte[])object);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1ApplicationSpecific)) {
            return false;
        }
        aSN1Primitive = (ASN1ApplicationSpecific)aSN1Primitive;
        return this.isConstructed == ((ASN1ApplicationSpecific)aSN1Primitive).isConstructed && this.tag == ((ASN1ApplicationSpecific)aSN1Primitive).tag && Arrays.areEqual(this.octets, ((ASN1ApplicationSpecific)aSN1Primitive).octets);
    }

    @Override
    public int hashCode() {
        return this.isConstructed ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("[");
        if (this.isConstructed()) {
            stringBuffer2.append("CONSTRUCTED ");
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer2.append("APPLICATION ");
        stringBuffer3.append(Integer.toString(this.getApplicationTag()));
        stringBuffer3.append("]");
        if (this.octets != null) {
            stringBuffer2.append(" #");
            stringBuffer2.append(Hex.toHexString(this.octets));
        } else {
            stringBuffer2.append(" #null");
        }
        StringBuffer stringBuffer4 = stringBuffer2;
        stringBuffer4.append(" ");
        return stringBuffer4.toString();
    }
}

