/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public abstract class PBEParametersGenerator {
    public byte[] password;
    public byte[] salt;
    public int iterationCount;

    public static byte[] PKCS5PasswordToBytes(char[] cArray) {
        if (cArray != null) {
            int n = cArray.length;
            byte[] byArray = new byte[n];
            for (int k = 0; k != n; ++k) {
                byArray[k] = (byte)cArray[k];
            }
            return byArray;
        }
        return new byte[0];
    }

    public static byte[] PKCS5PasswordToUTF8Bytes(char[] cArray) {
        if (cArray != null) {
            return Strings.toUTF8ByteArray(cArray);
        }
        return new byte[0];
    }

    public static byte[] PKCS12PasswordToBytes(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            byte[] byArray = new byte[(cArray.length + 1) * 2];
            int n = 0;
            while (n != cArray.length) {
                int n2 = n++;
                int n3 = n2 * 2;
                char c2 = cArray[n2];
                byArray[n3] = (byte)(c2 >>> 8);
                byArray[++n3] = (byte)c2;
            }
            return byArray;
        }
        return new byte[0];
    }

    public void init(byte[] byArray, byte[] byArray2, int n) {
        PBEParametersGenerator pBEParametersGenerator = this;
        pBEParametersGenerator.password = byArray;
        pBEParametersGenerator.salt = byArray2;
        pBEParametersGenerator.iterationCount = n;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public abstract CipherParameters generateDerivedParameters(int var1);

    public abstract CipherParameters generateDerivedParameters(int var1, int var2);

    public abstract CipherParameters generateDerivedMacParameters(int var1);
}

