/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ExtendedInvalidKeySpecException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    public KeySpec engineGetKeySpec(Key serializable, Class serializable2) {
        Object object;
        if ((((Class)serializable2).isAssignableFrom(KeySpec.class) || ((Class)serializable2).isAssignableFrom(RSAPublicKeySpec.class)) && serializable instanceof RSAPublicKey) {
            Object object2 = object = (RSAPublicKey)serializable;
            object = object2.getModulus();
            return new RSAPublicKeySpec((BigInteger)object, object2.getPublicExponent());
        }
        if ((((Class)serializable2).isAssignableFrom(KeySpec.class) || ((Class)serializable2).isAssignableFrom(RSAPrivateCrtKeySpec.class)) && serializable instanceof RSAPrivateCrtKey) {
            Object object3 = object = (RSAPrivateCrtKey)serializable;
            object = object3.getModulus();
            serializable = object3.getPublicExponent();
            serializable2 = object3.getPrivateExponent();
            BigInteger bigInteger = object3.getPrimeP();
            BigInteger bigInteger2 = object3.getPrimeQ();
            BigInteger bigInteger3 = object3.getPrimeExponentP();
            BigInteger bigInteger4 = object3.getPrimeExponentQ();
            BigInteger bigInteger5 = object3.getCrtCoefficient();
            return new RSAPrivateCrtKeySpec((BigInteger)object, (BigInteger)serializable, (BigInteger)serializable2, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
        }
        if ((((Class)serializable2).isAssignableFrom(KeySpec.class) || ((Class)serializable2).isAssignableFrom(RSAPrivateKeySpec.class)) && serializable instanceof RSAPrivateKey) {
            Object object4 = object = (RSAPrivateKey)serializable;
            object = object4.getModulus();
            return new RSAPrivateKeySpec((BigInteger)object, object4.getPrivateExponent());
        }
        if (((Class)serializable2).isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec.class) && serializable instanceof RSAPublicKey) {
            com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec;
            com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec2;
            try {
                com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec openSSHPublicKeySpec3;
                openSSHPublicKeySpec2 = openSSHPublicKeySpec3;
                openSSHPublicKeySpec = openSSHPublicKeySpec3;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
            }
            Serializable serializable3 = serializable;
            Serializable serializable4 = serializable3;
            object = ((RSAPublicKey)serializable3).getModulus();
            openSSHPublicKeySpec2(OpenSSHPublicKeyUtil.encodePublicKey(new RSAKeyParameters(false, (BigInteger)object, ((RSAPublicKey)serializable4).getPublicExponent())));
            return openSSHPublicKeySpec;
        }
        if (((Class)serializable2).isAssignableFrom(OpenSSHPrivateKeySpec.class) && serializable instanceof RSAPrivateCrtKey) {
            Serializable serializable5;
            Serializable serializable6;
            Serializable serializable7;
            Serializable serializable8;
            Serializable serializable9;
            Serializable serializable10;
            BigInteger bigInteger;
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters;
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters2;
            OpenSSHPrivateKeySpec openSSHPrivateKeySpec;
            OpenSSHPrivateKeySpec openSSHPrivateKeySpec2;
            try {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters3;
                OpenSSHPrivateKeySpec openSSHPrivateKeySpec3;
                openSSHPrivateKeySpec2 = openSSHPrivateKeySpec3;
                openSSHPrivateKeySpec = openSSHPrivateKeySpec3;
                rSAPrivateCrtKeyParameters2 = rSAPrivateCrtKeyParameters3;
                rSAPrivateCrtKeyParameters = rSAPrivateCrtKeyParameters3;
                bigInteger = ((RSAPrivateCrtKey)serializable).getModulus();
                Serializable serializable11 = serializable;
                serializable10 = serializable11;
                serializable9 = serializable11;
                serializable8 = serializable11;
                serializable7 = serializable11;
                serializable6 = serializable11;
                serializable5 = serializable11;
                object = ((RSAPrivateCrtKey)serializable11).getPublicExponent();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
            }
            serializable = ((RSAPrivateCrtKey)serializable7).getPrivateExponent();
            serializable2 = ((RSAPrivateCrtKey)serializable6).getPrimeP();
            BigInteger bigInteger6 = ((RSAPrivateCrtKey)serializable5).getPrimeQ();
            BigInteger bigInteger7 = ((RSAPrivateCrtKey)serializable9).getPrimeExponentP();
            BigInteger bigInteger8 = ((RSAPrivateCrtKey)serializable8).getPrimeExponentQ();
            BigInteger bigInteger9 = ((RSAPrivateCrtKey)serializable10).getCrtCoefficient();
            rSAPrivateCrtKeyParameters2(bigInteger, (BigInteger)object, (BigInteger)serializable, (BigInteger)serializable2, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
            openSSHPrivateKeySpec2(OpenSSHPrivateKeyUtil.encodePrivateKey(rSAPrivateCrtKeyParameters));
            return openSSHPrivateKeySpec;
        }
        if (((Class)serializable2).isAssignableFrom(OpenSSHPublicKeySpec.class) && serializable instanceof RSAPublicKey) {
            OpenSSHPublicKeySpec openSSHPublicKeySpec;
            OpenSSHPublicKeySpec openSSHPublicKeySpec4;
            try {
                OpenSSHPublicKeySpec openSSHPublicKeySpec5;
                openSSHPublicKeySpec4 = openSSHPublicKeySpec5;
                openSSHPublicKeySpec = openSSHPublicKeySpec5;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
            }
            Serializable serializable12 = serializable;
            Serializable serializable13 = serializable12;
            object = ((RSAPublicKey)serializable12).getModulus();
            openSSHPublicKeySpec4(OpenSSHPublicKeyUtil.encodePublicKey(new RSAKeyParameters(false, (BigInteger)object, ((RSAPublicKey)serializable13).getPublicExponent())));
            return openSSHPublicKeySpec;
        }
        if (((Class)serializable2).isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec.class) && serializable instanceof RSAPrivateCrtKey) {
            Serializable serializable14;
            Serializable serializable15;
            Serializable serializable16;
            Serializable serializable17;
            Serializable serializable18;
            Serializable serializable19;
            BigInteger bigInteger;
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters;
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters4;
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec openSSHPrivateKeySpec;
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec openSSHPrivateKeySpec4;
            try {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters5;
                com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec openSSHPrivateKeySpec5;
                openSSHPrivateKeySpec4 = openSSHPrivateKeySpec5;
                openSSHPrivateKeySpec = openSSHPrivateKeySpec5;
                rSAPrivateCrtKeyParameters4 = rSAPrivateCrtKeyParameters5;
                rSAPrivateCrtKeyParameters = rSAPrivateCrtKeyParameters5;
                bigInteger = ((RSAPrivateCrtKey)serializable).getModulus();
                Serializable serializable20 = serializable;
                serializable19 = serializable20;
                serializable18 = serializable20;
                serializable17 = serializable20;
                serializable16 = serializable20;
                serializable15 = serializable20;
                serializable14 = serializable20;
                object = ((RSAPrivateCrtKey)serializable20).getPublicExponent();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(b.a(iOException, b.b.a("unable to produce encoding: ")));
            }
            serializable = ((RSAPrivateCrtKey)serializable16).getPrivateExponent();
            serializable2 = ((RSAPrivateCrtKey)serializable15).getPrimeP();
            BigInteger bigInteger10 = ((RSAPrivateCrtKey)serializable14).getPrimeQ();
            BigInteger bigInteger11 = ((RSAPrivateCrtKey)serializable18).getPrimeExponentP();
            BigInteger bigInteger12 = ((RSAPrivateCrtKey)serializable17).getPrimeExponentQ();
            BigInteger bigInteger13 = ((RSAPrivateCrtKey)serializable19).getCrtCoefficient();
            rSAPrivateCrtKeyParameters4(bigInteger, (BigInteger)object, (BigInteger)serializable, (BigInteger)serializable2, bigInteger10, bigInteger11, bigInteger12, bigInteger13);
            openSSHPrivateKeySpec4(OpenSSHPrivateKeyUtil.encodePrivateKey(rSAPrivateCrtKeyParameters));
            return openSSHPrivateKeySpec;
        }
        return super.engineGetKeySpec((Key)serializable, (Class)serializable2);
    }

    @Override
    public Key engineTranslateKey(Key key) {
        if (key instanceof RSAPublicKey) {
            return new BCRSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new BCRSAPrivateKey((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return ((KeyFactorySpi)((Object)asymmetricKeyParameter)).generatePrivate(PrivateKeyInfo.getInstance(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                try {
                    return new BCRSAPrivateCrtKey(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey.getInstance(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception2) {
                    throw new ExtendedInvalidKeySpecException(d.a(exception, b.b.a("unable to process key spec: ")), exception);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new BCRSAPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof RSAPrivateCrtKeyParameters) {
                return new BCRSAPrivateCrtKey((RSAPrivateCrtKeyParameters)asymmetricKeyParameter);
            }
            throw new InvalidKeySpecException("open SSH public key is not RSA private key");
        }
        throw new InvalidKeySpecException(b.b.a("unknown KeySpec type: ").append(keySpec.getClass().getName()).toString());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new BCRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey(((com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                return new BCRSAPublicKey((RSAKeyParameters)asymmetricKeyParameter);
            }
            throw new InvalidKeySpecException("Open SSH public key is not RSA public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        Object object = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid((ASN1ObjectIdentifier)object)) {
            object = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
            if (((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey)object).getCoefficient().intValue() == 0) {
                return new BCRSAPrivateKey(privateKeyInfo.getPrivateKeyAlgorithm(), (com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey)object);
            }
            return new BCRSAPrivateCrtKey(privateKeyInfo);
        }
        throw new IOException(a.a("algorithm identifier ", (ASN1ObjectIdentifier)object, " in key not recognised"));
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid(aSN1ObjectIdentifier)) {
            return new BCRSAPublicKey(subjectPublicKeyInfo);
        }
        throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognised"));
    }
}

