/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP256R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"));
    public int[] x;

    public SecP256R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP256R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP256R1FieldElement");
    }

    public SecP256R1FieldElement() {
        this.x = Nat256.create();
    }

    public SecP256R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP256R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.add(secP256R1FieldElement.x, ((SecP256R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.addOne(secP256R1FieldElement.x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.subtract(secP256R1FieldElement.x, ((SecP256R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.multiply(secP256R1FieldElement.x, ((SecP256R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256R1Field.inv(((SecP256R1FieldElement)eCFieldElement).x, nArray);
        SecP256R1Field.multiply(nArray, this.x, nArray);
        return new SecP256R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.negate(secP256R1FieldElement.x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.square(secP256R1FieldElement.x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP256R1FieldElement secP256R1FieldElement = object;
        Object object = Nat256.create();
        SecP256R1Field.inv(secP256R1FieldElement.x, (int[])object);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        Object object = ((SecP256R1FieldElement)this).x;
        if (!Nat256.isZero(((SecP256R1FieldElement)this).x) && !Nat256.isOne(object)) {
            int[] nArray = Nat256.create();
            Object object2 = this = (Object)nArray;
            Object object3 = this;
            int[] nArray2 = Nat256.create();
            Object object4 = this;
            int[] nArray3 = nArray2;
            Object object5 = this;
            SecP256R1Field.square(object, (int[])this);
            SecP256R1Field.multiply((int[])object5, object, (int[])this);
            SecP256R1Field.squareN((int[])object5, 2, nArray2);
            SecP256R1Field.multiply(nArray3, (int[])object5, nArray2);
            SecP256R1Field.squareN(nArray3, 4, (int[])this);
            SecP256R1Field.multiply((int[])object4, nArray2, (int[])this);
            SecP256R1Field.squareN((int[])object4, 8, nArray2);
            SecP256R1Field.multiply(nArray2, (int[])object4, nArray2);
            SecP256R1Field.squareN(nArray2, 16, (int[])this);
            SecP256R1Field.multiply((int[])object3, nArray2, (int[])this);
            SecP256R1Field.squareN((int[])object3, 32, (int[])this);
            SecP256R1Field.multiply((int[])object2, object, (int[])this);
            SecP256R1Field.squareN((int[])object2, 96, (int[])this);
            SecP256R1Field.multiply(nArray, object, (int[])this);
            SecP256R1Field.squareN(nArray, 94, (int[])this);
            SecP256R1Field.square(nArray, nArray2);
            if (Nat256.eq(object, nArray2)) {
                SecP256R1FieldElement secP256R1FieldElement;
                object = secP256R1FieldElement;
                secP256R1FieldElement = new SecP256R1FieldElement((int[])this);
            } else {
                object = null;
            }
            return object;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == secP256R1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP256R1FieldElement)) {
            return false;
        }
        SecP256R1FieldElement secP256R1FieldElement = secP256R1FieldElement2;
        SecP256R1FieldElement secP256R1FieldElement2 = (SecP256R1FieldElement)object;
        return Nat256.eq(secP256R1FieldElement.x, secP256R1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

