/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSSignature;
import java.io.IOException;

public class HSSSigner
implements MessageSigner {
    private HSSPrivateKeyParameters privKey;
    private HSSPublicKeyParameters pubKey;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            this.privKey = (HSSPrivateKeyParameters)cipherParameters;
        } else {
            this.pubKey = (HSSPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        try {
            return HSS.generateSignature(this.privKey, byArray).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to encode signature: ")));
        }
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        HSSPublicKeyParameters hSSPublicKeyParameters;
        try {
            hSSPublicKeyParameters = this.pubKey;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to decode signature: ")));
        }
        return HSS.verifySignature(hSSPublicKeyParameters, HSSSignature.getInstance(byArray2, hSSPublicKeyParameters.getL()), byArray);
    }
}

