/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import java.util.ArrayList;
import java.util.List;

public class XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final WOTSPlusSignature wotsPlusSignature;
    private final List<XMSSNode> authPath;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMSSReducedSignature(Builder object) {
        Object object2 = ((Builder)object).params;
        ((XMSSReducedSignature)((Object)arrayList2)).params = object2;
        if (object2 == null) throw new NullPointerException("params == null");
        XMSSParameters xMSSParameters = object2;
        int n = xMSSParameters.getTreeDigestSize();
        int n2 = xMSSParameters.getWOTSPlus().getParams().getLen();
        int n3 = xMSSParameters.getHeight();
        byte[] byArray = ((Builder)object).reducedSignature;
        if (byArray != null) {
            ArrayList arrayList;
            int n4 = n2 * n;
            if (byArray.length != (n4 = n3 * n + n4)) throw new IllegalArgumentException("signature has wrong size");
            n4 = 0;
            object2 = new byte[n2][];
            for (int k = 0; k < n2; ++k) {
                object2[k] = XMSSUtil.extractBytesAtOffset(byArray, n4, n);
                n4 += n;
            }
            ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = new WOTSPlusSignature(((XMSSReducedSignature)((Object)arrayList2)).params.getWOTSPlus().getParams(), (byte[][])object2);
            object2 = arrayList;
            arrayList = new ArrayList();
            for (n2 = 0; n2 < n3; ++n2) {
                XMSSNode xMSSNode;
                XMSSNode xMSSNode2 = xMSSNode;
                xMSSNode = new XMSSNode(n2, XMSSUtil.extractBytesAtOffset(byArray, n4, n));
                ((ArrayList)object2).add(xMSSNode2);
                n4 += n;
            }
            ((XMSSReducedSignature)((Object)arrayList2)).authPath = object2;
            return;
        } else {
            WOTSPlusSignature wOTSPlusSignature = ((Builder)object).wotsPlusSignature;
            if (wOTSPlusSignature != null) {
                ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = wOTSPlusSignature;
            } else {
                object2 = ((XMSSParameters)object2).getWOTSPlus().getParams();
                ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = new WOTSPlusSignature((WOTSPlusParameters)object2, new byte[n2][n]);
            }
            object = ((Builder)object).authPath;
            if (object != null) {
                if (object.size() != n3) throw new IllegalArgumentException("size of authPath needs to be equal to height of tree");
                ((XMSSReducedSignature)((Object)arrayList2)).authPath = object;
                return;
            } else {
                ArrayList arrayList;
                XMSSReducedSignature xMSSReducedSignature = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                xMSSReducedSignature.authPath = arrayList2;
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        XMSSReducedSignature xMSSReducedSignature = this;
        int n = xMSSReducedSignature.params.getTreeDigestSize();
        int n2 = xMSSReducedSignature.params.getWOTSPlus().getParams().getLen() * n;
        byte[] byArray = new byte[xMSSReducedSignature.params.getHeight() * n + n2];
        int n3 = 0;
        byte[][] byArray2 = xMSSReducedSignature.wotsPlusSignature.toByteArray();
        for (int k = 0; k < byArray2.length; ++k) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[k], n3);
            n3 += n;
        }
        for (int k = 0; k < this.authPath.size(); ++k) {
            XMSSUtil.copyBytesAtOffset(byArray, this.authPath.get(k).getValue(), n3);
            n3 += n;
        }
        return byArray;
    }

    public XMSSParameters getParams() {
        return this.params;
    }

    public WOTSPlusSignature getWOTSPlusSignature() {
        return this.wotsPlusSignature;
    }

    public List<XMSSNode> getAuthPath() {
        return this.authPath;
    }

    public static class Builder {
        private final XMSSParameters params;
        private WOTSPlusSignature wotsPlusSignature = null;
        private List<XMSSNode> authPath = null;
        private byte[] reducedSignature = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public Builder withWOTSPlusSignature(WOTSPlusSignature wOTSPlusSignature) {
            this.wotsPlusSignature = wOTSPlusSignature;
            return this;
        }

        public Builder withAuthPath(List<XMSSNode> list) {
            this.authPath = list;
            return this;
        }

        public Builder withReducedSignature(byte[] byArray) {
            this.reducedSignature = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSReducedSignature build() {
            return new XMSSReducedSignature(this);
        }
    }
}

