/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.XMSSParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSKeyGenerationParameters param;
    private ASN1ObjectIdentifier treeDigest;
    private XMSSKeyPairGenerator engine = new XMSSKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public XMSSKeyPairGeneratorSpi() {
        super("XMSS");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec instanceof XMSSParameterSpec) {
            if (((XMSSParameterSpec)(algorithmParameterSpec = (XMSSParameterSpec)algorithmParameterSpec)).getTreeDigest().equals("SHA256")) {
                XMSSKeyPairGeneratorSpi xMSSKeyPairGeneratorSpi = this;
                xMSSKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha256;
                xMSSKeyPairGeneratorSpi.param = new XMSSKeyGenerationParameters(new XMSSParameters(((XMSSParameterSpec)algorithmParameterSpec).getHeight(), new SHA256Digest()), secureRandom);
            } else if (((XMSSParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHA512")) {
                XMSSKeyPairGeneratorSpi xMSSKeyPairGeneratorSpi = this;
                xMSSKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha512;
                xMSSKeyPairGeneratorSpi.param = new XMSSKeyGenerationParameters(new XMSSParameters(((XMSSParameterSpec)algorithmParameterSpec).getHeight(), new SHA512Digest()), secureRandom);
            } else if (((XMSSParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHAKE128")) {
                XMSSKeyPairGeneratorSpi xMSSKeyPairGeneratorSpi = this;
                xMSSKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_shake128;
                xMSSKeyPairGeneratorSpi.param = new XMSSKeyGenerationParameters(new XMSSParameters(((XMSSParameterSpec)algorithmParameterSpec).getHeight(), new SHAKEDigest(128)), secureRandom);
            } else if (((XMSSParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHAKE256")) {
                XMSSKeyPairGeneratorSpi xMSSKeyPairGeneratorSpi = this;
                xMSSKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_shake256;
                xMSSKeyPairGeneratorSpi.param = new XMSSKeyGenerationParameters(new XMSSParameters(((XMSSParameterSpec)algorithmParameterSpec).getHeight(), new SHAKEDigest(256)), secureRandom);
            }
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a XMSSParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCXMSSPrivateKey bCXMSSPrivateKey;
        Object object;
        Object object2;
        if (!this.initialised) {
            SHA512Digest sHA512Digest;
            XMSSParameters xMSSParameters;
            XMSSKeyGenerationParameters xMSSKeyGenerationParameters;
            object2 = xMSSKeyGenerationParameters;
            object = xMSSParameters;
            SHA512Digest sHA512Digest2 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            xMSSParameters = new XMSSParameters(10, sHA512Digest2);
            this.param = new XMSSKeyGenerationParameters((XMSSParameters)object, this.random);
            this.engine.init((KeyGenerationParameters)object2);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        object2 = (XMSSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = (XMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCXMSSPublicKey bCXMSSPublicKey = new BCXMSSPublicKey(this.treeDigest, (XMSSPublicKeyParameters)object2);
        object2 = bCXMSSPrivateKey;
        bCXMSSPrivateKey = new BCXMSSPrivateKey(this.treeDigest, (XMSSPrivateKeyParameters)object);
        return new KeyPair(bCXMSSPublicKey, (PrivateKey)object2);
    }
}

