/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.LongPolynomial5;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DenseTernaryPolynomial
extends IntegerPolynomial
implements TernaryPolynomial {
    public DenseTernaryPolynomial(int n) {
        DenseTernaryPolynomial denseTernaryPolynomial = this;
        super(n);
        denseTernaryPolynomial.checkTernarity();
    }

    public DenseTernaryPolynomial(IntegerPolynomial integerPolynomial) {
        this(integerPolynomial.coeffs);
    }

    public DenseTernaryPolynomial(int[] nArray) {
        DenseTernaryPolynomial denseTernaryPolynomial = this;
        super(nArray);
        denseTernaryPolynomial.checkTernarity();
    }

    private void checkTernarity() {
        block1: {
            int n;
            int n2 = 0;
            while (true) {
                int[] nArray = this.coeffs;
                if (n2 == this.coeffs.length) break block1;
                n = nArray[n2];
                if (n < -1 || n > 1) break;
                ++n2;
            }
            throw new IllegalStateException(f.a("Illegal value: ", n, ", must be one of {-1, 0, 1}"));
        }
    }

    public static DenseTernaryPolynomial generateRandom(int n, int n2, int n3, SecureRandom secureRandom) {
        int[] nArray = Util.generateRandomTernary(n, n2, n3, secureRandom);
        return new DenseTernaryPolynomial(nArray);
    }

    public static DenseTernaryPolynomial generateRandom(int n, SecureRandom secureRandom) {
        DenseTernaryPolynomial denseTernaryPolynomial;
        DenseTernaryPolynomial denseTernaryPolynomial2 = denseTernaryPolynomial;
        denseTernaryPolynomial = new DenseTernaryPolynomial(n);
        for (int k = 0; k < n; ++k) {
            denseTernaryPolynomial2.coeffs[k] = secureRandom.nextInt(3) - 1;
        }
        return denseTernaryPolynomial2;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n) {
        if (n == 2048) {
            integerPolynomial = (IntegerPolynomial)integerPolynomial.clone();
            integerPolynomial.modPositive(2048);
            return new LongPolynomial5(integerPolynomial).mult(this).toIntegerPolynomial();
        }
        return super.mult(integerPolynomial, n);
    }

    @Override
    public int[] getOnes() {
        int n = this.coeffs.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int k = 0; k < n; ++k) {
            if (this.coeffs[k] != 1) continue;
            int n3 = n2 + 1;
            nArray[n2] = k;
            n2 = n3;
        }
        return Arrays.copyOf(nArray, n2);
    }

    @Override
    public int[] getNegOnes() {
        int n = this.coeffs.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int k = 0; k < n; ++k) {
            if (this.coeffs[k] != -1) continue;
            int n3 = n2 + 1;
            nArray[n2] = k;
            n2 = n3;
        }
        return Arrays.copyOf(nArray, n2);
    }

    @Override
    public int size() {
        return this.coeffs.length;
    }
}

