/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.CVCertificate;
import com.fis.ekyc.nfc.build_in.cvc.CardVerifiableCertificate;
import com.fis.ekyc.nfc.build_in.cvc.CertificateParser;
import com.fis.ekyc.nfc.build_in.cvc.exception.ConstructionException;
import com.fis.ekyc.nfc.build_in.cvc.exception.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Collection;

public class JDKCVCertificateFactory
extends CertificateFactorySpi {
    private byte[] readBytes(InputStream inputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream2.write(byArray, 0, n);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        inputStream.close();
        byteArrayOutputStream3.close();
        return byteArrayOutputStream3.toByteArray();
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) {
        CVCertificate cVCertificate = CertificateParser.parseCertificate(((JDKCVCertificateFactory)((Object)cVCertificate)).readBytes(inputStream));
        try {
            return new CardVerifiableCertificate(cVCertificate);
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException(((Object)constructionException).toString());
        }
        catch (ParseException parseException) {
            throw new CertificateException(((Object)parseException).toString());
        }
        catch (IOException iOException) {
            throw new CertificateException(((Object)iOException).toString());
        }
    }

    public Collection<Certificate> engineGenerateCertificates(InputStream inputStream) {
        Certificate certificate = ((JDKCVCertificateFactory)((Object)certificate)).engineGenerateCertificate(inputStream);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(certificate);
        return arrayList;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }

    public Collection<CRL> engineGenerateCRLs(InputStream inputStream) {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }
}

