/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.cvc.AbstractDataField;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;

public abstract class ReferenceField
extends AbstractDataField {
    private static final long serialVersionUID = 1L;
    private String country = null;
    private String mnemonic = null;
    private String sequence = null;

    public ReferenceField(CVCTagEnum cVCTagEnum, String string, String string2, String string3) {
        super(cVCTagEnum);
        if (string.length() == 2) {
            if (this.isValidCountry(string)) {
                if (string2.length() != 0) {
                    if (string2.length() <= 9) {
                        if (string3.length() == 5) {
                            for (int k = 0; k < string3.length(); ++k) {
                                if (Character.isLetterOrDigit(string3.charAt(k))) {
                                    continue;
                                }
                                throw new IllegalArgumentException(i.a("Sequence number can only contain alphanumerics: ", string3));
                            }
                            ReferenceField referenceField = this;
                            referenceField.country = string;
                            referenceField.mnemonic = string2;
                            referenceField.sequence = string3;
                            return;
                        }
                        throw new IllegalArgumentException(b.a("Sequence number must have length 5, was ").append(string3.length()).toString());
                    }
                    throw new IllegalArgumentException(b.a("Holder mnemonic too long, max=9, was ").append(string2.length()).toString());
                }
                throw new IllegalArgumentException("Holder mnemonic too short, must have at least one character");
            }
            throw new IllegalArgumentException(i.a("Unknown country code: ", string));
        }
        throw new IllegalArgumentException(b.a("Country code length must be 2, was ").append(string.length()).toString());
    }

    public ReferenceField(CVCTagEnum object, byte[] byArray) {
        super((CVCTagEnum)((Object)object));
        String string;
        Object object2 = object = string;
        Object object3 = object;
        super(byArray);
        this.country = ((String)object3).substring(0, 2);
        this.mnemonic = ((String)object2).substring(2, ((String)object2).length() - 5);
        this.sequence = string.substring(string.length() - 5);
    }

    private boolean okChar(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    private boolean isValidCountry(String string) {
        return this.okChar(string.charAt(0)) && this.okChar(string.charAt(1));
    }

    public String getConcatenated() {
        return this.country + this.mnemonic + this.sequence;
    }

    public String getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSequence() {
        return this.sequence;
    }

    @Override
    public byte[] getEncoded() {
        return this.getConcatenated().getBytes();
    }

    @Override
    public String valueAsText() {
        return this.country + "/" + this.mnemonic + "/" + this.sequence;
    }
}

