/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.os.SystemClock;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;
import vn.kalapa.ekyc.capturesdk.tflite.CardDetectStatus;
import vn.kalapa.ekyc.capturesdk.tflite.DetectorConfig;
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener;

final class CaptureStateTracker {
    @NotNull
    private final DetectorConfig config;
    private long startTime;
    @Nullable
    private BoundingBox previousBox;
    private boolean detectedOnce;

    public CaptureStateTracker(@NotNull DetectorConfig detectorConfig) {
        Intrinsics.checkNotNullParameter((Object)detectorConfig, (String)"config");
        this.config = detectorConfig;
    }

    private final float distance(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox2;
        float f2 = boundingBox3.getX1();
        float f3 = boundingBox3.getX2() + f2;
        f2 = 2;
        BoundingBox boundingBox4 = boundingBox;
        float f4 = boundingBox4.getX1();
        f4 = f3 / f2 - (boundingBox4.getX2() + f4) / f2;
        float f5 = boundingBox3.getY1();
        BoundingBox boundingBox5 = boundingBox;
        float f6 = boundingBox5.getY1();
        float f7 = (boundingBox3.getY2() + f5) / f2 - (boundingBox5.getY2() + f6) / f2;
        float f8 = f4;
        f2 = f8 * f8;
        return (float)Math.sqrt(f7 * f7 + f2);
    }

    public final void reset() {
        CaptureStateTracker captureStateTracker = this;
        captureStateTracker.startTime = 0L;
        captureStateTracker.previousBox = null;
    }

    public final void handle(@NotNull BoundingBox boundingBox, boolean bl, @NotNull OnImageDetectedListener onImageDetectedListener) {
        OnImageDetectedListener onImageDetectedListener2 = onImageDetectedListener;
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"corner");
        Intrinsics.checkNotNullParameter((Object)onImageDetectedListener2, (String)"listener");
        onImageDetectedListener2.onImageProcessing(CardDetectStatus.IN_MASK);
        long l = SystemClock.uptimeMillis();
        long l2 = this.startTime;
        if (l2 == 0L) {
            CaptureStateTracker captureStateTracker = this;
            captureStateTracker.startTime = l;
            captureStateTracker.previousBox = boundingBox;
        } else {
            l -= l2;
            BoundingBox boundingBox2 = this.previousBox;
            if (boundingBox2 == null) {
                boundingBox2 = boundingBox;
            }
            if (this.distance(boundingBox2, boundingBox) > this.config.getMovementThreshold()) {
                onImageDetectedListener.onImageProcessing(CardDetectStatus.UNSTABLE);
                this.reset();
            } else if (l >= this.config.getStableDurationMs() && bl && !this.detectedOnce) {
                onImageDetectedListener.onImageDetected();
                this.detectedOnce = true;
            }
            this.previousBox = boundingBox;
        }
    }
}

