/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.managers.KLPLanguageManager;

public final class QRScannerOverlayView
extends View {
    @NotNull
    private final Paint framePaint;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final Paint overlayPaint;
    private final float cornerLength;
    @NotNull
    private final RectF frameRect;
    private final float scannerFrameSize;
    @NotNull
    private final BlurMaskFilter blurMaskFilter;

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        BlurMaskFilter blurMaskFilter;
        Paint paint;
        QRScannerOverlayView qRScannerOverlayView = qRScannerOverlayView2;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Paint paint2 = new Paint();
        paint2.setColor(-1);
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(qRScannerOverlayView2.dpToPx(4.0f));
        qRScannerOverlayView.framePaint = paint2;
        Paint paint3 = new Paint();
        paint3.setColor(-1);
        paint3.setTextSize(qRScannerOverlayView2.dpToPx(16.0f));
        paint3.setAntiAlias(true);
        qRScannerOverlayView.textPaint = paint3;
        Context context3 = context = paint;
        super();
        context3.setColor(Color.parseColor((String)"#BF000000"));
        qRScannerOverlayView2.overlayPaint = context3;
        qRScannerOverlayView2.cornerLength = qRScannerOverlayView2.dpToPx(25.0f);
        qRScannerOverlayView2.frameRect = new RectF();
        qRScannerOverlayView2.scannerFrameSize = 250.0f;
        QRScannerOverlayView qRScannerOverlayView2 = blurMaskFilter;
        v7.blurMaskFilter = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
        paint.setMaskFilter((MaskFilter)qRScannerOverlayView2);
        qRScannerOverlayView.setLayerType(2, null);
    }

    public /* synthetic */ QRScannerOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final float dpToPx(float f2) {
        return f2 * this.getContext().getResources().getDisplayMetrics().density;
    }

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public QRScannerOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(@NotNull Canvas canvas) {
        TextPaint textPaint;
        TextPaint textPaint2;
        Path path;
        Path path2;
        Path path3;
        Path path4;
        float f2;
        Canvas canvas2 = canvas;
        QRScannerOverlayView qRScannerOverlayView = qRScannerOverlayView5;
        QRScannerOverlayView qRScannerOverlayView2 = qRScannerOverlayView5;
        QRScannerOverlayView qRScannerOverlayView3 = qRScannerOverlayView5;
        Canvas canvas3 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas3, (String)"canvas");
        super.onDraw(canvas3);
        float f3 = qRScannerOverlayView3.getWidth();
        float f4 = qRScannerOverlayView3.getHeight();
        Paint paint = qRScannerOverlayView3.overlayPaint;
        canvas.drawRect(0.0f, 0.0f, f3, f4, paint);
        f3 = qRScannerOverlayView2.dpToPx(qRScannerOverlayView2.scannerFrameSize);
        f4 = qRScannerOverlayView2.dpToPx(qRScannerOverlayView2.scannerFrameSize);
        float f5 = ((float)qRScannerOverlayView2.getWidth() - f3) / 2.0f;
        float f6 = f2 = ((float)qRScannerOverlayView2.getHeight() - f4) / 2.0f;
        f3 = f5 + f3;
        qRScannerOverlayView2.frameRect.set(f5, f6, f3, f6 + f4);
        RectF rectF = qRScannerOverlayView2.frameRect;
        Paint paint2 = new Paint();
        paint2.setStyle(Paint.Style.FILL);
        paint2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        canvas.drawRect(rectF, paint2);
        Path path5 = path4;
        path5();
        RectF rectF2 = qRScannerOverlayView5.frameRect;
        path5.moveTo(rectF2.left, rectF2.top + qRScannerOverlayView5.cornerLength);
        RectF rectF3 = qRScannerOverlayView5.frameRect;
        float f7 = rectF3.left;
        path5.lineTo(f7, rectF3.top);
        RectF rectF4 = qRScannerOverlayView5.frameRect;
        f7 = rectF4.left + qRScannerOverlayView5.cornerLength;
        path4.lineTo(f7, rectF4.top);
        canvas.drawPath(path5, qRScannerOverlayView5.framePaint);
        path5 = path3;
        path5();
        RectF rectF5 = qRScannerOverlayView5.frameRect;
        f7 = rectF5.right - qRScannerOverlayView5.cornerLength;
        path5.moveTo(f7, rectF5.top);
        RectF rectF6 = qRScannerOverlayView5.frameRect;
        f7 = rectF6.right;
        path5.lineTo(f7, rectF6.top);
        RectF rectF7 = qRScannerOverlayView5.frameRect;
        path3.lineTo(rectF7.right, rectF7.top + qRScannerOverlayView5.cornerLength);
        canvas.drawPath(path5, qRScannerOverlayView5.framePaint);
        path5 = path2;
        path5();
        rectF7 = qRScannerOverlayView5.frameRect;
        path5.moveTo(rectF7.left, rectF7.bottom - qRScannerOverlayView5.cornerLength);
        RectF rectF8 = qRScannerOverlayView5.frameRect;
        float f8 = rectF8.left;
        path5.lineTo(f8, rectF8.bottom);
        RectF rectF9 = qRScannerOverlayView5.frameRect;
        f8 = rectF9.left + qRScannerOverlayView5.cornerLength;
        path2.lineTo(f8, rectF9.bottom);
        canvas.drawPath(path5, qRScannerOverlayView5.framePaint);
        path5 = path;
        path5();
        RectF rectF10 = qRScannerOverlayView5.frameRect;
        f8 = rectF10.right - qRScannerOverlayView5.cornerLength;
        path5.moveTo(f8, rectF10.bottom);
        RectF rectF11 = qRScannerOverlayView5.frameRect;
        f8 = rectF11.right;
        path5.lineTo(f8, rectF11.bottom);
        RectF rectF12 = qRScannerOverlayView5.frameRect;
        path.lineTo(rectF12.right, rectF12.bottom - qRScannerOverlayView5.cornerLength);
        canvas.drawPath(path5, qRScannerOverlayView5.framePaint);
        float f9 = qRScannerOverlayView.dpToPx(16.0f);
        rectF12 = textPaint2;
        textPaint2 = new TextPaint(qRScannerOverlayView5.textPaint);
        int n = (int)((float)qRScannerOverlayView.getWidth() - (float)2 * f9);
        rectF12 = StaticLayout.Builder.obtain((CharSequence)"", (int)0, (int)0, (TextPaint)rectF12, (int)n).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(0.0f, 1.0f).setIncludePad(false).build();
        Canvas canvas4 = canvas;
        QRScannerOverlayView qRScannerOverlayView4 = qRScannerOverlayView5;
        Intrinsics.checkNotNullExpressionValue((Object)rectF12, (String)"obtain(\n            text\u2026lse)\n            .build()");
        f2 = qRScannerOverlayView4.frameRect.bottom + qRScannerOverlayView5.dpToPx(16.0f);
        float f10 = qRScannerOverlayView4.frameRect.top - (float)rectF12.getHeight() - qRScannerOverlayView5.dpToPx(16.0f);
        canvas.save();
        canvas4.translate(f9, f2);
        rectF12.draw(canvas4);
        canvas2.restore();
        String string2 = qRScannerOverlayView5.getContext().getString(R.string.klp_tap_to_focus);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.klp_tap_to_focus)");
        String string3 = KLPLanguageManager.INSTANCE.get(string2);
        TextPaint textPaint3 = textPaint;
        textPaint = new TextPaint(qRScannerOverlayView5.textPaint);
        QRScannerOverlayView qRScannerOverlayView5 = StaticLayout.Builder.obtain((CharSequence)string3, (int)0, (int)string3.length(), (TextPaint)textPaint3, (int)n).setAlignment(Layout.Alignment.ALIGN_CENTER).setLineSpacing(0.0f, 1.0f).setIncludePad(false).build();
        Canvas canvas5 = canvas;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qRScannerOverlayView5), (String)"obtain(\n            abov\u2026lse)\n            .build()");
        canvas.save();
        canvas5.translate(f9, f10);
        qRScannerOverlayView5.draw(canvas5);
        canvas2.restore();
    }
}

