/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nvn/kalapa/ekyc/utils/ExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,150:1\n13644#2,3:151\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nvn/kalapa/ekyc/utils/ExtensionsKt\n*L\n39#1:151,3\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final Bitmap toBitmap(@NotNull ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"<this>");
        byte[] byArray = ExtensionsKt.yuv420888ToNv21(imageProxy2);
        ImageProxy imageProxy3 = imageProxy;
        int n = imageProxy3.getWidth();
        int n2 = imageProxy3.getHeight();
        return ExtensionsKt.toBitmap(new YuvImage(byArray, 17, n, n2, null));
    }

    private static final Bitmap toBitmap(YuvImage yuvImage) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        int n2 = yuvImage2.getWidth();
        if (!yuvImage.compressToJpeg(new Rect(0, 0, n2, n = yuvImage2.getHeight()), 100, (OutputStream)byteArrayOutputStream2)) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    private static final byte[] yuv420888ToNv21(ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        int n = imageProxy2.getCropRect().width();
        n = imageProxy2.getCropRect().height() * n;
        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)35) * n / 8];
        ExtensionsKt.imageToByteBuffer(imageProxy, byArray, n);
        return byArray;
    }

    private static final void imageToByteBuffer(ImageProxy imageProxy, byte[] byArray, int n) {
        boolean bl = imageProxy.getFormat() == 35;
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        ImageProxy imageProxy2 = imageProxy;
        imageProxy = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)imageProxy, (String)"image.cropRect");
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        int n2 = 0;
        for (ImageProxy.PlaneProxy planeProxy : planeProxyArray) {
            int n3;
            block9: {
                int n4;
                int n5;
                ImageProxy imageProxy3;
                int n6;
                int n7;
                block10: {
                    block7: {
                        block8: {
                            n3 = n2 + 1;
                            if (n2 == 0) break block7;
                            if (n2 == 1) break block8;
                            if (n2 != 2) break block9;
                            n7 = 2;
                            n6 = n;
                            break block10;
                        }
                        n7 = 2;
                        n6 = n + 1;
                        break block10;
                    }
                    n7 = 1;
                    n6 = 0;
                }
                ImageProxy.PlaneProxy planeProxy2 = planeProxy;
                ByteBuffer byteBuffer = planeProxy2.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"plane.buffer");
                int n8 = planeProxy2.getRowStride();
                int n9 = planeProxy2.getPixelStride();
                if (n2 == 0) {
                    imageProxy3 = imageProxy;
                } else {
                    Rect rect;
                    imageProxy3 = rect;
                    ImageProxy imageProxy4 = imageProxy;
                    n5 = imageProxy4.top / 2;
                    int n10 = imageProxy4.right / 2;
                    n4 = imageProxy4.bottom / 2;
                    rect = new Rect(imageProxy.left / 2, n5, n10, n4);
                }
                ImageProxy imageProxy5 = imageProxy3;
                int n11 = imageProxy5.width();
                n5 = imageProxy5.height();
                byte[] byArray2 = new byte[planeProxy.getRowStride()];
                n4 = n9 == 1 && n7 == 1 ? n11 : (n11 - 1) * n9 + 1;
                for (int k = 0; k < n5; ++k) {
                    int n12 = (k + imageProxy3.top) * n8;
                    byteBuffer.position(imageProxy3.left * n9 + n12);
                    if (n9 == 1 && n7 == 1) {
                        byteBuffer.get(byArray, n6, n4);
                        n6 += n4;
                        continue;
                    }
                    byteBuffer.get(byArray2, 0, n4);
                    for (n12 = 0; n12 < n11; ++n12) {
                        byArray[n6] = byArray2[n12 * n9];
                        n6 += n7;
                    }
                }
            }
            n2 = n3;
        }
    }
}

