package vn.kalapa.ekyc.managers

import android.app.Activity
import kotlinx.coroutines.awaitAll
import vn.kalapa.ekyc.KalapaSDK
import vn.kalapa.ekyc.handlers.GetCardModelHandler
import vn.kalapa.ekyc.utils.Helpers
import java.io.File
import java.lang.ref.WeakReference

object KLPCardModelManager {
    private var modelFile: File? = null
    suspend fun pullOrGetModel(activity: Activity, baseURL: String, version: String?) { // Call once when build config
        // Get cached file if can. Otherwise, pull new model
        // Pull new model, if saved it successful, saved to shared preferences
        val cachedFile = KLPCDNManager.loadModelFromCache(activity, version)
        if (cachedFile != null) {
            modelFile = cachedFile
            Helpers.printLog("KLPCardModelManager Loaded CardModel from cached successfully")
        } else {
            val startTime = System.currentTimeMillis()
            GetCardModelHandler().execute(baseURL, version).get()?.let {
                Helpers.printLog("KLPCardModelManager Get CardModel from cloud successfully, after ${System.currentTimeMillis() - startTime}")
                // Save to file
                KLPCDNManager.saveModelIntoFile(activity, version, it)
                modelFile = KLPCDNManager.loadModelFromCache(activity, version)
                Helpers.printLog("KLPCardModelManager Save CardModel to cache successfully, after ${System.currentTimeMillis() - startTime}")
            }
        }
    }

    fun getModel(): File? { // Call when detector needs it
        Helpers.printLog("KLPCardModelManager getModel ${modelFile?.exists()}")
        return modelFile
    }

}
