/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DHAgreement {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;
    private BigInteger privateValue;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = (ParametersWithRandom)cipherParameters;
            ((DHAgreement)((Object)dHPrivateKeyParameters)).random = ((ParametersWithRandom)cipherParameters).getRandom();
            cipherParameters = (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters();
        } else {
            ((DHAgreement)((Object)dHPrivateKeyParameters)).random = CryptoServicesRegistrar.getSecureRandom();
            cipherParameters = (AsymmetricKeyParameter)cipherParameters;
        }
        if (cipherParameters instanceof DHPrivateKeyParameters) {
            DHAgreement dHAgreement = dHPrivateKeyParameters;
            DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)cipherParameters;
            dHAgreement.key = dHPrivateKeyParameters;
            dHAgreement.dhParams = dHPrivateKeyParameters.getParameters();
            return;
        }
        throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
    }

    public BigInteger calculateMessage() {
        DHAgreement dHAgreement = object;
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        DHAgreement dHAgreement2 = object;
        Object object = dHAgreement2.random;
        dHKeyPairGenerator.init(new DHKeyGenerationParameters((SecureRandom)object, dHAgreement2.dhParams));
        object = dHKeyPairGenerator.generateKeyPair();
        dHAgreement.privateValue = ((DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate()).getX();
        return ((DHPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic()).getY();
    }

    public BigInteger calculateAgreement(DHPublicKeyParameters object, BigInteger bigInteger) {
        if (((DHKeyParameters)object).getParameters().equals(this.dhParams)) {
            BigInteger bigInteger2;
            DHPublicKeyParameters dHPublicKeyParameters = object;
            object = this.dhParams.getP();
            BigInteger bigInteger3 = dHPublicKeyParameters.getY();
            if (bigInteger3 != null && bigInteger3.compareTo(bigInteger2 = ONE) > 0 && bigInteger3.compareTo(((BigInteger)object).subtract(bigInteger2)) < 0) {
                if (!(bigInteger3 = bigInteger3.modPow(this.privateValue, (BigInteger)object)).equals(bigInteger2)) {
                    return bigInteger.modPow(this.key.getX(), (BigInteger)object).multiply(bigInteger3).mod((BigInteger)object);
                }
                throw new IllegalStateException("Shared key can't be 1");
            }
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
    }
}

