/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.RawAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.XDHUPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement xAgreement;
    private XDHUPrivateParameters privParams;

    public XDHUnifiedAgreement(RawAgreement rawAgreement) {
        this.xAgreement = rawAgreement;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privParams = (XDHUPrivateParameters)cipherParameters;
    }

    @Override
    public int getAgreementSize() {
        return this.xAgreement.getAgreementSize() * 2;
    }

    @Override
    public void calculateAgreement(CipherParameters cipherParameters, byte[] byArray, int n) {
        XDHUnifiedAgreement xDHUnifiedAgreement = this;
        cipherParameters = (XDHUPublicParameters)cipherParameters;
        xDHUnifiedAgreement.xAgreement.init(this.privParams.getEphemeralPrivateKey());
        xDHUnifiedAgreement.xAgreement.calculateAgreement(((XDHUPublicParameters)cipherParameters).getEphemeralPublicKey(), byArray, n);
        xDHUnifiedAgreement.xAgreement.init(this.privParams.getStaticPrivateKey());
        xDHUnifiedAgreement.xAgreement.calculateAgreement(((XDHUPublicParameters)cipherParameters).getStaticPublicKey(), byArray, this.xAgreement.getAgreementSize() + n);
    }
}

