/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class NullEngine
implements BlockCipher {
    public static final int DEFAULT_BLOCK_SIZE = 1;
    private boolean initialised;
    private final int blockSize;

    public NullEngine() {
        this(1);
    }

    public NullEngine(int n) {
        this.blockSize = n;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.initialised = true;
    }

    @Override
    public String getAlgorithmName() {
        return "Null";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.initialised) {
            int n3 = this.blockSize;
            if (n + n3 <= byArray.length) {
                if (n2 + n3 <= byArray2.length) {
                    int n4;
                    for (n3 = 0; n3 < (n4 = this.blockSize); ++n3) {
                        n4 = n2 + n3;
                        byArray2[n4] = byArray[n + n3];
                    }
                    return n4;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Null engine not initialised");
    }

    @Override
    public void reset() {
    }
}

