/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DSTU7624Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class DSTU7624Mac
implements Mac {
    private static final int BITS_IN_BYTE = 8;
    private byte[] buf;
    private int bufOff;
    private int macSize;
    private int blockSize;
    private DSTU7624Engine engine;
    private byte[] c;
    private byte[] cTemp;
    private byte[] kDelta;
    private boolean initCalled;

    public DSTU7624Mac(int n, int n2) {
        int n3;
        DSTU7624Mac dSTU7624Mac = this;
        this.initCalled = false;
        this.engine = new DSTU7624Engine(n);
        this.blockSize = n3 = n / 8;
        dSTU7624Mac.macSize = n2 / 8;
        dSTU7624Mac.c = new byte[n3];
        dSTU7624Mac.kDelta = new byte[n3];
        dSTU7624Mac.cTemp = new byte[n3];
        dSTU7624Mac.buf = new byte[n3];
    }

    private void processBlock(byte[] byArray, int n) {
        DSTU7624Mac dSTU7624Mac = object;
        byte[] byArray2 = dSTU7624Mac.c;
        byte[] byArray3 = dSTU7624Mac.cTemp;
        dSTU7624Mac.xor(byArray2, 0, byArray, n, byArray3);
        DSTU7624Mac dSTU7624Mac2 = object;
        Object object = dSTU7624Mac2.cTemp;
        byArray = dSTU7624Mac2.c;
        dSTU7624Mac.engine.processBlock((byte[])object, 0, byArray, 0);
    }

    private void xor(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3) {
        int n3 = this.blockSize;
        if (byArray.length - n >= n3 && byArray2.length - n2 >= n3 && byArray3.length >= n3) {
            for (n3 = 0; n3 < this.blockSize; ++n3) {
                byArray3[n3] = (byte)(byArray[n3 + n] ^ byArray2[n3 + n2]);
            }
            return;
        }
        throw new IllegalArgumentException("some of input buffers too short");
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            DSTU7624Mac dSTU7624Mac = this;
            dSTU7624Mac.engine.init(true, cipherParameters);
            dSTU7624Mac.initCalled = true;
            dSTU7624Mac.reset();
            return;
        }
        throw new IllegalArgumentException("Invalid parameter passed to DSTU7624Mac");
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624Mac";
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.processBlock(byArray, 0);
            this.bufOff = 0;
        }
        int n = this.bufOff;
        this.bufOff = n + 1;
        this.buf[n] = by;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n2 >= 0) {
            int n3;
            int n4 = ((DSTU7624Mac)object).engine.getBlockSize();
            int n5 = n4 - (n3 = ((DSTU7624Mac)object).bufOff);
            if (n2 > n5) {
                int n6 = n;
                DSTU7624Mac dSTU7624Mac = object;
                System.arraycopy(byArray, n, ((DSTU7624Mac)object).buf, n3, n5);
                dSTU7624Mac.processBlock(dSTU7624Mac.buf, 0);
                dSTU7624Mac.bufOff = 0;
                n = n2 - n5;
                n2 = n6 + n5;
                int n7 = n;
                n = n2;
                n2 = n7;
                while (n2 > n4) {
                    int n8 = n;
                    super.processBlock(byArray, n);
                    n = n2 - n4;
                    n2 = n8 + n4;
                    int n9 = n;
                    n = n2;
                    n2 = n9;
                }
            }
            DSTU7624Mac dSTU7624Mac = object;
            DSTU7624Mac dSTU7624Mac2 = object;
            Object object = dSTU7624Mac2.buf;
            System.arraycopy(byArray, n, object, dSTU7624Mac2.bufOff, n2);
            dSTU7624Mac.bufOff += n2;
            return;
        }
        throw new IllegalArgumentException("can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = this.buf;
        if (this.bufOff % this.buf.length == 0) {
            DSTU7624Mac dSTU7624Mac = this;
            byte[] byArray3 = dSTU7624Mac.c;
            byte[] byArray4 = dSTU7624Mac.cTemp;
            dSTU7624Mac.xor(byArray3, 0, byArray2, 0, byArray4);
            byArray2 = dSTU7624Mac.cTemp;
            byArray3 = dSTU7624Mac.kDelta;
            byArray4 = dSTU7624Mac.c;
            dSTU7624Mac.xor(byArray2, 0, byArray3, 0, byArray4);
            dSTU7624Mac.engine.processBlock(this.c, 0, this.c, 0);
            int n2 = dSTU7624Mac.macSize;
            if (n2 + n <= byArray.length) {
                DSTU7624Mac dSTU7624Mac2 = this;
                System.arraycopy(dSTU7624Mac2.c, 0, byArray, n, n2);
                dSTU7624Mac2.reset();
                return dSTU7624Mac2.macSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input must be a multiple of blocksize");
    }

    @Override
    public void reset() {
        DSTU7624Mac dSTU7624Mac = this;
        Arrays.fill(dSTU7624Mac.c, (byte)0);
        Arrays.fill(dSTU7624Mac.cTemp, (byte)0);
        Arrays.fill(dSTU7624Mac.kDelta, (byte)0);
        Arrays.fill(dSTU7624Mac.buf, (byte)0);
        dSTU7624Mac.engine.reset();
        if (dSTU7624Mac.initCalled) {
            this.engine.processBlock(this.kDelta, 0, this.kDelta, 0);
        }
        this.bufOff = 0;
    }
}

