/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.KGCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables16kKGCMMultiplier_512;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables4kKGCMMultiplier_128;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.kgcm.Tables8kKGCMMultiplier_256;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class KGCMBlockCipher
implements AEADBlockCipher {
    private static final int MIN_MAC_BITS = 64;
    private BlockCipher engine;
    private BufferedBlockCipher ctrEngine;
    private int macSize;
    private boolean forEncryption;
    private byte[] initialAssociatedText;
    private byte[] macBlock;
    private byte[] iv;
    private KGCMMultiplier multiplier;
    private long[] b;
    private final int blockSize;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    private static KGCMMultiplier createDefaultMultiplier(int n) {
        if (n != 16) {
            if (n != 32) {
                if (n == 64) {
                    return new Tables16kKGCMMultiplier_512();
                }
                throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
            }
            return new Tables8kKGCMMultiplier_256();
        }
        return new Tables4kKGCMMultiplier_128();
    }

    public KGCMBlockCipher(BlockCipher blockCipher) {
        int n;
        this.engine = blockCipher;
        this.ctrEngine = new BufferedBlockCipher(new KCTRBlockCipher(blockCipher));
        this.macSize = -1;
        this.blockSize = n = this.engine.getBlockSize();
        this.initialAssociatedText = new byte[n];
        this.iv = new byte[n];
        this.multiplier = KGCMBlockCipher.createDefaultMultiplier(n);
        this.b = new long[n >>> 3];
        this.macBlock = null;
    }

    private void processAAD(byte[] byArray, int n, int n2) {
        n2 = n + n2;
        while (n < n2) {
            KGCMBlockCipher kGCMBlockCipher = this;
            KGCMBlockCipher.xorWithInput(kGCMBlockCipher.b, byArray, n);
            kGCMBlockCipher.multiplier.multiplyH(this.b);
            n += kGCMBlockCipher.blockSize;
        }
    }

    private void calculateMac(byte[] byArray, int n, int n2, int n3) {
        long l;
        int n4 = n + n2;
        while (n < n4) {
            KGCMBlockCipher kGCMBlockCipher = this;
            KGCMBlockCipher.xorWithInput(kGCMBlockCipher.b, byArray, n);
            kGCMBlockCipher.multiplier.multiplyH(this.b);
            n += kGCMBlockCipher.blockSize;
        }
        KGCMBlockCipher kGCMBlockCipher = this;
        long l2 = ((long)n3 & 0xFFFFFFFFL) << 3;
        long l3 = ((long)n2 & 0xFFFFFFFFL) << 3;
        long[] lArray = kGCMBlockCipher.b;
        lArray[0] = l = lArray[0] ^ l2;
        int n5 = this.blockSize >>> 4;
        lArray[n5] = l2 = kGCMBlockCipher.b[n5] ^ l3;
        byte[] byArray2 = Pack.longToLittleEndian(kGCMBlockCipher.b);
        kGCMBlockCipher.macBlock = byArray2;
        kGCMBlockCipher.engine.processBlock(byArray2, 0, byArray2, 0);
    }

    private static void xorWithInput(long[] lArray, byte[] byArray, int n) {
        for (int k = 0; k < lArray.length; ++k) {
            lArray[k] = lArray[k] ^ Pack.littleEndianToLong(byArray, n);
            n += 8;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block8: {
            ParametersWithIV parametersWithIV;
            CipherParameters cipherParameters;
            block7: {
                block5: {
                    int n;
                    block6: {
                        this.forEncryption = bl;
                        if (!(object instanceof AEADParameters)) break block5;
                        cipherParameters = (AEADParameters)object;
                        AEADParameters aEADParameters = cipherParameters;
                        byte[] byArray = aEADParameters.getNonce();
                        object = byArray;
                        KGCMBlockCipher kGCMBlockCipher = this;
                        n = kGCMBlockCipher.iv.length - ((Object)object).length;
                        Arrays.fill(kGCMBlockCipher.iv, (byte)0);
                        byte[] byArray2 = kGCMBlockCipher.iv;
                        int n2 = byArray.length;
                        System.arraycopy(byArray, 0, byArray2, n, n2);
                        this.initialAssociatedText = aEADParameters.getAssociatedText();
                        n = ((AEADParameters)cipherParameters).getMacSize();
                        if (n < 64 || n > this.blockSize << 3 || (n & 7) != 0) break block6;
                        this.macSize = n >>> 3;
                        cipherParameters = ((AEADParameters)cipherParameters).getKey();
                        byte[] byArray3 = this.initialAssociatedText;
                        if (this.initialAssociatedText != null) {
                            int n3 = byArray3.length;
                            this.processAADBytes(byArray3, 0, n3);
                        }
                        break block7;
                    }
                    throw new IllegalArgumentException(a.a("Invalid value for MAC size: ", n));
                }
                if (!(object instanceof ParametersWithIV)) break block8;
                cipherParameters = (ParametersWithIV)object;
                byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
                object = byArray;
                KGCMBlockCipher kGCMBlockCipher = this;
                int n = kGCMBlockCipher.iv.length - ((Object)object).length;
                Arrays.fill(kGCMBlockCipher.iv, (byte)0);
                byte[] byArray4 = kGCMBlockCipher.iv;
                int n4 = byArray.length;
                System.arraycopy(byArray, 0, byArray4, n, n4);
                this.initialAssociatedText = null;
                this.macSize = this.blockSize;
                cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            }
            KGCMBlockCipher kGCMBlockCipher = this;
            kGCMBlockCipher.macBlock = new byte[kGCMBlockCipher.blockSize];
            ParametersWithIV parametersWithIV2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(cipherParameters, this.iv);
            kGCMBlockCipher.ctrEngine.init(true, parametersWithIV2);
            kGCMBlockCipher.engine.init(true, cipherParameters);
            return;
        }
        throw new IllegalArgumentException("Invalid parameter passed");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KGCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void processAADByte(byte by) {
        ((OutputStream)this.associatedText).write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        ((OutputStream)this.associatedText).write(byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        ((OutputStream)this.data).write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length >= n + n2) {
            ((OutputStream)this.data).write(byArray, n, n2);
            return 0;
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        block11: {
            int n2;
            int n3;
            block10: {
                int n4;
                block8: {
                    block9: {
                        KGCMBlockCipher kGCMBlockCipher = this;
                        n3 = kGCMBlockCipher.data.size();
                        if (!kGCMBlockCipher.forEncryption && n3 < this.macSize) {
                            throw new InvalidCipherTextException("data too short");
                        }
                        KGCMBlockCipher kGCMBlockCipher2 = this;
                        byte[] byArray2 = new byte[kGCMBlockCipher2.blockSize];
                        kGCMBlockCipher2.engine.processBlock(byArray2, 0, byArray2, 0);
                        long[] lArray = new long[kGCMBlockCipher2.blockSize >>> 3];
                        Pack.littleEndianToLong(byArray2, 0, lArray);
                        this.multiplier.init(lArray);
                        Arrays.fill(byArray2, (byte)0);
                        Arrays.fill(lArray, 0L);
                        n4 = kGCMBlockCipher2.associatedText.size();
                        if (n4 > 0) {
                            KGCMBlockCipher kGCMBlockCipher3 = this;
                            kGCMBlockCipher3.processAAD(kGCMBlockCipher3.associatedText.getBuffer(), 0, n4);
                        }
                        if (!this.forEncryption) break block8;
                        if (byArray.length - n - this.macSize < n3) break block9;
                        KGCMBlockCipher kGCMBlockCipher4 = this;
                        n2 = kGCMBlockCipher4.ctrEngine.processBytes(this.data.getBuffer(), 0, n3, byArray, n);
                        n2 = kGCMBlockCipher4.ctrEngine.doFinal(byArray, n + n2) + n2;
                        this.calculateMac(byArray, n, n3, n4);
                        break block10;
                    }
                    throw new OutputLengthException("Output buffer too short");
                }
                n2 = n3 - this.macSize;
                if (byArray.length - n < n2) break block11;
                KGCMBlockCipher kGCMBlockCipher = this;
                kGCMBlockCipher.calculateMac(kGCMBlockCipher.data.getBuffer(), 0, n2, n4);
                n4 = kGCMBlockCipher.ctrEngine.processBytes(this.data.getBuffer(), 0, n2, byArray, n);
                n2 = kGCMBlockCipher.ctrEngine.doFinal(byArray, n + n4) + n4;
            }
            byte[] byArray3 = this.macBlock;
            if (this.macBlock != null) {
                if (this.forEncryption) {
                    KGCMBlockCipher kGCMBlockCipher = this;
                    int n5 = n + n2;
                    n = this.macSize;
                    System.arraycopy(byArray3, 0, byArray, n5, n);
                    kGCMBlockCipher.reset();
                    return n2 + kGCMBlockCipher.macSize;
                }
                byArray = new byte[this.macSize];
                KGCMBlockCipher kGCMBlockCipher = this;
                n = this.macSize;
                System.arraycopy(kGCMBlockCipher.data.getBuffer(), n3 - n, byArray, 0, n);
                int n6 = kGCMBlockCipher.macSize;
                byte[] byArray4 = new byte[n6];
                System.arraycopy(this.macBlock, 0, byArray4, 0, n6);
                if (Arrays.constantTimeAreEqual(byArray, byArray4)) {
                    this.reset();
                    return n2;
                }
                throw new InvalidCipherTextException("mac verification failed");
            }
            throw new IllegalStateException("mac is not calculated");
        }
        throw new OutputLengthException("Output buffer too short");
    }

    @Override
    public byte[] getMac() {
        int n = this.macSize;
        byte[] byArray = new byte[n];
        System.arraycopy(this.macBlock, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return 0;
    }

    @Override
    public int getOutputSize(int n) {
        KGCMBlockCipher kGCMBlockCipher = this;
        n = kGCMBlockCipher.data.size() + n;
        if (kGCMBlockCipher.forEncryption) {
            return n + this.macSize;
        }
        int n2 = this.macSize;
        return n < n2 ? 0 : n - n2;
    }

    @Override
    public void reset() {
        KGCMBlockCipher kGCMBlockCipher = this;
        Arrays.fill(kGCMBlockCipher.b, 0L);
        kGCMBlockCipher.engine.reset();
        kGCMBlockCipher.data.reset();
        kGCMBlockCipher.associatedText.reset();
        byte[] byArray = kGCMBlockCipher.initialAssociatedText;
        if (kGCMBlockCipher.initialAssociatedText != null) {
            int n = byArray.length;
            this.processAADBytes(byArray, 0, n);
        }
    }

    public class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

