/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertStore;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;

public class PKIXCRLStoreSelector<T extends CRL>
implements Selector<T> {
    private final CRLSelector baseSelector;
    private final boolean deltaCRLIndicator;
    private final boolean completeCRLEnabled;
    private final BigInteger maxBaseCRLNumber;
    private final byte[] issuingDistributionPoint;
    private final boolean issuingDistributionPointEnabled;

    private PKIXCRLStoreSelector(Builder builder) {
        this.baseSelector = builder.baseSelector;
        this.deltaCRLIndicator = builder.deltaCRLIndicator;
        this.completeCRLEnabled = builder.completeCRLEnabled;
        this.maxBaseCRLNumber = builder.maxBaseCRLNumber;
        this.issuingDistributionPoint = builder.issuingDistributionPoint;
        this.issuingDistributionPointEnabled = builder.issuingDistributionPointEnabled;
    }

    public static Collection<? extends CRL> getCRLs(PKIXCRLStoreSelector pKIXCRLStoreSelector, CertStore certStore) {
        return certStore.getCRLs(new SelectorClone(pKIXCRLStoreSelector));
    }

    public /* synthetic */ PKIXCRLStoreSelector(Builder builder, 1 var2_2) {
        this(builder);
    }

    public boolean isIssuingDistributionPointEnabled() {
        return this.issuingDistributionPointEnabled;
    }

    @Override
    public boolean match(CRL cRL) {
        Object object;
        Object object2;
        block9: {
            byte[] byArray;
            if (!(cRL instanceof X509CRL)) {
                return this.baseSelector.match(cRL);
            }
            object2 = (X509CRL)cRL;
            object = null;
            try {
                byArray = object2.getExtensionValue(Extension.deltaCRLIndicator.getId());
                if (byArray == null) break block9;
            }
            catch (Exception exception) {
                return false;
            }
            object = ASN1Integer.getInstance(ASN1OctetString.getInstance(byArray).getOctets());
        }
        if (this.isDeltaCRLIndicatorEnabled() && object == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && object != null) {
            return false;
        }
        if (object != null && this.maxBaseCRLNumber != null && ((ASN1Integer)object).getPositiveValue().compareTo(this.maxBaseCRLNumber) == 1) {
            return false;
        }
        if (this.issuingDistributionPointEnabled) {
            object2 = object2.getExtensionValue(Extension.issuingDistributionPoint.getId());
            object = this.issuingDistributionPoint;
            if (this.issuingDistributionPoint == null ? object2 != null : !Arrays.areEqual((byte[])object2, (byte[])object)) {
                return false;
            }
        }
        return this.baseSelector.match(cRL);
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.deltaCRLIndicator;
    }

    @Override
    public Object clone() {
        return this;
    }

    public boolean isCompleteCRLEnabled() {
        return this.completeCRLEnabled;
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.maxBaseCRLNumber;
    }

    public byte[] getIssuingDistributionPoint() {
        return Arrays.clone(this.issuingDistributionPoint);
    }

    public X509Certificate getCertificateChecking() {
        Cloneable cloneable = cloneable.baseSelector;
        if (cloneable instanceof X509CRLSelector) {
            return ((X509CRLSelector)cloneable).getCertificateChecking();
        }
        return null;
    }

    public static class SelectorClone
    extends X509CRLSelector {
        private final PKIXCRLStoreSelector selector;

        public SelectorClone(PKIXCRLStoreSelector pKIXCRLStoreSelector) {
            ((SelectorClone)x509CRLSelector).selector = pKIXCRLStoreSelector;
            if (pKIXCRLStoreSelector.baseSelector instanceof X509CRLSelector) {
                SelectorClone selectorClone = x509CRLSelector;
                X509CRLSelector x509CRLSelector = (X509CRLSelector)pKIXCRLStoreSelector.baseSelector;
                selectorClone.setCertificateChecking(x509CRLSelector.getCertificateChecking());
                selectorClone.setDateAndTime(x509CRLSelector.getDateAndTime());
                selectorClone.setIssuers(x509CRLSelector.getIssuers());
                selectorClone.setMinCRLNumber(x509CRLSelector.getMinCRL());
                selectorClone.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
            }
        }

        @Override
        public boolean match(CRL cRL) {
            Cloneable cloneable = ((SelectorClone)cloneable).selector;
            return cloneable == null ? cRL != null : ((PKIXCRLStoreSelector)cloneable).match(cRL);
        }
    }

    public static class Builder {
        private final CRLSelector baseSelector;
        private boolean deltaCRLIndicator = false;
        private boolean completeCRLEnabled = false;
        private BigInteger maxBaseCRLNumber = null;
        private byte[] issuingDistributionPoint = null;
        private boolean issuingDistributionPointEnabled = false;

        public Builder(CRLSelector cRLSelector) {
            this.baseSelector = (CRLSelector)cRLSelector.clone();
        }

        public Builder setCompleteCRLEnabled(boolean bl) {
            this.completeCRLEnabled = bl;
            return this;
        }

        public Builder setDeltaCRLIndicatorEnabled(boolean bl) {
            this.deltaCRLIndicator = bl;
            return this;
        }

        public void setMaxBaseCRLNumber(BigInteger bigInteger) {
            this.maxBaseCRLNumber = bigInteger;
        }

        public void setIssuingDistributionPointEnabled(boolean bl) {
            this.issuingDistributionPointEnabled = bl;
        }

        public void setIssuingDistributionPoint(byte[] byArray) {
            this.issuingDistributionPoint = Arrays.clone(byArray);
        }

        public PKIXCRLStoreSelector<? extends CRL> build() {
            return new PKIXCRLStoreSelector(this, null);
        }
    }
}

