/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ValidityPrecompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.a;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;

public abstract class ECPoint {
    public static final ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    public ECCurve curve;
    public ECFieldElement x;
    public ECFieldElement y;
    public ECFieldElement[] zs;
    public Hashtable preCompTable;

    public static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n = eCCurve == null ? 0 : eCCurve.getCoordinateSystem();
        if (n != 0 && n != 5) {
            ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
            switch (n) {
                default: {
                    throw new IllegalArgumentException("unknown coordinate system");
                }
                case 4: {
                    return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
                }
                case 3: {
                    return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
                }
                case 1: 
                case 2: 
                case 6: 
            }
            return new ECFieldElement[]{eCFieldElement};
        }
        return EMPTY_ZS;
    }

    public ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        ECFieldElement[] eCFieldElementArray = eCFieldElementArray2;
        ECFieldElement[] eCFieldElementArray2 = ECPoint.getInitialZCoords(eCCurve);
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray2);
    }

    public ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.preCompTable = null;
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    public abstract boolean satisfiesCurveEquation();

    public boolean satisfiesOrder() {
        if (ECConstants.ONE.equals(this.curve.getCofactor())) {
            return true;
        }
        BigInteger bigInteger = this.curve.getOrder();
        return bigInteger == null || ECAlgorithms.referenceMultiply(this, bigInteger).isInfinity();
    }

    public final ECPoint getDetachedPoint() {
        return this.normalize().detach();
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public abstract ECPoint detach();

    public int getCurveCoordinateSystem() {
        ECCurve eCCurve = ((ECPoint)((Object)eCCurve)).curve;
        return eCCurve == null ? 0 : eCCurve.getCoordinateSystem();
    }

    public ECFieldElement getAffineXCoord() {
        ECPoint eCPoint = this;
        eCPoint.checkNormalized();
        return eCPoint.getXCoord();
    }

    public ECFieldElement getAffineYCoord() {
        ECPoint eCPoint = this;
        eCPoint.checkNormalized();
        return eCPoint.getYCoord();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ECFieldElement getZCoord(int n) {
        if (n < 0) return null;
        ECFieldElement[] eCFieldElementArray = eCFieldElementArray.zs;
        if (n >= eCFieldElementArray.zs.length) {
            return null;
        }
        ECFieldElement eCFieldElement = eCFieldElementArray[n];
        return eCFieldElement;
    }

    public ECFieldElement[] getZCoords() {
        ECFieldElement[] eCFieldElementArray = eCFieldElementArray.zs;
        int n = eCFieldElementArray.zs.length;
        if (n == 0) {
            return EMPTY_ZS;
        }
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n];
        System.arraycopy(eCFieldElementArray, 0, eCFieldElementArray2, 0, n);
        return eCFieldElementArray2;
    }

    public final ECFieldElement getRawXCoord() {
        return this.x;
    }

    public final ECFieldElement getRawYCoord() {
        return this.y;
    }

    public final ECFieldElement[] getRawZCoords() {
        return this.zs;
    }

    public void checkNormalized() {
        if (this.isNormalized()) {
            return;
        }
        throw new IllegalStateException("point not in normal form");
    }

    public boolean isNormalized() {
        int n = this.getCurveCoordinateSystem();
        return n == 0 || n == 5 || this.isInfinity() || this.zs[0].isOne();
    }

    public ECPoint normalize() {
        if (((ECPoint)object).isInfinity()) {
            return object;
        }
        int n = ((ECPoint)object).getCurveCoordinateSystem();
        if (n != 0 && n != 5) {
            ECFieldElement eCFieldElement = ((ECPoint)object).getZCoord(0);
            if (eCFieldElement.isOne()) {
                return object;
            }
            if (((ECPoint)object).curve != null) {
                ECPoint eCPoint = object;
                ECPoint eCPoint2 = object;
                Object object = CryptoServicesRegistrar.getSecureRandom();
                object = eCPoint2.curve.randomFieldElementMult((SecureRandom)object);
                return eCPoint.normalize(eCFieldElement.multiply((ECFieldElement)object).invert().multiply((ECFieldElement)object));
            }
            throw new IllegalStateException("Detached points must be in affine coordinates");
        }
        return object;
    }

    public ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            default: {
                throw new IllegalStateException("not a projective coordinate system");
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                return this.createScaledPoint(eCFieldElement2, eCFieldElement2.multiply(eCFieldElement));
            }
            case 1: 
            case 6: 
        }
        ECFieldElement eCFieldElement3 = eCFieldElement;
        return this.createScaledPoint(eCFieldElement3, eCFieldElement3);
    }

    public ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInfinity() {
        if (eCFieldElementArray.x == null) return true;
        if (eCFieldElementArray.y == null) return true;
        ECFieldElement[] eCFieldElementArray = eCFieldElementArray.zs;
        if (eCFieldElementArray.zs.length <= 0) return false;
        if (!eCFieldElementArray[0].isZero()) return false;
        return true;
    }

    public boolean isValid() {
        return this.implIsValid(false, true);
    }

    public boolean isValidPartial() {
        return this.implIsValid(false, false);
    }

    public boolean implIsValid(final boolean bl, final boolean bl2) {
        PreCompCallback preCompCallback;
        if (this.isInfinity()) {
            return true;
        }
        PreCompCallback preCompCallback2 = preCompCallback;
        preCompCallback = new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                if ((preCompInfo = preCompInfo instanceof ValidityPrecompInfo ? (ValidityPrecompInfo)preCompInfo : null) == null) {
                    ValidityPrecompInfo validityPrecompInfo;
                    preCompInfo = validityPrecompInfo;
                    validityPrecompInfo = new ValidityPrecompInfo();
                }
                if (((ValidityPrecompInfo)preCompInfo).hasFailed()) {
                    return preCompInfo;
                }
                if (!((ValidityPrecompInfo)preCompInfo).hasCurveEquationPassed()) {
                    if (!bl && !ECPoint.this.satisfiesCurveEquation()) {
                        PreCompInfo preCompInfo2 = preCompInfo;
                        ((ValidityPrecompInfo)preCompInfo2).reportFailed();
                        return preCompInfo2;
                    }
                    ((ValidityPrecompInfo)preCompInfo).reportCurveEquationPassed();
                }
                if (bl2 && !((ValidityPrecompInfo)preCompInfo).hasOrderPassed()) {
                    if (!ECPoint.this.satisfiesOrder()) {
                        PreCompInfo preCompInfo3 = preCompInfo;
                        ((ValidityPrecompInfo)preCompInfo3).reportFailed();
                        return preCompInfo3;
                    }
                    ((ValidityPrecompInfo)preCompInfo).reportOrderPassed();
                }
                return preCompInfo;
            }
        };
        return ((ValidityPrecompInfo)this.getCurve().precompute(this, "bc_validity", preCompCallback2)).hasFailed() ^ true;
    }

    public ECPoint scaleX(ECFieldElement eCFieldElement) {
        if (!((ECPoint)object).isInfinity()) {
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            ECPoint eCPoint = object;
            Object object = eCPoint.getRawXCoord().multiply(eCFieldElement);
            eCFieldElement = eCPoint.getRawYCoord();
            ECFieldElement[] eCFieldElementArray = eCPoint.getRawZCoords();
            object = eCCurve.createRawPoint((ECFieldElement)object, eCFieldElement, eCFieldElementArray);
        }
        return object;
    }

    public ECPoint scaleXNegateY(ECFieldElement eCFieldElement) {
        if (!((ECPoint)object).isInfinity()) {
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            ECPoint eCPoint = object;
            Object object = eCPoint.getRawXCoord().multiply(eCFieldElement);
            eCFieldElement = eCPoint.getRawYCoord().negate();
            ECFieldElement[] eCFieldElementArray = eCPoint.getRawZCoords();
            object = eCCurve.createRawPoint((ECFieldElement)object, eCFieldElement, eCFieldElementArray);
        }
        return object;
    }

    public ECPoint scaleY(ECFieldElement eCFieldElement) {
        if (!((ECPoint)object).isInfinity()) {
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            ECPoint eCPoint = object;
            Object object = eCPoint.getRawXCoord();
            eCFieldElement = eCPoint.getRawYCoord().multiply(eCFieldElement);
            ECFieldElement[] eCFieldElementArray = eCPoint.getRawZCoords();
            object = eCCurve.createRawPoint((ECFieldElement)object, eCFieldElement, eCFieldElementArray);
        }
        return object;
    }

    public ECPoint scaleYNegateX(ECFieldElement eCFieldElement) {
        if (!((ECPoint)object).isInfinity()) {
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            ECPoint eCPoint = object;
            Object object = eCPoint.getRawXCoord().negate();
            eCFieldElement = eCPoint.getRawYCoord().multiply(eCFieldElement);
            ECFieldElement[] eCFieldElementArray = eCPoint.getRawZCoords();
            object = eCCurve.createRawPoint((ECFieldElement)object, eCFieldElement, eCFieldElementArray);
        }
        return object;
    }

    public boolean equals(ECPoint eCPoint) {
        if (eCPoint == null) {
            return false;
        }
        ECCurve eCCurve = eCPoint2.getCurve();
        ECPoint[] eCPointArray = eCPoint.getCurve();
        boolean bl = eCCurve == null;
        boolean bl2 = eCPointArray == null;
        boolean bl3 = eCPoint2.isInfinity();
        boolean bl4 = eCPoint.isInfinity();
        if (!bl3 && !bl4) {
            if (!bl || !bl2) {
                ECPoint eCPoint2;
                if (bl) {
                    eCPoint = eCPoint.normalize();
                } else if (bl2) {
                    eCPoint2 = eCPoint2.normalize();
                } else {
                    if (!eCCurve.equals((ECCurve)eCPointArray)) {
                        return false;
                    }
                    eCPointArray = new ECPoint[]{eCPoint2, eCCurve.importPoint(eCPoint)};
                    eCCurve.normalizeAll(eCPointArray);
                    eCPoint2 = eCPointArray[0];
                    eCPoint = eCPointArray[1];
                }
            }
            return eCPoint2.getXCoord().equals(eCPoint.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint.getYCoord());
        }
        return bl3 && bl4 && (bl || bl2 || eCCurve.equals((ECCurve)eCPointArray));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        ECCurve eCCurve = eCPoint.getCurve();
        int n = eCCurve == null ? 0 : ~eCCurve.hashCode();
        if (!eCPoint.isInfinity()) {
            ECPoint eCPoint = eCPoint.normalize();
            n = n ^ eCPoint.getXCoord().hashCode() * 17 ^ eCPoint.getYCoord().hashCode() * 257;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        StringBuffer stringBuffer4 = stringBuffer2;
        stringBuffer4();
        stringBuffer4.append('(');
        stringBuffer3.append(this.getRawXCoord());
        stringBuffer3.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int k = 0; k < this.zs.length; ++k) {
            stringBuffer2.append(',');
            stringBuffer2.append(this.zs[k]);
        }
        StringBuffer stringBuffer5 = stringBuffer2;
        stringBuffer5.append(')');
        return stringBuffer5.toString();
    }

    public byte[] getEncoded(boolean bl) {
        if (((ECPoint)object).isInfinity()) {
            return new byte[1];
        }
        Object object = ((ECPoint)object).normalize();
        byte[] byArray = ((ECPoint)object).getXCoord().getEncoded();
        if (bl) {
            ECPoint eCPoint = object;
            object = new byte[byArray.length + 1];
            int n = 0;
            byte by = (byte)(eCPoint.getCompressionYTilde() ? 3 : 2);
            object[n] = by;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, object, 1, n2);
            return object;
        }
        object = ((ECPoint)object).getYCoord().getEncoded();
        byte[] byArray2 = new byte[byArray.length + ((Object)object).length + 1];
        Object object2 = object;
        byArray2[0] = 4;
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, n);
        n = byArray.length + 1;
        int n3 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray2, n, n3);
        return byArray2;
    }

    public abstract boolean getCompressionYTilde();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public ECPoint timesPow2(int n) {
        if (n >= 0) {
            while ((n += -1) >= 0) {
                ECPoint eCPoint = eCPoint.twice();
            }
            return eCPoint;
        }
        throw new IllegalArgumentException("'e' cannot be negative");
    }

    public abstract ECPoint twice();

    public ECPoint twicePlus(ECPoint eCPoint) {
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        ECPoint eCPoint = this;
        return eCPoint.twicePlus(eCPoint);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        return this.getCurve().getMultiplier().multiply(this, bigInteger);
    }

    public static class F2m
    extends AbstractF2m {
        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public ECPoint detach() {
            F2m f2m = eCFieldElement;
            ECFieldElement eCFieldElement = f2m.getAffineXCoord();
            ECFieldElement eCFieldElement2 = f2m.getAffineYCoord();
            return new F2m(null, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement getYCoord() {
            int n = ((ECPoint)this).getCurveCoordinateSystem();
            if (n != 5 && n != 6) {
                return ((ECPoint)this).y;
            }
            F2m f2m = this;
            ECFieldElement eCFieldElement = f2m.x;
            ECFieldElement eCFieldElement2 = f2m.y;
            if (!f2m.isInfinity() && !eCFieldElement.isZero()) {
                eCFieldElement = eCFieldElement2.add(eCFieldElement).multiply(eCFieldElement);
                if (6 == n && !((ECFieldElement)(this = ((ECPoint)this).zs[0])).isOne()) {
                    eCFieldElement = eCFieldElement.divide((ECFieldElement)this);
                }
                return eCFieldElement;
            }
            return eCFieldElement2;
        }

        @Override
        public boolean getCompressionYTilde() {
            ECFieldElement eCFieldElement = ((ECPoint)((Object)eCFieldElement2)).getRawXCoord();
            if (eCFieldElement.isZero()) {
                return false;
            }
            F2m f2m = eCFieldElement2;
            ECFieldElement eCFieldElement2 = f2m.getRawYCoord();
            int n = f2m.getCurveCoordinateSystem();
            if (n != 5 && n != 6) {
                return eCFieldElement2.divide(eCFieldElement).testBitZero();
            }
            return eCFieldElement2.testBitZero() != eCFieldElement.testBitZero();
        }

        @Override
        public ECPoint add(ECPoint object) {
            Object object2;
            if (((ECPoint)object2).isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return object2;
            }
            ECFieldElement[] eCFieldElementArray = ((ECPoint)object2).getCurve();
            int n = eCFieldElementArray.getCoordinateSystem();
            ECFieldElement eCFieldElement = ((ECPoint)object2).x;
            ECFieldElement eCFieldElement2 = ((ECPoint)object).x;
            if (n != 0) {
                if (n != 1) {
                    if (n == 6) {
                        ECFieldElement[] eCFieldElementArray2;
                        Object object3;
                        ECFieldElement eCFieldElement3;
                        if (eCFieldElement.isZero()) {
                            if (eCFieldElement2.isZero()) {
                                return eCFieldElementArray.getInfinity();
                            }
                            return ((ECPoint)object).add((ECPoint)object2);
                        }
                        F2m f2m = object2;
                        Object object4 = f2m.y;
                        ECFieldElement eCFieldElement4 = f2m.zs[0];
                        Object object5 = object;
                        object = ((ECPoint)object5).y;
                        ECFieldElement eCFieldElement5 = ((ECPoint)object5).zs[0];
                        boolean bl = eCFieldElement4.isOne();
                        if (!bl) {
                            eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement4);
                            object3 = ((ECFieldElement)object).multiply(eCFieldElement4);
                        } else {
                            object3 = object;
                            eCFieldElement3 = eCFieldElement2;
                        }
                        boolean bl2 = eCFieldElement5.isOne();
                        if (!bl2) {
                            eCFieldElement = eCFieldElement.multiply(eCFieldElement5);
                            eCFieldElementArray2 = object4.multiply(eCFieldElement5);
                        } else {
                            eCFieldElementArray2 = object4;
                        }
                        object3 = eCFieldElementArray2.add((ECFieldElement)object3);
                        eCFieldElementArray2 = eCFieldElement.add(eCFieldElement3);
                        if (eCFieldElementArray2.isZero()) {
                            if (((ECFieldElement)object3).isZero()) {
                                return ((F2m)object2).twice();
                            }
                            return eCFieldElementArray.getInfinity();
                        }
                        if (eCFieldElement2.isZero()) {
                            ECPoint eCPoint = ((ECPoint)object2).normalize();
                            object2 = eCPoint.getXCoord();
                            object4 = eCPoint.getYCoord();
                            object = object4.add((ECFieldElement)object).divide((ECFieldElement)object2);
                            eCFieldElement = a.a((ECFieldElement)object, (ECFieldElement)object, (ECFieldElement)object2).add(eCFieldElementArray.getA());
                            if (eCFieldElement.isZero()) {
                                return new F2m((ECCurve)eCFieldElementArray, eCFieldElement, eCFieldElementArray.getB().sqrt());
                            }
                            object2 = ((ECFieldElement)object).multiply(((ECFieldElement)object2).add(eCFieldElement)).add(eCFieldElement).add((ECFieldElement)object4).divide(eCFieldElement).add(eCFieldElement);
                            object = eCFieldElementArray.fromBigInteger(ECConstants.ONE);
                        } else {
                            object2 = eCFieldElementArray2.square();
                            object = ((ECFieldElement)object3).multiply(eCFieldElement3);
                            if ((eCFieldElement = ((ECFieldElement)object3).multiply(eCFieldElement).multiply((ECFieldElement)object)).isZero()) {
                                return new F2m((ECCurve)eCFieldElementArray, eCFieldElement, eCFieldElementArray.getB().sqrt());
                            }
                            eCFieldElement2 = ((ECFieldElement)object3).multiply((ECFieldElement)object2);
                            if (!bl2) {
                                eCFieldElement2 = eCFieldElement2.multiply(eCFieldElement5);
                            }
                            object2 = ((ECFieldElement)object).add((ECFieldElement)object2).squarePlusProduct(eCFieldElement2, object4.add(eCFieldElement4));
                            object = !bl ? eCFieldElement2.multiply(eCFieldElement4) : eCFieldElement2;
                        }
                        ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                        object4 = eCFieldElementArray3;
                        eCFieldElementArray3[0] = object;
                        return new F2m((ECCurve)eCFieldElementArray, eCFieldElement, (ECFieldElement)object2, (ECFieldElement[])object4);
                    }
                    throw new IllegalStateException("unsupported coordinate system");
                }
                ECPoint eCPoint = object;
                F2m f2m = object2;
                object = f2m.y;
                ECFieldElement eCFieldElement6 = f2m.zs[0];
                ECFieldElement eCFieldElement7 = eCPoint.y;
                ECFieldElement eCFieldElement8 = eCPoint.zs[0];
                boolean bl = eCFieldElement8.isOne();
                eCFieldElement7 = eCFieldElement6.multiply(eCFieldElement7);
                Object object6 = bl ? object : ((ECFieldElement)object).multiply(eCFieldElement8);
                eCFieldElement7 = eCFieldElement7.add((ECFieldElement)object6);
                eCFieldElement2 = eCFieldElement6.multiply(eCFieldElement2);
                object6 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement8);
                if ((eCFieldElement2 = eCFieldElement2.add((ECFieldElement)object6)).isZero()) {
                    if (eCFieldElement7.isZero()) {
                        return ((F2m)object2).twice();
                    }
                    return eCFieldElementArray.getInfinity();
                }
                object2 = eCFieldElement2.square();
                object6 = ((ECFieldElement)object2).multiply(eCFieldElement2);
                if (!bl) {
                    eCFieldElement6 = eCFieldElement6.multiply(eCFieldElement8);
                }
                ECFieldElement eCFieldElement9 = eCFieldElement7.add(eCFieldElement2);
                ECFieldElement eCFieldElement10 = eCFieldElement9.multiplyPlusProduct(eCFieldElement7, (ECFieldElement)object2, eCFieldElementArray.getA()).multiply(eCFieldElement6).add((ECFieldElement)object6);
                ECFieldElement eCFieldElement11 = eCFieldElement2.multiply(eCFieldElement10);
                if (!bl) {
                    object2 = ((ECFieldElement)object2).multiply(eCFieldElement8);
                }
                object2 = eCFieldElement7.multiplyPlusProduct(eCFieldElement, eCFieldElement2, (ECFieldElement)object).multiplyPlusProduct((ECFieldElement)object2, eCFieldElement9, eCFieldElement10);
                object = ((ECFieldElement)object6).multiply(eCFieldElement6);
                ECFieldElement[] eCFieldElementArray4 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray5 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray5;
                eCFieldElementArray5[0] = object;
                return new F2m((ECCurve)eCFieldElementArray4, eCFieldElement11, (ECFieldElement)object2, eCFieldElementArray);
            }
            ECFieldElement eCFieldElement12 = ((ECPoint)object2).y;
            object = ((ECPoint)object).y;
            eCFieldElement2 = eCFieldElement.add(eCFieldElement2);
            object = eCFieldElement12.add((ECFieldElement)object);
            if (eCFieldElement2.isZero()) {
                if (((ECFieldElement)object).isZero()) {
                    return ((F2m)object2).twice();
                }
                return eCFieldElementArray.getInfinity();
            }
            ECFieldElement eCFieldElement13 = ((ECFieldElement)object).divide(eCFieldElement2);
            object2 = a.a(eCFieldElement13, eCFieldElement13, eCFieldElement2).add(eCFieldElementArray.getA());
            object = eCFieldElement13.multiply(eCFieldElement.add((ECFieldElement)object2)).add((ECFieldElement)object2).add(eCFieldElement12);
            return new F2m((ECCurve)eCFieldElementArray, (ECFieldElement)object2, (ECFieldElement)object);
        }

        @Override
        public ECPoint twice() {
            Object object;
            if (((ECPoint)object).isInfinity()) {
                return object;
            }
            F2m f2m = object;
            ECFieldElement[] eCFieldElementArray = f2m.getCurve();
            Object object2 = f2m.x;
            if (f2m.x.isZero()) {
                return eCFieldElementArray.getInfinity();
            }
            int n = eCFieldElementArray.getCoordinateSystem();
            if (n != 0) {
                if (n != 1) {
                    if (n == 6) {
                        F2m f2m2 = object;
                        object = f2m2.y;
                        ECFieldElement eCFieldElement = f2m2.zs[0];
                        boolean bl = eCFieldElement.isOne();
                        Object object3 = bl ? object : ((ECFieldElement)object).multiply(eCFieldElement);
                        ECFieldElement eCFieldElement2 = bl ? eCFieldElement : eCFieldElement.square();
                        ECFieldElement eCFieldElement3 = eCFieldElementArray.getA();
                        ECFieldElement eCFieldElement4 = bl ? eCFieldElement3 : eCFieldElement3.multiply(eCFieldElement2);
                        ECFieldElement eCFieldElement5 = a.a((ECFieldElement)object, (ECFieldElement)object3, eCFieldElement4);
                        if (eCFieldElement5.isZero()) {
                            return new F2m((ECCurve)eCFieldElementArray, eCFieldElement5, eCFieldElementArray.getB().sqrt());
                        }
                        ECFieldElement eCFieldElement6 = eCFieldElement5.square();
                        ECFieldElement eCFieldElement7 = bl ? eCFieldElement5 : eCFieldElement5.multiply(eCFieldElement2);
                        ECFieldElement eCFieldElement8 = eCFieldElementArray.getB();
                        if (eCFieldElement8.bitLength() < eCFieldElementArray.getFieldSize() >> 1) {
                            object = ((ECFieldElement)object).add((ECFieldElement)object2).square();
                            object2 = eCFieldElement8.isOne() ? eCFieldElement4.add(eCFieldElement2).square() : eCFieldElement4.squarePlusProduct(eCFieldElement8, eCFieldElement2.square());
                            object = ((ECFieldElement)object).add(eCFieldElement5).add(eCFieldElement2).multiply((ECFieldElement)object).add((ECFieldElement)object2).add(eCFieldElement6);
                            if (eCFieldElement3.isZero()) {
                                object = ((ECFieldElement)object).add(eCFieldElement7);
                            } else if (!eCFieldElement3.isOne()) {
                                object = ((ECFieldElement)object).add(eCFieldElement3.addOne().multiply(eCFieldElement7));
                            }
                        } else {
                            if (!bl) {
                                object2 = object2.multiply(eCFieldElement);
                            }
                            object = object2.squarePlusProduct(eCFieldElement5, (ECFieldElement)object3).add(eCFieldElement6).add(eCFieldElement7);
                        }
                        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[1];
                        object2 = eCFieldElementArray2;
                        eCFieldElementArray2[0] = eCFieldElement7;
                        return new F2m((ECCurve)eCFieldElementArray, eCFieldElement6, (ECFieldElement)object, (ECFieldElement[])object2);
                    }
                    throw new IllegalStateException("unsupported coordinate system");
                }
                F2m f2m3 = object;
                object = f2m3.y;
                ECFieldElement eCFieldElement = f2m3.zs[0];
                boolean bl = eCFieldElement.isOne();
                Object object4 = bl ? object2 : object2.multiply(eCFieldElement);
                if (!bl) {
                    object = ((ECFieldElement)object).multiply(eCFieldElement);
                }
                object2 = object2.square();
                object = object2.add((ECFieldElement)object);
                eCFieldElement = object4.square();
                ECFieldElement eCFieldElement9 = ((ECFieldElement)object).add((ECFieldElement)object4);
                object = eCFieldElement9.multiplyPlusProduct((ECFieldElement)object, eCFieldElement, eCFieldElementArray.getA());
                ECFieldElement eCFieldElement10 = object4.multiply((ECFieldElement)object);
                object = object2.square().multiplyPlusProduct((ECFieldElement)object4, (ECFieldElement)object, eCFieldElement9);
                object2 = object4.multiply(eCFieldElement);
                ECFieldElement[] eCFieldElementArray3 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray4 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray4;
                eCFieldElementArray4[0] = object2;
                return new F2m((ECCurve)eCFieldElementArray3, eCFieldElement10, (ECFieldElement)object, eCFieldElementArray);
            }
            ECFieldElement eCFieldElement = ((ECPoint)object).y.divide((ECFieldElement)object2).add((ECFieldElement)object2);
            object = eCFieldElement;
            object = eCFieldElement.square().add((ECFieldElement)object).add(eCFieldElementArray.getA());
            object2 = object2.squarePlusProduct((ECFieldElement)object, eCFieldElement.addOne());
            return new F2m((ECCurve)eCFieldElementArray, (ECFieldElement)object, (ECFieldElement)object2);
        }

        @Override
        public ECPoint twicePlus(ECPoint object) {
            if (((ECPoint)object2).isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return ((F2m)object2).twice();
            }
            F2m f2m = object2;
            ECFieldElement[] eCFieldElementArray = f2m.getCurve();
            ECFieldElement eCFieldElement = f2m.x;
            if (eCFieldElement.isZero()) {
                return object;
            }
            if (eCFieldElementArray.getCoordinateSystem() != 6) {
                return ((F2m)object2).twice().add((ECPoint)object);
            }
            ECFieldElement eCFieldElement2 = ((ECPoint)object).x;
            ECFieldElement eCFieldElement3 = ((ECPoint)object).zs[0];
            if (!eCFieldElement2.isZero() && eCFieldElement3.isOne()) {
                ECFieldElement eCFieldElement4 = eCFieldElement2;
                F2m f2m2 = object2;
                Object object2 = f2m2.y;
                eCFieldElement2 = f2m2.zs[0];
                Object object3 = object2;
                ECFieldElement eCFieldElement5 = eCFieldElement2;
                Object object4 = object2;
                object2 = eCFieldElement.square();
                eCFieldElement = ((ECFieldElement)object4).square();
                eCFieldElement2 = eCFieldElement5.square();
                eCFieldElement3 = ((ECFieldElement)object3).multiply(eCFieldElement5);
                eCFieldElement3 = eCFieldElementArray.getA().multiply(eCFieldElement2).add(eCFieldElement).add(eCFieldElement3);
                ECFieldElement eCFieldElement6 = ((ECPoint)object).y.addOne();
                object2 = eCFieldElementArray.getA().add(eCFieldElement6).multiply(eCFieldElement2).add(eCFieldElement).multiplyPlusProduct(eCFieldElement3, (ECFieldElement)object2, eCFieldElement2);
                eCFieldElement = eCFieldElement4.multiply(eCFieldElement2);
                ECFieldElement eCFieldElement7 = eCFieldElement.add(eCFieldElement3).square();
                if (eCFieldElement7.isZero()) {
                    if (((ECFieldElement)object2).isZero()) {
                        return ((ECPoint)object).twice();
                    }
                    return eCFieldElementArray.getInfinity();
                }
                if (((ECFieldElement)object2).isZero()) {
                    return new F2m((ECCurve)eCFieldElementArray, (ECFieldElement)object2, eCFieldElementArray.getB().sqrt());
                }
                Object object5 = object2;
                Object object6 = object2;
                object2 = ((ECFieldElement)object2).square().multiply(eCFieldElement);
                object = ((ECFieldElement)object6).multiply(eCFieldElement7).multiply(eCFieldElement2);
                eCFieldElement = ((ECFieldElement)object5).add(eCFieldElement7).square().multiplyPlusProduct(eCFieldElement3, eCFieldElement6, (ECFieldElement)object);
                ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray3;
                eCFieldElementArray3[0] = object;
                return new F2m((ECCurve)eCFieldElementArray2, (ECFieldElement)object2, eCFieldElement, eCFieldElementArray);
            }
            return ((F2m)object2).twice().add((ECPoint)object);
        }

        @Override
        public ECPoint negate() {
            ECFieldElement[] eCFieldElementArray;
            if (eCFieldElementArray.isInfinity()) {
                return eCFieldElementArray;
            }
            ECFieldElement eCFieldElement = eCFieldElementArray.x;
            if (eCFieldElement.isZero()) {
                return eCFieldElementArray;
            }
            int n = eCFieldElementArray.getCurveCoordinateSystem();
            if (n != 0) {
                if (n != 1) {
                    if (n != 5) {
                        if (n == 6) {
                            ECFieldElement eCFieldElement2 = eCFieldElementArray.y;
                            ECFieldElement eCFieldElement3 = eCFieldElementArray.zs[0];
                            eCFieldElementArray = eCFieldElementArray.curve;
                            eCFieldElement2 = eCFieldElement2.add(eCFieldElement3);
                            ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                            ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                            eCFieldElementArray = eCFieldElementArray3;
                            eCFieldElementArray3[0] = eCFieldElement3;
                            return new F2m((ECCurve)eCFieldElementArray2, eCFieldElement, eCFieldElement2, eCFieldElementArray);
                        }
                        throw new IllegalStateException("unsupported coordinate system");
                    }
                    ECFieldElement eCFieldElement4 = eCFieldElementArray.y;
                    eCFieldElementArray = eCFieldElementArray.curve;
                    eCFieldElement4 = eCFieldElement4.addOne();
                    return new F2m((ECCurve)eCFieldElementArray, eCFieldElement, eCFieldElement4);
                }
                F2m f2m = eCFieldElementArray;
                ECFieldElement eCFieldElement5 = f2m.y;
                ECFieldElement eCFieldElement6 = f2m.zs[0];
                eCFieldElementArray = eCFieldElementArray.curve;
                eCFieldElement5 = eCFieldElement5.add(eCFieldElement);
                ECFieldElement[] eCFieldElementArray4 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray5 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray5;
                eCFieldElementArray5[0] = eCFieldElement6;
                return new F2m((ECCurve)eCFieldElementArray4, eCFieldElement, eCFieldElement5, eCFieldElementArray);
            }
            ECFieldElement eCFieldElement7 = eCFieldElementArray.y;
            eCFieldElementArray = eCFieldElementArray.curve;
            eCFieldElement7 = eCFieldElement7.add(eCFieldElement);
            return new F2m((ECCurve)eCFieldElementArray, eCFieldElement, eCFieldElement7);
        }
    }

    public static abstract class AbstractF2m
    extends ECPoint {
        public AbstractF2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public AbstractF2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public boolean satisfiesCurveEquation() {
            Object object;
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            ECFieldElement eCFieldElement = ((ECPoint)object).x;
            ECFieldElement eCFieldElement2 = eCCurve.getA();
            ECFieldElement eCFieldElement3 = eCCurve.getB();
            int n = eCCurve.getCoordinateSystem();
            if (n == 6) {
                ECFieldElement eCFieldElement4 = ((ECPoint)object).zs[0];
                boolean bl = eCFieldElement4.isOne();
                if (eCFieldElement.isZero()) {
                    object = ((ECPoint)object).y.square();
                    if (!bl) {
                        eCFieldElement3 = eCFieldElement3.multiply(eCFieldElement4.square());
                    }
                    return object.equals(eCFieldElement3);
                }
                object = ((ECPoint)object).y;
                eCFieldElement = eCFieldElement.square();
                if (bl) {
                    Object object2 = object;
                    object = a.a((ECFieldElement)object2, (ECFieldElement)object2, eCFieldElement2);
                    eCFieldElement2 = eCFieldElement.square().add(eCFieldElement3);
                } else {
                    ECFieldElement eCFieldElement5 = eCFieldElement3;
                    ECFieldElement eCFieldElement6 = eCFieldElement4;
                    eCFieldElement3 = eCFieldElement6.square();
                    eCFieldElement4 = eCFieldElement3.square();
                    object = ((ECFieldElement)object).add(eCFieldElement6).multiplyPlusProduct((ECFieldElement)object, eCFieldElement2, eCFieldElement3);
                    eCFieldElement2 = eCFieldElement.squarePlusProduct(eCFieldElement5, eCFieldElement4);
                }
                return ((ECFieldElement)object).multiply(eCFieldElement).equals(eCFieldElement2);
            }
            ECFieldElement eCFieldElement7 = ((ECPoint)object).y;
            eCFieldElement7 = eCFieldElement7.add(eCFieldElement).multiply(eCFieldElement7);
            if (n != 0) {
                if (n == 1) {
                    object = ((ECPoint)object).zs[0];
                    if (!((ECFieldElement)object).isOne()) {
                        Object object3 = object;
                        Object object4 = object;
                        object = ((ECFieldElement)object4).multiply(((ECFieldElement)object4).square());
                        eCFieldElement7 = eCFieldElement7.multiply((ECFieldElement)object4);
                        eCFieldElement2 = eCFieldElement2.multiply((ECFieldElement)object3);
                        eCFieldElement3 = eCFieldElement3.multiply((ECFieldElement)object);
                    }
                } else {
                    throw new IllegalStateException("unsupported coordinate system");
                }
            }
            return eCFieldElement7.equals(eCFieldElement.add(eCFieldElement2).multiply(eCFieldElement.square()).add(eCFieldElement3));
        }

        @Override
        public boolean satisfiesOrder() {
            Object object = ((ECPoint)object2).curve.getCofactor();
            if (ECConstants.TWO.equals(object)) {
                return ((ECFieldElement.AbstractF2m)((ECPoint)object2).normalize().getAffineXCoord()).trace() != 0;
            }
            if (ECConstants.FOUR.equals(object)) {
                AbstractF2m abstractF2m = object2;
                Object object2 = abstractF2m.normalize();
                object = ((ECPoint)object2).getAffineXCoord();
                Object object3 = abstractF2m.curve;
                if ((object3 = ((ECCurve.AbstractF2m)object3).solveQuadraticEquation(((ECFieldElement)object).add(((ECCurve)object3).getA()))) == null) {
                    return false;
                }
                object2 = ((ECPoint)object2).getAffineYCoord();
                return ((ECFieldElement.AbstractF2m)((ECFieldElement)object).multiply((ECFieldElement)object3).add((ECFieldElement)object2)).trace() == 0;
            }
            return super.satisfiesOrder();
        }

        @Override
        public ECPoint scaleX(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2;
            if (eCFieldElementArray.isInfinity()) {
                return eCFieldElementArray;
            }
            int n = eCFieldElementArray.getCurveCoordinateSystem();
            if (n != 5) {
                if (n != 6) {
                    return super.scaleX(eCFieldElement);
                }
                AbstractF2m abstractF2m = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray = abstractF2m.getRawXCoord();
                ECFieldElement eCFieldElement3 = abstractF2m.getRawYCoord();
                ECFieldElement eCFieldElement4 = eCFieldElement;
                eCFieldElementArray = eCFieldElementArray.multiply(eCFieldElement.square());
                eCFieldElement = eCFieldElement3.add((ECFieldElement)eCFieldElementArray).add((ECFieldElement)eCFieldElementArray);
                eCFieldElement3 = abstractF2m.getRawZCoords()[0].multiply(eCFieldElement4);
                ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray3;
                eCFieldElementArray3[0] = eCFieldElement3;
                return abstractF2m.getCurve().createRawPoint((ECFieldElement)eCFieldElementArray2, eCFieldElement, eCFieldElementArray);
            }
            AbstractF2m abstractF2m = eCFieldElementArray;
            ECFieldElement eCFieldElement5 = eCFieldElement2 = abstractF2m.getRawXCoord();
            ECFieldElement eCFieldElement6 = eCFieldElement5.multiply(eCFieldElement);
            eCFieldElement = abstractF2m.getRawYCoord().add(eCFieldElement5).divide(eCFieldElement).add(eCFieldElement6);
            return abstractF2m.getCurve().createRawPoint(eCFieldElement2, eCFieldElement, eCFieldElementArray.getRawZCoords());
        }

        @Override
        public ECPoint scaleXNegateY(ECFieldElement eCFieldElement) {
            return this.scaleX(eCFieldElement);
        }

        @Override
        public ECPoint scaleY(ECFieldElement eCFieldElement) {
            if (this.isInfinity()) {
                return this;
            }
            int n = this.getCurveCoordinateSystem();
            if (n != 5 && n != 6) {
                return super.scaleY(eCFieldElement);
            }
            AbstractF2m abstractF2m = this;
            ECFieldElement eCFieldElement2 = abstractF2m.getRawXCoord();
            eCFieldElement = abstractF2m.getRawYCoord().add(eCFieldElement2).multiply(eCFieldElement).add(eCFieldElement2);
            return abstractF2m.getCurve().createRawPoint(eCFieldElement2, eCFieldElement, this.getRawZCoords());
        }

        @Override
        public ECPoint scaleYNegateX(ECFieldElement eCFieldElement) {
            return this.scaleY(eCFieldElement);
        }

        @Override
        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        public AbstractF2m tau() {
            Object object;
            ECFieldElement eCFieldElement;
            ECFieldElement[] eCFieldElementArray;
            block4: {
                block5: {
                    if (((ECPoint)object).isInfinity()) {
                        return object;
                    }
                    eCFieldElementArray = ((ECPoint)object).getCurve();
                    int n = eCFieldElementArray.getCoordinateSystem();
                    eCFieldElement = ((ECPoint)object).x;
                    if (n == 0) break block4;
                    if (n == 1) break block5;
                    if (n == 5) break block4;
                    if (n != 6) throw new IllegalStateException("unsupported coordinate system");
                }
                ECCurve eCCurve = eCFieldElementArray;
                object = ((ECPoint)object).zs[0];
                eCFieldElementArray = eCFieldElement.square();
                ECFieldElement eCFieldElement2 = ((ECPoint)object).y.square();
                ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray3;
                eCFieldElementArray3[0] = ((ECFieldElement)object).square();
                return (AbstractF2m)eCCurve.createRawPoint((ECFieldElement)eCFieldElementArray2, eCFieldElement2, eCFieldElementArray);
            }
            object = eCFieldElement.square();
            return (AbstractF2m)eCFieldElementArray.createRawPoint((ECFieldElement)object, ((ECPoint)object).y.square());
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        public AbstractF2m tauPow(int n) {
            Object object;
            ECFieldElement eCFieldElement;
            ECFieldElement[] eCFieldElementArray;
            block4: {
                block5: {
                    if (((ECPoint)object).isInfinity()) {
                        return object;
                    }
                    eCFieldElementArray = ((ECPoint)object).getCurve();
                    int n2 = eCFieldElementArray.getCoordinateSystem();
                    eCFieldElement = ((ECPoint)object).x;
                    if (n2 == 0) break block4;
                    if (n2 == 1) break block5;
                    if (n2 == 5) break block4;
                    if (n2 != 6) throw new IllegalStateException("unsupported coordinate system");
                }
                ECCurve eCCurve = eCFieldElementArray;
                object = ((ECPoint)object).zs[0];
                eCFieldElementArray = eCFieldElement.squarePow(n);
                ECFieldElement eCFieldElement2 = ((ECPoint)object).y.squarePow(n);
                ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray3;
                eCFieldElementArray3[0] = ((ECFieldElement)object).squarePow(n);
                return (AbstractF2m)eCCurve.createRawPoint((ECFieldElement)eCFieldElementArray2, eCFieldElement2, eCFieldElementArray);
            }
            object = eCFieldElement.squarePow(n);
            return (AbstractF2m)eCFieldElementArray.createRawPoint((ECFieldElement)object, ((ECPoint)object).y.squarePow(n));
        }
    }

    public static class Fp
    extends AbstractFp {
        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public ECPoint detach() {
            Fp fp = eCFieldElement;
            ECFieldElement eCFieldElement = fp.getAffineXCoord();
            ECFieldElement eCFieldElement2 = fp.getAffineYCoord();
            return new Fp(null, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement getZCoord(int n) {
            if (n == 1 && 4 == this.getCurveCoordinateSystem()) {
                return this.getJacobianModifiedW();
            }
            return super.getZCoord(n);
        }

        @Override
        public ECPoint add(ECPoint object) {
            Object object2;
            if (((ECPoint)object2).isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return object2;
            }
            if (object2 == object) {
                return ((Fp)object2).twice();
            }
            ECFieldElement[] eCFieldElementArray = ((ECPoint)object2).getCurve();
            int n = eCFieldElementArray.getCoordinateSystem();
            ECPoint eCPoint = object;
            Fp fp = object2;
            ECFieldElement eCFieldElement = fp.x;
            Object object3 = fp.y;
            ECFieldElement eCFieldElement2 = eCPoint.x;
            ECFieldElement eCFieldElement3 = eCPoint.y;
            if (n != 0) {
                if (n != 1) {
                    ECFieldElement[] eCFieldElementArray2;
                    if (n != 2 && n != 4) {
                        throw new IllegalStateException("unsupported coordinate system");
                    }
                    ECFieldElement eCFieldElement4 = ((ECPoint)object2).zs[0];
                    object = ((ECPoint)object).zs[0];
                    boolean bl = eCFieldElement4.isOne();
                    ECFieldElement eCFieldElement5 = null;
                    if (!bl && eCFieldElement4.equals(object)) {
                        object = eCFieldElement.subtract(eCFieldElement2);
                        eCFieldElement3 = ((ECFieldElement)object3).subtract(eCFieldElement3);
                        if (((ECFieldElement)object).isZero()) {
                            if (eCFieldElement3.isZero()) {
                                return ((Fp)object2).twice();
                            }
                            return eCFieldElementArray.getInfinity();
                        }
                        Object object4 = object;
                        object = ((ECFieldElement)object).square();
                        eCFieldElement = eCFieldElement.multiply((ECFieldElement)object);
                        object = eCFieldElement2.multiply((ECFieldElement)object);
                        object3 = eCFieldElement.subtract((ECFieldElement)object).multiply((ECFieldElement)object3);
                        object = eCFieldElement3.square().subtract(eCFieldElement).subtract((ECFieldElement)object);
                        eCFieldElement = eCFieldElement.subtract((ECFieldElement)object).multiply(eCFieldElement3).subtract((ECFieldElement)object3);
                        object3 = ((ECFieldElement)object4).multiply(eCFieldElement4);
                    } else {
                        if (!bl) {
                            ECFieldElement eCFieldElement6 = eCFieldElement4.square();
                            eCFieldElement2 = eCFieldElement6.multiply(eCFieldElement2);
                            eCFieldElement3 = eCFieldElement6.multiply(eCFieldElement4).multiply(eCFieldElement3);
                        }
                        boolean bl2 = ((ECFieldElement)object).isOne();
                        if (!bl2) {
                            ECFieldElement eCFieldElement7 = ((ECFieldElement)object).square();
                            eCFieldElement = eCFieldElement7.multiply(eCFieldElement);
                            object3 = eCFieldElement7.multiply((ECFieldElement)object).multiply((ECFieldElement)object3);
                        }
                        eCFieldElement2 = eCFieldElement.subtract(eCFieldElement2);
                        eCFieldElement3 = ((ECFieldElement)object3).subtract(eCFieldElement3);
                        if (eCFieldElement2.isZero()) {
                            if (eCFieldElement3.isZero()) {
                                return ((Fp)object2).twice();
                            }
                            return eCFieldElementArray.getInfinity();
                        }
                        ECFieldElement eCFieldElement8 = eCFieldElement2.square();
                        ECFieldElement eCFieldElement9 = eCFieldElement;
                        eCFieldElement = eCFieldElement8.multiply(eCFieldElement2);
                        ECFieldElement eCFieldElement10 = eCFieldElement8.multiply(eCFieldElement9);
                        ECFieldElement eCFieldElement11 = eCFieldElement10;
                        eCFieldElement11 = eCFieldElement3.square().add(eCFieldElement).subtract(((Fp)object2).two(eCFieldElement11));
                        eCFieldElement = eCFieldElement10.subtract(eCFieldElement11).multiplyMinusProduct(eCFieldElement3, eCFieldElement, (ECFieldElement)object3);
                        object3 = !bl ? eCFieldElement2.multiply(eCFieldElement4) : eCFieldElement2;
                        if (!bl2) {
                            object3 = object = ((ECFieldElement)object3).multiply((ECFieldElement)object);
                        }
                        if (object3 == eCFieldElement2) {
                            object = eCFieldElement11;
                            eCFieldElement5 = eCFieldElement8;
                        } else {
                            object = eCFieldElement11;
                        }
                    }
                    if (n == 4) {
                        object2 = ((Fp)object2).calculateJacobianModifiedW((ECFieldElement)object3, eCFieldElement5);
                        ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[2];
                        eCFieldElementArray2 = eCFieldElementArray3;
                        eCFieldElementArray3[0] = object3;
                        eCFieldElementArray3[1] = object2;
                    } else {
                        ECFieldElement[] eCFieldElementArray4 = new ECFieldElement[1];
                        eCFieldElementArray2 = eCFieldElementArray4;
                        eCFieldElementArray4[0] = object3;
                    }
                    return new Fp((ECCurve)eCFieldElementArray, (ECFieldElement)object, eCFieldElement, eCFieldElementArray2);
                }
                Object object5 = ((ECPoint)object2).zs[0];
                object = ((ECPoint)object).zs[0];
                boolean bl = ((ECFieldElement)object5).isOne();
                boolean bl3 = ((ECFieldElement)object).isOne();
                if (!bl) {
                    eCFieldElement3 = eCFieldElement3.multiply((ECFieldElement)object5);
                }
                if (!bl3) {
                    object3 = ((ECFieldElement)object3).multiply((ECFieldElement)object);
                }
                eCFieldElement3 = eCFieldElement3.subtract((ECFieldElement)object3);
                if (!bl) {
                    eCFieldElement2 = eCFieldElement2.multiply((ECFieldElement)object5);
                }
                if (!bl3) {
                    eCFieldElement = eCFieldElement.multiply((ECFieldElement)object);
                }
                eCFieldElement2 = eCFieldElement2.subtract(eCFieldElement);
                if (eCFieldElement2.isZero()) {
                    if (eCFieldElement3.isZero()) {
                        return ((Fp)object2).twice();
                    }
                    return eCFieldElementArray.getInfinity();
                }
                if (bl) {
                    object5 = object;
                } else if (!bl3) {
                    object5 = ((ECFieldElement)object5).multiply((ECFieldElement)object);
                }
                object = eCFieldElement2.square();
                ECFieldElement eCFieldElement12 = ((ECFieldElement)object).multiply(eCFieldElement2);
                ECFieldElement eCFieldElement13 = ((ECFieldElement)object).multiply(eCFieldElement);
                object = eCFieldElement13;
                object2 = eCFieldElement3.square().multiply((ECFieldElement)object5).subtract(eCFieldElement12).subtract(((Fp)object2).two((ECFieldElement)object));
                object = eCFieldElement2.multiply((ECFieldElement)object2);
                object2 = eCFieldElement13.subtract((ECFieldElement)object2).multiplyMinusProduct(eCFieldElement3, (ECFieldElement)object3, eCFieldElement12);
                object5 = eCFieldElement12.multiply((ECFieldElement)object5);
                ECFieldElement[] eCFieldElementArray5 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray6 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray6;
                eCFieldElementArray6[0] = object5;
                return new Fp((ECCurve)eCFieldElementArray5, (ECFieldElement)object, (ECFieldElement)object2, eCFieldElementArray);
            }
            object = eCFieldElement2.subtract(eCFieldElement);
            ECFieldElement eCFieldElement14 = eCFieldElement3.subtract((ECFieldElement)object3);
            if (((ECFieldElement)object).isZero()) {
                if (eCFieldElement14.isZero()) {
                    return ((Fp)object2).twice();
                }
                return eCFieldElementArray.getInfinity();
            }
            ECFieldElement eCFieldElement15 = eCFieldElement14.divide((ECFieldElement)object);
            object2 = eCFieldElement15.square().subtract(eCFieldElement).subtract(eCFieldElement2);
            object = eCFieldElement15.multiply(eCFieldElement.subtract((ECFieldElement)object2)).subtract((ECFieldElement)object3);
            return new Fp((ECCurve)eCFieldElementArray, (ECFieldElement)object2, (ECFieldElement)object);
        }

        @Override
        public ECPoint twice() {
            Object object;
            if (((ECPoint)object).isInfinity()) {
                return object;
            }
            Fp fp = object;
            ECFieldElement[] eCFieldElementArray = fp.getCurve();
            ECFieldElement eCFieldElement = fp.y;
            if (eCFieldElement.isZero()) {
                return eCFieldElementArray.getInfinity();
            }
            int n = eCFieldElementArray.getCoordinateSystem();
            ECFieldElement eCFieldElement2 = ((ECPoint)object).x;
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) {
                        if (n == 4) {
                            return ((Fp)object).twiceJacobianModified(true);
                        }
                        throw new IllegalStateException("unsupported coordinate system");
                    }
                    ECFieldElement[] eCFieldElementArray2 = ((ECPoint)object).zs[0];
                    boolean bl = eCFieldElementArray2.isOne();
                    ECFieldElement eCFieldElement3 = eCFieldElement.square();
                    ECFieldElement eCFieldElement4 = eCFieldElement3.square();
                    Object object2 = eCFieldElementArray.getA();
                    ECFieldElement eCFieldElement5 = ((ECFieldElement)object2).negate();
                    if (eCFieldElement5.toBigInteger().equals(BigInteger.valueOf(3L))) {
                        object2 = bl ? eCFieldElementArray2 : eCFieldElementArray2.square();
                        ECFieldElement eCFieldElement6 = eCFieldElement2;
                        eCFieldElement2 = ((Fp)object).three(eCFieldElement2.add((ECFieldElement)object2).multiply(eCFieldElement2.subtract((ECFieldElement)object2)));
                        eCFieldElement3 = ((Fp)object).four(eCFieldElement3.multiply(eCFieldElement6));
                    } else {
                        ECFieldElement eCFieldElement7 = ((Fp)object).three(eCFieldElement2.square());
                        if (bl) {
                            object2 = eCFieldElement7.add((ECFieldElement)object2);
                        } else if (!((ECFieldElement)object2).isZero()) {
                            ECFieldElement eCFieldElement8 = eCFieldElementArray2.square().square();
                            object2 = eCFieldElement5.bitLength() < ((ECFieldElement)object2).bitLength() ? eCFieldElement7.subtract(eCFieldElement8.multiply(eCFieldElement5)) : eCFieldElement7.add(eCFieldElement8.multiply((ECFieldElement)object2));
                        } else {
                            object2 = eCFieldElement7;
                        }
                        eCFieldElement3 = ((Fp)object).four(eCFieldElement2.multiply(eCFieldElement3));
                        eCFieldElement2 = object2;
                    }
                    Object object3 = object;
                    ECFieldElement eCFieldElement9 = eCFieldElement;
                    eCFieldElement = eCFieldElement2.square().subtract(((Fp)object).two(eCFieldElement3));
                    object = eCFieldElement3.subtract(eCFieldElement).multiply(eCFieldElement2).subtract(((Fp)object).eight(eCFieldElement4));
                    eCFieldElement2 = ((Fp)object3).two(eCFieldElement9);
                    if (!bl) {
                        eCFieldElement2 = eCFieldElement2.multiply((ECFieldElement)eCFieldElementArray2);
                    }
                    ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[1];
                    eCFieldElementArray2 = eCFieldElementArray3;
                    eCFieldElementArray3[0] = eCFieldElement2;
                    return new Fp((ECCurve)eCFieldElementArray, eCFieldElement, (ECFieldElement)object, eCFieldElementArray2);
                }
                ECFieldElement eCFieldElement10 = ((ECPoint)object).zs[0];
                boolean bl = eCFieldElement10.isOne();
                ECFieldElement eCFieldElement11 = eCFieldElementArray.getA();
                if (!eCFieldElement11.isZero() && !bl) {
                    eCFieldElement11 = eCFieldElement11.multiply(eCFieldElement10.square());
                }
                eCFieldElement11 = eCFieldElement11.add(((Fp)object).three(eCFieldElement2.square()));
                eCFieldElement10 = bl ? eCFieldElement : eCFieldElement.multiply(eCFieldElement10);
                eCFieldElement = bl ? eCFieldElement.square() : eCFieldElement10.multiply(eCFieldElement);
                ECFieldElement eCFieldElement12 = ((Fp)object).four(eCFieldElement2.multiply(eCFieldElement));
                eCFieldElement2 = eCFieldElement12;
                ECFieldElement eCFieldElement13 = eCFieldElement;
                eCFieldElement = eCFieldElement11.square().subtract(((Fp)object).two(eCFieldElement2));
                eCFieldElement2 = ((Fp)object).two(eCFieldElement10);
                ECFieldElement eCFieldElement14 = eCFieldElement.multiply(eCFieldElement2);
                ECFieldElement eCFieldElement15 = ((Fp)object).two(eCFieldElement13);
                eCFieldElement = eCFieldElement12.subtract(eCFieldElement).multiply(eCFieldElement11).subtract(((Fp)object).two(eCFieldElement15.square()));
                eCFieldElement2 = bl ? ((Fp)object).two(eCFieldElement15) : eCFieldElement2.square();
                object = ((Fp)object).two(eCFieldElement2).multiply(eCFieldElement10);
                ECFieldElement[] eCFieldElementArray4 = eCFieldElementArray;
                ECFieldElement[] eCFieldElementArray5 = new ECFieldElement[1];
                eCFieldElementArray = eCFieldElementArray5;
                eCFieldElementArray5[0] = object;
                return new Fp((ECCurve)eCFieldElementArray4, eCFieldElement14, eCFieldElement, eCFieldElementArray);
            }
            ECFieldElement eCFieldElement16 = ((Fp)object).three(eCFieldElement2.square()).add(((ECPoint)object).getCurve().getA()).divide(((Fp)object).two(eCFieldElement));
            object = eCFieldElement16.square().subtract(((Fp)object).two(eCFieldElement2));
            eCFieldElement = eCFieldElement16.multiply(eCFieldElement2.subtract((ECFieldElement)object)).subtract(eCFieldElement);
            return new Fp((ECCurve)eCFieldElementArray, (ECFieldElement)object, eCFieldElement);
        }

        @Override
        public ECPoint twicePlus(ECPoint object) {
            if (object3 == object) {
                return ((Fp)object3).threeTimes();
            }
            if (((ECPoint)object3).isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return ((Fp)object3).twice();
            }
            ECFieldElement eCFieldElement = ((ECPoint)object3).y;
            if (eCFieldElement.isZero()) {
                return object;
            }
            ECCurve eCCurve = ((ECPoint)object3).getCurve();
            int n = eCCurve.getCoordinateSystem();
            if (n != 0) {
                if (n != 4) {
                    return ((Fp)object3).twice().add((ECPoint)object);
                }
                return ((Fp)object3).twiceJacobianModified(false).add((ECPoint)object);
            }
            ECPoint eCPoint = object;
            object = ((ECPoint)object3).x;
            ECFieldElement eCFieldElement2 = eCPoint.x;
            ECFieldElement eCFieldElement3 = eCFieldElement2.subtract((ECFieldElement)object);
            ECFieldElement eCFieldElement4 = eCPoint.y.subtract(eCFieldElement);
            if (eCFieldElement3.isZero()) {
                if (eCFieldElement4.isZero()) {
                    return ((Fp)object3).threeTimes();
                }
                return object3;
            }
            ECFieldElement eCFieldElement5 = eCFieldElement3.square();
            ECFieldElement eCFieldElement6 = eCFieldElement4.square();
            eCFieldElement6 = eCFieldElement5.multiply(((Fp)object3).two((ECFieldElement)object).add(eCFieldElement2)).subtract(eCFieldElement6);
            if (eCFieldElement6.isZero()) {
                return eCCurve.getInfinity();
            }
            Object object2 = object;
            Fp fp = object3;
            ECFieldElement eCFieldElement7 = eCFieldElement6;
            Object object3 = eCFieldElement7.multiply(eCFieldElement3).invert();
            object = eCFieldElement7.multiply((ECFieldElement)object3).multiply(eCFieldElement4);
            object3 = fp.two(eCFieldElement).multiply(eCFieldElement5).multiply(eCFieldElement3).multiply((ECFieldElement)object3).subtract((ECFieldElement)object);
            object = ((ECFieldElement)object3).subtract((ECFieldElement)object).multiply(((ECFieldElement)object).add((ECFieldElement)object3)).add(eCFieldElement2);
            object3 = ((ECFieldElement)object2).subtract((ECFieldElement)object).multiply((ECFieldElement)object3).subtract(eCFieldElement);
            return new Fp(eCCurve, (ECFieldElement)object, (ECFieldElement)object3);
        }

        @Override
        public ECPoint threeTimes() {
            if (((ECPoint)object).isInfinity()) {
                return object;
            }
            ECFieldElement eCFieldElement = ((ECPoint)object).y;
            if (eCFieldElement.isZero()) {
                return object;
            }
            ECCurve eCCurve = ((ECPoint)object).getCurve();
            int n = eCCurve.getCoordinateSystem();
            if (n != 0) {
                if (n != 4) {
                    return ((Fp)object).twice().add((ECPoint)object);
                }
                return ((Fp)object).twiceJacobianModified(false).add((ECPoint)object);
            }
            Fp fp = object;
            ECFieldElement eCFieldElement2 = ((ECPoint)object).x;
            ECFieldElement eCFieldElement3 = fp.two(eCFieldElement);
            ECFieldElement eCFieldElement4 = eCFieldElement3.square();
            ECFieldElement eCFieldElement5 = fp.three(eCFieldElement2.square()).add(((ECPoint)object).getCurve().getA());
            ECFieldElement eCFieldElement6 = eCFieldElement5.square();
            eCFieldElement6 = fp.three(eCFieldElement2).multiply(eCFieldElement4).subtract(eCFieldElement6);
            if (eCFieldElement6.isZero()) {
                return ((ECPoint)object).getCurve().getInfinity();
            }
            ECFieldElement eCFieldElement7 = eCFieldElement2;
            ECFieldElement eCFieldElement8 = eCFieldElement6;
            Object object = eCFieldElement8.multiply(eCFieldElement3).invert();
            eCFieldElement3 = eCFieldElement8.multiply((ECFieldElement)object).multiply(eCFieldElement5);
            object = eCFieldElement4.square().multiply((ECFieldElement)object).subtract(eCFieldElement3);
            eCFieldElement2 = ((ECFieldElement)object).subtract(eCFieldElement3).multiply(eCFieldElement3.add((ECFieldElement)object)).add(eCFieldElement2);
            object = eCFieldElement7.subtract(eCFieldElement2).multiply((ECFieldElement)object).subtract(eCFieldElement);
            return new Fp(eCCurve, eCFieldElement2, (ECFieldElement)object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ECPoint timesPow2(int n) {
            ECFieldElement[] eCFieldElementArray;
            if (n < 0) throw new IllegalArgumentException("'e' cannot be negative");
            if (n == 0 || eCFieldElementArray.isInfinity()) return eCFieldElementArray;
            if (n == 1) {
                return eCFieldElementArray.twice();
            }
            Fp fp = eCFieldElementArray;
            ECFieldElement[] eCFieldElementArray2 = fp.getCurve();
            ECFieldElement eCFieldElement = fp.y;
            if (eCFieldElement.isZero()) {
                return eCFieldElementArray2.getInfinity();
            }
            Fp fp2 = eCFieldElementArray;
            int n2 = eCFieldElementArray2.getCoordinateSystem();
            ECFieldElement eCFieldElement2 = eCFieldElementArray2.getA();
            ECFieldElement eCFieldElement3 = fp2.x;
            Object object = fp2.zs;
            object = fp2.zs.length < 1 ? eCFieldElementArray2.fromBigInteger(ECConstants.ONE) : object[0];
            if (!((ECFieldElement)object).isOne() && n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 4) throw new IllegalStateException("unsupported coordinate system");
                        eCFieldElement2 = eCFieldElementArray.getJacobianModifiedW();
                    } else {
                        eCFieldElement2 = eCFieldElementArray.calculateJacobianModifiedW((ECFieldElement)object, null);
                    }
                } else {
                    ECFieldElement eCFieldElement4 = eCFieldElement;
                    eCFieldElement = ((ECFieldElement)object).square();
                    eCFieldElement3 = eCFieldElement3.multiply((ECFieldElement)object);
                    eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                    eCFieldElement = eCFieldElementArray.calculateJacobianModifiedW((ECFieldElement)object, eCFieldElement);
                    ECFieldElement eCFieldElement5 = eCFieldElement2;
                    eCFieldElement2 = eCFieldElement;
                    eCFieldElement = eCFieldElement5;
                }
            }
            for (int k = 0; k < n; ++k) {
                if (eCFieldElement.isZero()) {
                    return eCFieldElementArray2.getInfinity();
                }
                Fp fp3 = eCFieldElementArray;
                ECFieldElement eCFieldElement6 = eCFieldElement3;
                eCFieldElement3 = eCFieldElementArray.three(eCFieldElement3.square());
                ECFieldElement eCFieldElement7 = eCFieldElementArray.two(eCFieldElement);
                eCFieldElement = eCFieldElement7.multiply(eCFieldElement);
                ECFieldElement eCFieldElement8 = fp3.two(eCFieldElement6.multiply(eCFieldElement));
                eCFieldElement = fp3.two(eCFieldElement.square());
                if (!eCFieldElement2.isZero()) {
                    eCFieldElement3 = eCFieldElement3.add(eCFieldElement2);
                    eCFieldElement2 = eCFieldElementArray.two(eCFieldElement.multiply(eCFieldElement2));
                }
                ECFieldElement eCFieldElement9 = eCFieldElement3;
                eCFieldElement3 = eCFieldElement3.square().subtract(eCFieldElementArray.two(eCFieldElement8));
                eCFieldElement = eCFieldElement9.multiply(eCFieldElement8.subtract(eCFieldElement3)).subtract(eCFieldElement);
                object = ((ECFieldElement)object).isOne() ? eCFieldElement7 : eCFieldElement7.multiply((ECFieldElement)object);
            }
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 4) throw new IllegalStateException("unsupported coordinate system");
                        ECFieldElement[] eCFieldElementArray3 = new ECFieldElement[2];
                        eCFieldElementArray = eCFieldElementArray3;
                        eCFieldElementArray3[0] = object;
                        eCFieldElementArray3[1] = eCFieldElement2;
                        return new Fp((ECCurve)eCFieldElementArray2, eCFieldElement3, eCFieldElement, eCFieldElementArray);
                    }
                    ECFieldElement[] eCFieldElementArray4 = new ECFieldElement[1];
                    eCFieldElementArray = eCFieldElementArray4;
                    eCFieldElementArray4[0] = object;
                    return new Fp((ECCurve)eCFieldElementArray2, eCFieldElement3, eCFieldElement, eCFieldElementArray);
                }
                Object object2 = object;
                eCFieldElementArray = eCFieldElement3.multiply((ECFieldElement)object);
                ECFieldElement eCFieldElement10 = ((ECFieldElement)object2).multiply(((ECFieldElement)object2).square());
                ECFieldElement[] eCFieldElementArray5 = eCFieldElementArray2;
                ECFieldElement[] eCFieldElementArray6 = new ECFieldElement[1];
                eCFieldElementArray2 = eCFieldElementArray6;
                eCFieldElementArray6[0] = eCFieldElement10;
                return new Fp((ECCurve)eCFieldElementArray5, (ECFieldElement)eCFieldElementArray, eCFieldElement, eCFieldElementArray2);
            }
            eCFieldElementArray = ((ECFieldElement)object).invert();
            ECFieldElement eCFieldElement11 = eCFieldElementArray.square();
            eCFieldElementArray = eCFieldElement11.multiply((ECFieldElement)eCFieldElementArray);
            eCFieldElement11 = eCFieldElement3.multiply(eCFieldElement11);
            eCFieldElementArray = eCFieldElement.multiply((ECFieldElement)eCFieldElementArray);
            return new Fp((ECCurve)eCFieldElementArray2, eCFieldElement11, (ECFieldElement)eCFieldElementArray);
        }

        public ECFieldElement two(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2 = eCFieldElement;
            return eCFieldElement2.add(eCFieldElement2);
        }

        public ECFieldElement three(ECFieldElement eCFieldElement) {
            return this.two(eCFieldElement).add(eCFieldElement);
        }

        public ECFieldElement four(ECFieldElement eCFieldElement) {
            Fp fp = this;
            return fp.two(fp.two(eCFieldElement));
        }

        public ECFieldElement eight(ECFieldElement eCFieldElement) {
            Fp fp = this;
            return fp.four(fp.two(eCFieldElement));
        }

        public ECFieldElement doubleProductFromSquares(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3, ECFieldElement eCFieldElement4) {
            return eCFieldElement.add(eCFieldElement2).square().subtract(eCFieldElement3).subtract(eCFieldElement4);
        }

        @Override
        public ECPoint negate() {
            Object object;
            if (((ECPoint)object).isInfinity()) {
                return object;
            }
            Object object2 = ((ECPoint)object).getCurve();
            if (((ECCurve)object2).getCoordinateSystem() != 0) {
                ECCurve eCCurve = object2;
                Fp fp = object;
                object = fp.x;
                object2 = fp.y.negate();
                ECFieldElement[] eCFieldElementArray = fp.zs;
                return new Fp(eCCurve, (ECFieldElement)object, (ECFieldElement)object2, eCFieldElementArray);
            }
            Fp fp = object;
            object = fp.x;
            return new Fp((ECCurve)object2, (ECFieldElement)object, fp.y.negate());
        }

        public ECFieldElement calculateJacobianModifiedW(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            if (!((ECFieldElement)(this = ((ECPoint)this).getCurve().getA())).isZero() && !eCFieldElement.isOne()) {
                if (eCFieldElement2 == null) {
                    eCFieldElement2 = eCFieldElement.square();
                }
                eCFieldElement = eCFieldElement2.square();
                eCFieldElement2 = ((ECFieldElement)this).negate();
                return eCFieldElement2.bitLength() < ((ECFieldElement)this).bitLength() ? eCFieldElement.multiply(eCFieldElement2).negate() : eCFieldElement.multiply((ECFieldElement)this);
            }
            return this;
        }

        public ECFieldElement getJacobianModifiedW() {
            ECFieldElement[] eCFieldElementArray = this.zs;
            ECFieldElement eCFieldElement = this.zs[1];
            if (eCFieldElement == null) {
                eCFieldElementArray[1] = eCFieldElement = this.calculateJacobianModifiedW(eCFieldElementArray[0], null);
            }
            return eCFieldElement;
        }

        public Fp twiceJacobianModified(boolean bl) {
            Fp fp = eCCurve;
            ECFieldElement eCFieldElement = fp.x;
            ECFieldElement eCFieldElement2 = fp.y;
            ECFieldElement[] eCFieldElementArray = fp.zs[0];
            ECFieldElement eCFieldElement3 = fp.getJacobianModifiedW();
            ECFieldElement eCFieldElement4 = fp.three(eCFieldElement.square()).add(eCFieldElement3);
            ECFieldElement eCFieldElement5 = eCFieldElement4;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            eCFieldElement = ((Fp)((Object)eCCurve)).two(eCFieldElement2);
            eCFieldElement2 = eCFieldElement.multiply(eCFieldElement2);
            ECFieldElement eCFieldElement7 = ((Fp)((Object)eCCurve)).two(eCFieldElement6.multiply(eCFieldElement2));
            ECFieldElement eCFieldElement8 = eCFieldElement2;
            eCFieldElement2 = eCFieldElement5.square().subtract(((Fp)((Object)eCCurve)).two(eCFieldElement7));
            eCFieldElement5 = ((Fp)((Object)eCCurve)).two(eCFieldElement8.square());
            eCFieldElement7 = eCFieldElement4.multiply(eCFieldElement7.subtract(eCFieldElement2)).subtract(eCFieldElement5);
            eCFieldElement3 = bl ? ((Fp)((Object)eCCurve)).two(eCFieldElement5.multiply(eCFieldElement3)) : null;
            if (!eCFieldElementArray.isOne()) {
                eCFieldElement = eCFieldElement.multiply((ECFieldElement)eCFieldElementArray);
            }
            ECCurve eCCurve = ((ECPoint)((Object)eCCurve)).getCurve();
            ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[2];
            eCFieldElementArray = eCFieldElementArray2;
            eCFieldElementArray2[0] = eCFieldElement;
            eCFieldElementArray2[1] = eCFieldElement3;
            return new Fp(eCCurve, eCFieldElement2, eCFieldElement7, eCFieldElementArray);
        }
    }

    public static abstract class AbstractFp
    extends ECPoint {
        public AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public boolean getCompressionYTilde() {
            return this.getAffineYCoord().testBitZero();
        }

        @Override
        public boolean satisfiesCurveEquation() {
            AbstractFp abstractFp = object2;
            ECFieldElement eCFieldElement = abstractFp.x;
            AbstractFp abstractFp2 = object2;
            Object object = abstractFp2.curve.getA();
            ECFieldElement eCFieldElement2 = abstractFp2.curve.getB();
            ECFieldElement eCFieldElement3 = abstractFp.y.square();
            switch (abstractFp.getCurveCoordinateSystem()) {
                default: {
                    throw new IllegalStateException("unsupported coordinate system");
                }
                case 2: 
                case 3: 
                case 4: {
                    Object object2 = ((ECPoint)object2).zs[0];
                    if (((ECFieldElement)object2).isOne()) break;
                    ECFieldElement eCFieldElement4 = object;
                    ECFieldElement eCFieldElement5 = ((ECFieldElement)object2).square();
                    object2 = eCFieldElement5.square();
                    object = eCFieldElement5.multiply((ECFieldElement)object2);
                    object2 = eCFieldElement4.multiply((ECFieldElement)object2);
                    eCFieldElement2 = eCFieldElement2.multiply((ECFieldElement)object);
                    object = object2;
                    break;
                }
                case 1: {
                    Object object2 = ((ECPoint)object2).zs[0];
                    if (((ECFieldElement)object2).isOne()) break;
                    ECFieldElement eCFieldElement6 = eCFieldElement2;
                    ECFieldElement eCFieldElement7 = object;
                    Object object3 = object2;
                    object = ((ECFieldElement)object3).square();
                    eCFieldElement2 = ((ECFieldElement)object3).multiply((ECFieldElement)object);
                    eCFieldElement3 = eCFieldElement3.multiply((ECFieldElement)object2);
                    object = eCFieldElement7.multiply((ECFieldElement)object);
                    eCFieldElement2 = eCFieldElement6.multiply(eCFieldElement2);
                }
                case 0: 
            }
            return eCFieldElement3.equals(eCFieldElement.square().add((ECFieldElement)object).multiply(eCFieldElement).add(eCFieldElement2));
        }

        @Override
        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(eCPoint.negate());
        }
    }
}

