/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser;

import com.fis.ekyc.nfc.build_in.eidparser.APDULevelBACCapable;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelEACCACapable;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelPACECapable;
import com.fis.ekyc.nfc.build_in.eidparser.AbstractMRTDCardService;
import com.fis.ekyc.nfc.build_in.eidparser.AccessKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.BACKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.DefaultFileSystem;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CVCPrincipal;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CardVerifiableCertificate;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AAAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AAProtocol;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AAResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.BACAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.BACProtocol;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.BACResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACCAAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACCAProtocol;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACCAResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACTAAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACTAProtocol;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.EACTAResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEProtocol;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.PACEResult;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.ReadBinaryAPDUSender;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUEvent;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUListener;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardFileInputStream;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardService;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CommandAPDU;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.ResponseAPDU;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class IdCardService
extends AbstractMRTDCardService {
    public static final byte NO_PACE_KEY_REFERENCE = 0;
    public static final byte MRZ_PACE_KEY_REFERENCE = 1;
    public static final byte CAN_PACE_KEY_REFERENCE = 2;
    public static final byte PIN_PACE_KEY_REFERENCE = 3;
    public static final byte PUK_PACE_KEY_REFERENCE = 4;
    private static final Logger LOGGER = Logger.getLogger("com.htc.sdk.jmrtd");
    public static final short EF_CARD_ACCESS = 284;
    public static final short EF_CARD_SECURITY = 285;
    public static final short EF_DG1 = 257;
    public static final short EF_DG2 = 258;
    public static final short EF_DG3 = 259;
    public static final short EF_DG4 = 260;
    public static final short EF_DG5 = 261;
    public static final short EF_DG6 = 262;
    public static final short EF_DG7 = 263;
    public static final short EF_DG8 = 264;
    public static final short EF_DG9 = 265;
    public static final short EF_DG10 = 266;
    public static final short EF_DG11 = 267;
    public static final short EF_DG12 = 268;
    public static final short EF_DG13 = 269;
    public static final short EF_DG14 = 270;
    public static final short EF_DG15 = 271;
    public static final short EF_DG16 = 272;
    public static final short EF_SOD = 285;
    public static final short EF_COM = 286;
    public static final short EF_CVCA = 284;
    public static final byte SFI_CARD_ACCESS = 28;
    public static final byte SFI_CARD_SECURITY = 29;
    public static final byte SFI_DG1 = 1;
    public static final byte SFI_DG2 = 2;
    public static final byte SFI_DG3 = 3;
    public static final byte SFI_DG4 = 4;
    public static final byte SFI_DG5 = 5;
    public static final byte SFI_DG6 = 6;
    public static final byte SFI_DG7 = 7;
    public static final byte SFI_DG8 = 8;
    public static final byte SFI_DG9 = 9;
    public static final byte SFI_DG10 = 10;
    public static final byte SFI_DG11 = 11;
    public static final byte SFI_DG12 = 12;
    public static final byte SFI_DG13 = 13;
    public static final byte SFI_DG14 = 14;
    public static final byte SFI_DG15 = 15;
    public static final byte SFI_DG16 = 16;
    public static final byte SFI_COM = 30;
    public static final byte SFI_SOD = 29;
    public static final byte SFI_CVCA = 28;
    public static final int DEFAULT_MAX_BLOCKSIZE = 223;
    public static final int NORMAL_MAX_TRANCEIVE_LENGTH = 256;
    public static final int EXTENDED_MAX_TRANCEIVE_LENGTH = 65536;
    public static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 2, 71, 16, 1};
    private int maxBlockSize;
    private boolean isOpen;
    private SecureMessagingWrapper wrapper;
    private int maxTranceiveLengthForSecureMessaging;
    private int maxTranceiveLengthForPACEProtocol;
    private boolean shouldCheckMAC;
    private boolean isAppletSelected;
    private DefaultFileSystem rootFileSystem;
    private DefaultFileSystem appletFileSystem;
    private BACAPDUSender bacSender;
    private PACEAPDUSender paceSender;
    private AAAPDUSender aaSender;
    private EACCAAPDUSender eacCASender;
    private EACTAAPDUSender eacTASender;
    private ReadBinaryAPDUSender readBinarySender;
    private CardService service;

    public IdCardService(CardService cardService, int n, int n2, boolean bl, boolean bl2) {
        this(cardService, 256, n, n2, bl, bl2);
    }

    public IdCardService(CardService cardService, int n, int n2, int n3, boolean bl, boolean bl2) {
        IdCardService idCardService = this;
        IdCardService idCardService2 = this;
        idCardService2.service = cardService;
        idCardService2.bacSender = new BACAPDUSender(cardService);
        idCardService2.paceSender = new PACEAPDUSender(cardService);
        idCardService2.aaSender = new AAAPDUSender(cardService);
        idCardService2.eacCASender = new EACCAAPDUSender(cardService);
        idCardService2.eacTASender = new EACTAAPDUSender(cardService);
        idCardService2.readBinarySender = new ReadBinaryAPDUSender(cardService);
        this.maxTranceiveLengthForPACEProtocol = n;
        this.maxTranceiveLengthForSecureMessaging = n2;
        this.maxBlockSize = n3;
        idCardService.shouldCheckMAC = bl2;
        idCardService.isAppletSelected = false;
        idCardService.isOpen = false;
        idCardService.rootFileSystem = new DefaultFileSystem(this.readBinarySender, false);
        idCardService.appletFileSystem = new DefaultFileSystem(this.readBinarySender, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.isOpen()) {
            return;
        }
        IdCardService idCardService = this;
        synchronized (idCardService) {
            idCardService.service.open();
            idCardService.isOpen = true;
            return;
        }
    }

    @Override
    public void sendSelectApplet(boolean bl) {
        if (this.isAppletSelected) {
            LOGGER.info("Re-selecting ICAO applet");
        }
        if (bl) {
            this.readBinarySender.sendSelectApplet(this.wrapper, APPLET_AID);
        } else {
            this.readBinarySender.sendSelectApplet(null, APPLET_AID);
        }
        this.isAppletSelected = true;
    }

    @Override
    public void sendSelectMF() {
        this.readBinarySender.sendSelectMF();
        this.wrapper = null;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized BACResult doBAC(AccessKeySpec object) {
        if (object instanceof BACKeySpec) {
            IdCardService idCardService = secureMessagingWrapper;
            object = idCardService.bacSender;
            int n = idCardService.maxTranceiveLengthForSecureMessaging;
            boolean bl = idCardService.shouldCheckMAC;
            object = new BACProtocol((APDULevelBACCapable)object, n, bl).doBAC((AccessKeySpec)object);
            IdCardService idCardService2 = secureMessagingWrapper;
            SecureMessagingWrapper secureMessagingWrapper = ((BACResult)object).getWrapper();
            idCardService2.wrapper = secureMessagingWrapper;
            idCardService2.appletFileSystem.setWrapper(secureMessagingWrapper);
            return object;
        }
        throw new IllegalArgumentException("Unsupported key type");
    }

    @Override
    public synchronized BACResult doBAC(SecretKey object, SecretKey secretKey) {
        IdCardService idCardService = secureMessagingWrapper;
        object = idCardService.bacSender;
        int n = idCardService.maxTranceiveLengthForSecureMessaging;
        boolean bl = idCardService.shouldCheckMAC;
        object = new BACProtocol((APDULevelBACCapable)object, n, bl).doBAC((SecretKey)object, secretKey);
        IdCardService idCardService2 = secureMessagingWrapper;
        SecureMessagingWrapper secureMessagingWrapper = ((BACResult)object).getWrapper();
        idCardService2.wrapper = secureMessagingWrapper;
        idCardService2.appletFileSystem.setWrapper(secureMessagingWrapper);
        return object;
    }

    @Override
    public synchronized PACEResult doPACE(AccessKeySpec object, String string2, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger) {
        IdCardService idCardService = secureMessagingWrapper2;
        object = idCardService.paceSender;
        SecureMessagingWrapper secureMessagingWrapper = idCardService.wrapper;
        int n = idCardService.maxTranceiveLengthForPACEProtocol;
        int n2 = idCardService.maxTranceiveLengthForSecureMessaging;
        boolean bl = idCardService.shouldCheckMAC;
        object = new PACEProtocol((APDULevelPACECapable)object, secureMessagingWrapper, n, n2, bl).doPACE((AccessKeySpec)object, string2, algorithmParameterSpec, bigInteger);
        IdCardService idCardService2 = secureMessagingWrapper2;
        SecureMessagingWrapper secureMessagingWrapper2 = ((PACEResult)object).getWrapper();
        idCardService2.wrapper = secureMessagingWrapper2;
        idCardService2.appletFileSystem.setWrapper(secureMessagingWrapper2);
        return object;
    }

    @Override
    public synchronized EACCAResult doEACCA(BigInteger object, String string2, String string3, PublicKey publicKey) {
        IdCardService idCardService = secureMessagingWrapper2;
        object = idCardService.eacCASender;
        SecureMessagingWrapper secureMessagingWrapper = idCardService.getWrapper();
        int n = idCardService.maxTranceiveLengthForSecureMessaging;
        boolean bl = idCardService.shouldCheckMAC;
        object = new EACCAProtocol((APDULevelEACCACapable)object, secureMessagingWrapper, n, bl).doCA((BigInteger)object, string2, string3, publicKey);
        IdCardService idCardService2 = secureMessagingWrapper2;
        SecureMessagingWrapper secureMessagingWrapper2 = ((EACCAResult)object).getWrapper();
        idCardService2.wrapper = secureMessagingWrapper2;
        idCardService2.appletFileSystem.setWrapper(secureMessagingWrapper2);
        return object;
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string2, EACCAResult eACCAResult, String string3) {
        IdCardService idCardService = eACTAAPDUSender;
        EACTAAPDUSender eACTAAPDUSender = idCardService.eacTASender;
        return new EACTAProtocol(eACTAAPDUSender, idCardService.getWrapper()).doEACTA(cVCPrincipal, list, privateKey, string2, eACCAResult, string3);
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string2, EACCAResult eACCAResult, PACEResult pACEResult) {
        IdCardService idCardService = eACTAAPDUSender;
        EACTAAPDUSender eACTAAPDUSender = idCardService.eacTASender;
        return new EACTAProtocol(eACTAAPDUSender, idCardService.getWrapper()).doTA(cVCPrincipal, list, privateKey, string2, eACCAResult, pACEResult);
    }

    @Override
    public AAResult doAA(PublicKey publicKey, String string2, String string3, byte[] byArray) {
        IdCardService idCardService = aAAPDUSender;
        AAAPDUSender aAAPDUSender = idCardService.aaSender;
        return new AAProtocol(aAAPDUSender, idCardService.getWrapper()).doAA(publicKey, string2, string3, byArray);
    }

    @Override
    public void close() {
        try {
            this.service.close();
            this.wrapper = null;
            this.isOpen = false;
            return;
        }
        catch (Throwable throwable) {
            this.isOpen = false;
            throw throwable;
        }
    }

    public int getMaxTranceiveLength() {
        return this.maxTranceiveLengthForSecureMessaging;
    }

    @Override
    public SecureMessagingWrapper getWrapper() {
        SecureMessagingWrapper secureMessagingWrapper = (SecureMessagingWrapper)this.appletFileSystem.getWrapper();
        if (secureMessagingWrapper != null && secureMessagingWrapper.getSendSequenceCounter() > this.wrapper.getSendSequenceCounter()) {
            this.wrapper = secureMessagingWrapper;
        }
        return this.wrapper;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) {
        return this.service.transmit(commandAPDU);
    }

    @Override
    public byte[] getATR() {
        return this.service.getATR();
    }

    @Override
    public boolean isConnectionLost(Exception exception) {
        return this.service.isConnectionLost(exception);
    }

    public boolean shouldCheckMAC() {
        return this.shouldCheckMAC;
    }

    @Override
    @Deprecated
    public synchronized CardFileInputStream getInputStream(short s) {
        return this.getInputStream(s, this.maxBlockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CardFileInputStream getInputStream(short s, int n) {
        if (!this.isAppletSelected) {
            IdCardService idCardService = this;
            DefaultFileSystem defaultFileSystem = idCardService.rootFileSystem;
            synchronized (defaultFileSystem) {
                idCardService.rootFileSystem.selectFile(s);
                return new CardFileInputStream(n, this.rootFileSystem);
            }
        }
        IdCardService idCardService = this;
        DefaultFileSystem defaultFileSystem = idCardService.appletFileSystem;
        synchronized (defaultFileSystem) {
            idCardService.appletFileSystem.selectFile(s);
            return new CardFileInputStream(n, this.appletFileSystem);
        }
    }

    @Override
    public int getMaxReadBinaryLength() {
        DefaultFileSystem defaultFileSystem = ((IdCardService)((Object)defaultFileSystem)).appletFileSystem;
        if (defaultFileSystem == null) {
            return 256;
        }
        return defaultFileSystem.getMaxReadBinaryLength();
    }

    @Override
    public void addAPDUListener(APDUListener aPDUListener) {
        this.service.addAPDUListener(aPDUListener);
    }

    @Override
    public void removeAPDUListener(APDUListener aPDUListener) {
        this.service.removeAPDUListener(aPDUListener);
    }

    @Override
    public Collection<APDUListener> getAPDUListeners() {
        return this.service.getAPDUListeners();
    }

    @Override
    public void notifyExchangedAPDU(APDUEvent aPDUEvent) {
        if ((iterator = ((IdCardService)((Object)iterator)).getAPDUListeners()) != null && !iterator.isEmpty()) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((APDUListener)iterator.next()).exchangedAPDU(aPDUEvent);
            }
            return;
        }
    }
}

