/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractListInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.IrisImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class IrisBiometricSubtypeInfo
extends AbstractListInfo<IrisImageInfo> {
    private static final long serialVersionUID = -6588640634764878039L;
    public static final int EYE_UNDEF = 0;
    public static final int EYE_RIGHT = 1;
    public static final int EYE_LEFT = 2;
    private int imageFormat;
    private int biometricSubtype;

    public IrisBiometricSubtypeInfo(int n, int n2, List<IrisImageInfo> list) {
        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo = this;
        irisBiometricSubtypeInfo.biometricSubtype = n;
        irisBiometricSubtypeInfo.imageFormat = n2;
        irisBiometricSubtypeInfo.addAll(list);
    }

    public IrisBiometricSubtypeInfo(InputStream inputStream, int n) {
        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo = this;
        irisBiometricSubtypeInfo.imageFormat = n;
        irisBiometricSubtypeInfo.readObject(inputStream);
    }

    private static String biometricSubtypeToString(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    return "Left eye";
                }
                throw new NumberFormatException(h.a(n, b.a("Unknown biometric subtype: ")));
            }
            return "Right eye";
        }
        return "Undefined";
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.biometricSubtype = dataInputStream.readUnsignedByte();
        int n = dataInputStream.readUnsignedShort();
        for (int k = 0; k < n; ++k) {
            IrisImageInfo irisImageInfo;
            IrisImageInfo irisImageInfo2 = irisImageInfo;
            new IrisImageInfo(inputStream, this.imageFormat).getRecordLength();
            this.add(irisImageInfo2);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        ((DataOutputStream)outputStream).writeByte(((IrisBiometricSubtypeInfo)((Object)iterator)).biometricSubtype & 0xFF);
        List list = ((AbstractListInfo)((Object)iterator)).getSubRecords();
        ((DataOutputStream)outputStream).writeShort(list.size() & 0xFFFF);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IrisImageInfo)iterator.next()).writeObject(outputStream);
        }
    }

    public long getRecordLength() {
        long l = 3L;
        Iterator iterator = ((AbstractListInfo)((Object)iterator)).getSubRecords().iterator();
        while (iterator.hasNext()) {
            l = ((IrisImageInfo)iterator.next()).getRecordLength() + l;
        }
        return l;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.biometricSubtype) * 31 + this.imageFormat;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (IrisBiometricSubtypeInfo)object;
        return this.biometricSubtype == ((IrisBiometricSubtypeInfo)object).biometricSubtype && this.imageFormat == ((IrisBiometricSubtypeInfo)object).imageFormat;
    }

    public String toString() {
        return b.a("IrisBiometricSubtypeInfo [biometric subtype: ").append(IrisBiometricSubtypeInfo.biometricSubtypeToString(this.biometricSubtype)).append(", imageCount = ").append(this.getSubRecords().size()).append("]").toString();
    }

    public int getBiometricSubtype() {
        return this.biometricSubtype;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public List<IrisImageInfo> getIrisImageInfos() {
        return this.getSubRecords();
    }

    public void addIrisImageInfo(IrisImageInfo irisImageInfo) {
        this.add(irisImageInfo);
    }

    public void removeIrisImageInfo(int n) {
        this.remove(n);
    }
}

