/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERIA5String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.Evidence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.MetaData;

public class TimeStampedData
extends ASN1Object {
    private ASN1Integer version;
    private DERIA5String dataUri;
    private MetaData metaData;
    private ASN1OctetString content;
    private Evidence temporalEvidence;

    public TimeStampedData(DERIA5String dERIA5String, MetaData metaData, ASN1OctetString aSN1OctetString, Evidence evidence) {
        ASN1Integer aSN1Integer;
        ASN1Object aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(1L);
        v1.version = aSN1Object;
        v1.dataUri = dERIA5String;
        v1.metaData = metaData;
        v1.content = aSN1OctetString;
        v1.temporalEvidence = evidence;
    }

    private TimeStampedData(ASN1Sequence aSN1Sequence) {
        this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        int n = 1;
        if (aSN1Sequence.getObjectAt(1) instanceof DERIA5String) {
            int n2 = n;
            n = 2;
            this.dataUri = DERIA5String.getInstance(aSN1Sequence.getObjectAt(n2));
        }
        if (aSN1Sequence.getObjectAt(n) instanceof MetaData || aSN1Sequence.getObjectAt(n) instanceof ASN1Sequence) {
            this.metaData = MetaData.getInstance(aSN1Sequence.getObjectAt(n++));
        }
        if (aSN1Sequence.getObjectAt(n) instanceof ASN1OctetString) {
            this.content = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n++));
        }
        this.temporalEvidence = Evidence.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public static TimeStampedData getInstance(Object object) {
        if (object != null && !(object instanceof TimeStampedData)) {
            return new TimeStampedData(ASN1Sequence.getInstance(object));
        }
        return (TimeStampedData)object;
    }

    public DERIA5String getDataUri() {
        return this.dataUri;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ASN1OctetString getContent() {
        return this.content;
    }

    public Evidence getTemporalEvidence() {
        return this.temporalEvidence;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector.add(this.version);
        ASN1Object aSN1Object = this.dataUri;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.metaData) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.content) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        aSN1EncodableVector2.add(this.temporalEvidence);
        return new BERSequence(aSN1EncodableVector2);
    }
}

