/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.commitments;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Commitment;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Committer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GeneralHashCommitter
implements Committer {
    private final Digest digest;
    private final int byteLength;
    private final SecureRandom random;

    public GeneralHashCommitter(ExtendedDigest extendedDigest, SecureRandom secureRandom) {
        this.digest = extendedDigest;
        this.byteLength = extendedDigest.getByteLength();
        this.random = secureRandom;
    }

    private byte[] calculateCommitment(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.digest.getDigestSize()];
        GeneralHashCommitter generalHashCommitter = this;
        generalHashCommitter.digest.update(byArray, 0, byArray.length);
        generalHashCommitter.digest.update(byArray2, 0, byArray2.length);
        generalHashCommitter.digest.update((byte)(byArray2.length >>> 8));
        generalHashCommitter.digest.update((byte)byArray2.length);
        generalHashCommitter.digest.doFinal(byArray3, 0);
        return byArray3;
    }

    @Override
    public Commitment commit(byte[] byArray) {
        int n = this.byteLength;
        if (byArray.length <= n / 2) {
            byte[] byArray2 = new byte[n - byArray.length];
            this.random.nextBytes(byArray2);
            return new Commitment(byArray2, this.calculateCommitment(byArray2, byArray));
        }
        throw new DataLengthException("Message to be committed to too large for digest.");
    }

    @Override
    public boolean isRevealed(Commitment commitment, byte[] byArray) {
        if (byArray.length + commitment.getSecret().length == ((GeneralHashCommitter)object).byteLength) {
            Object object = ((GeneralHashCommitter)object).calculateCommitment(commitment.getSecret(), byArray);
            return Arrays.constantTimeAreEqual(commitment.getCommitment(), (byte[])object);
        }
        throw new DataLengthException("Message and witness secret lengths do not match.");
    }
}

