/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA256Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 32;
    public static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X;
    private int xOff;

    public SHA256Digest() {
        SHA256Digest sHA256Digest = this;
        sHA256Digest.X = new int[64];
        sHA256Digest.reset();
    }

    public SHA256Digest(SHA256Digest sHA256Digest) {
        super(sHA256Digest);
        this.X = new int[64];
        this.copyIn(sHA256Digest);
    }

    private void copyIn(SHA256Digest sHA256Digest) {
        SHA256Digest sHA256Digest2 = object;
        SHA256Digest sHA256Digest3 = sHA256Digest;
        super.copyIn(sHA256Digest);
        ((SHA256Digest)object).H1 = sHA256Digest.H1;
        ((SHA256Digest)object).H2 = sHA256Digest.H2;
        ((SHA256Digest)object).H3 = sHA256Digest.H3;
        ((SHA256Digest)object).H4 = sHA256Digest.H4;
        ((SHA256Digest)object).H5 = sHA256Digest.H5;
        ((SHA256Digest)object).H6 = sHA256Digest.H6;
        ((SHA256Digest)object).H7 = sHA256Digest.H7;
        ((SHA256Digest)object).H8 = sHA256Digest.H8;
        Object object = ((SHA256Digest)object).X;
        int n = sHA256Digest3.X.length;
        System.arraycopy(sHA256Digest3.X, 0, object, 0, n);
        sHA256Digest2.xOff = sHA256Digest3.xOff;
    }

    public SHA256Digest(byte[] byArray) {
        super(byArray);
        this.X = new int[64];
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.H5 = Pack.bigEndianToInt(byArray, 32);
        this.H6 = Pack.bigEndianToInt(byArray, 36);
        this.H7 = Pack.bigEndianToInt(byArray, 40);
        this.H8 = Pack.bigEndianToInt(byArray, 44);
        this.xOff = Pack.bigEndianToInt(byArray, 48);
        for (int k = 0; k != this.xOff; ++k) {
            this.X[k] = Pack.bigEndianToInt(byArray, k * 4 + 52);
        }
    }

    private static int Ch(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private static int Maj(int n, int n2, int n3) {
        return n & n2 | n3 & (n ^ n2);
    }

    private static int Sum0(int n) {
        return (n >>> 2 | n << 30) ^ (n >>> 13 | n << 19) ^ (n >>> 22 | n << 10);
    }

    private static int Sum1(int n) {
        return (n >>> 6 | n << 26) ^ (n >>> 11 | n << 21) ^ (n >>> 25 | n << 7);
    }

    private static int Theta0(int n) {
        return (n >>> 7 | n << 25) ^ (n >>> 18 | n << 14) ^ n >>> 3;
    }

    private static int Theta1(int n) {
        return (n >>> 17 | n << 15) ^ (n >>> 19 | n << 13) ^ n >>> 10;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n = n + 1;
        int n3 = n2 | (byArray[n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n = this.xOff;
        this.X[n] = n3;
        this.xOff = n + 1;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        if (((SHA256Digest)object).xOff > 14) {
            ((SHA256Digest)object).processBlock();
        }
        Object object = ((SHA256Digest)object).X;
        object[14] = (int)(l >>> 32);
        ((SHA256Digest)object).X[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA256Digest sHA256Digest = this;
        sHA256Digest.finish();
        Pack.intToBigEndian(sHA256Digest.H1, byArray, n);
        Pack.intToBigEndian(sHA256Digest.H2, byArray, n + 4);
        Pack.intToBigEndian(sHA256Digest.H3, byArray, n + 8);
        Pack.intToBigEndian(sHA256Digest.H4, byArray, n + 12);
        Pack.intToBigEndian(sHA256Digest.H5, byArray, n + 16);
        Pack.intToBigEndian(sHA256Digest.H6, byArray, n + 20);
        Pack.intToBigEndian(sHA256Digest.H7, byArray, n + 24);
        Pack.intToBigEndian(sHA256Digest.H8, byArray, n + 28);
        sHA256Digest.reset();
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1779033703;
        this.H2 = -1150833019;
        this.H3 = 1013904242;
        this.H4 = -1521486534;
        this.H5 = 1359893119;
        this.H6 = -1694144372;
        this.H7 = 528734635;
        this.H8 = 1541459225;
        this.xOff = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void processBlock() {
        int n;
        for (n = 16; n <= 63; ++n) {
            int[] nArray = this.X;
            this.X[n] = SHA256Digest.Theta1(this.X[n - 2]) + this.X[n - 7] + SHA256Digest.Theta0(nArray[n - 15]) + this.X[n - 16];
        }
        SHA256Digest sHA256Digest = this;
        n = sHA256Digest.H1;
        int n2 = sHA256Digest.H2;
        int n3 = sHA256Digest.H3;
        int n4 = sHA256Digest.H4;
        int n5 = sHA256Digest.H5;
        int n6 = sHA256Digest.H6;
        int n7 = sHA256Digest.H7;
        int n8 = sHA256Digest.H8;
        int n9 = 0;
        for (int k = 0; k < 8; ++k) {
            int n10 = n;
            int n11 = n2;
            int n12 = n3;
            int[] nArray = K;
            n8 = SHA256Digest.Sum1(n5) + SHA256Digest.Ch(n5, n6, n7) + K[n9] + this.X[n9] + n8;
            int n13 = n4 + n8;
            n3 = SHA256Digest.Sum0(n) + SHA256Digest.Maj(n, n2, n3) + n8;
            n8 = n9 + 1;
            n7 = SHA256Digest.Sum1(n13) + SHA256Digest.Ch(n13, n5, n6) + nArray[n8] + this.X[n8] + n7;
            n9 = n12 + n7;
            n2 = SHA256Digest.Sum0(n3) + SHA256Digest.Maj(n3, n, n2) + n7;
            n7 = n8 + 1;
            n6 = SHA256Digest.Sum1(n9) + SHA256Digest.Ch(n9, n13, n5) + nArray[n7] + this.X[n7] + n6;
            n8 = n11 + n6;
            n = SHA256Digest.Sum0(n2) + SHA256Digest.Maj(n2, n3, n) + n6;
            n6 = n7 + 1;
            n5 = SHA256Digest.Sum1(n8) + SHA256Digest.Ch(n8, n9, n13) + nArray[n6] + this.X[n6] + n5;
            n7 = n10 + n5;
            int n14 = SHA256Digest.Sum0(n) + SHA256Digest.Maj(n, n2, n3) + n5;
            n5 = n14;
            int n15 = n;
            int n16 = n2;
            int n17 = n3;
            n3 = n6 + 1;
            n6 = SHA256Digest.Sum1(n7) + SHA256Digest.Ch(n7, n8, n9) + nArray[n3] + this.X[n3] + n13;
            n13 = n17 + n6;
            n2 = SHA256Digest.Sum0(n5) + SHA256Digest.Maj(n5, n, n2) + n6;
            n6 = SHA256Digest.Sum1(n13) + SHA256Digest.Ch(n13, n7, n8) + nArray[++n3] + this.X[n3] + n9;
            n9 = n16 + n6;
            n = SHA256Digest.Sum0(n2) + SHA256Digest.Maj(n2, n5, n) + n6;
            n6 = SHA256Digest.Sum1(n9) + SHA256Digest.Ch(n9, n13, n7) + nArray[++n3] + this.X[n3] + n8;
            n8 = n15 + n6;
            n5 = SHA256Digest.Sum0(n) + SHA256Digest.Maj(n, n2, n5) + n6;
            n4 = SHA256Digest.Sum1(n8) + SHA256Digest.Ch(n8, n9, n13) + nArray[++n3] + this.X[n3] + n7;
            n6 = n14 + n4;
            n4 = SHA256Digest.Sum0(n5) + SHA256Digest.Maj(n5, n, n2) + n4;
            ++n3;
            int n18 = n4;
            int n19 = n5;
            int n20 = n6;
            int n21 = n8;
            int n22 = n9;
            n9 = n3;
            n8 = n13;
            n7 = n22;
            n6 = n21;
            n5 = n20;
            n4 = n2;
            n3 = n;
            n2 = n19;
            n = n18;
        }
        SHA256Digest sHA256Digest2 = this;
        sHA256Digest2.H1 += n;
        sHA256Digest2.H2 += n2;
        sHA256Digest2.H3 += n3;
        sHA256Digest2.H4 += n4;
        sHA256Digest2.H5 += n5;
        sHA256Digest2.H6 += n6;
        sHA256Digest2.H7 += n7;
        sHA256Digest2.H8 += n8;
        sHA256Digest2.xOff = 0;
        for (n = 0; n < 16; ++n) {
            this.X[n] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA256Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((SHA256Digest)memoable);
    }

    @Override
    public byte[] getEncodedState() {
        SHA256Digest sHA256Digest = this;
        byte[] byArray = new byte[sHA256Digest.xOff * 4 + 52];
        super.populateState(byArray);
        Pack.intToBigEndian(sHA256Digest.H1, byArray, 16);
        Pack.intToBigEndian(sHA256Digest.H2, byArray, 20);
        Pack.intToBigEndian(sHA256Digest.H3, byArray, 24);
        Pack.intToBigEndian(sHA256Digest.H4, byArray, 28);
        Pack.intToBigEndian(sHA256Digest.H5, byArray, 32);
        Pack.intToBigEndian(sHA256Digest.H6, byArray, 36);
        Pack.intToBigEndian(sHA256Digest.H7, byArray, 40);
        Pack.intToBigEndian(sHA256Digest.H8, byArray, 44);
        Pack.intToBigEndian(sHA256Digest.xOff, byArray, 48);
        for (int k = 0; k != this.xOff; ++k) {
            Pack.intToBigEndian(this.X[k], byArray, k * 4 + 52);
        }
        return byArray;
    }
}

